/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.transformation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.IdeaPluginKt;
import org.jetbrains.kotlinx.lincheck.transformation.FinalFields;
import org.jetbrains.kotlinx.lincheck.transformation.InstrumentationMode;
import org.jetbrains.kotlinx.lincheck.transformation.TransformationUtilsKt;
import org.jetbrains.kotlinx.lincheck.transformation.WrapMethodInIgnoredSectionTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.AtomicFieldUpdaterMethodTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.CoroutineCancellabilitySupportTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.CoverageBytecodeFilter;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.DeterministicHashCodeTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.DeterministicRandomTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.DeterministicTimeTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.MethodCallTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.MonitorTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.ObjectCreationTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.ParkingTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.SharedMemoryAccessTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.SynchronizedMethodTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.UnsafeMethodTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.VarHandleMethodTransformer;
import org.jetbrains.kotlinx.lincheck.transformation.transformers.WaitNotifyTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AnalyzerAdapter;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.TryCatchBlockSorter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005JE\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J?\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/LincheckClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "instrumentationMode", "Lorg/jetbrains/kotlinx/lincheck/transformation/InstrumentationMode;", "classVisitor", "(Lorg/jetbrains/kotlinx/lincheck/transformation/InstrumentationMode;Lorg/objectweb/asm/ClassVisitor;)V", "className", "", "classVersion", "", "fileName", "ideaPluginEnabled", "", "visit", "", "version", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "fieldName", "descriptor", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "methodName", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitSource", "source", "debug", "lincheck"})
public final class LincheckClassVisitor
extends ClassVisitor {
    @NotNull
    private final InstrumentationMode instrumentationMode;
    private final boolean ideaPluginEnabled;
    private int classVersion;
    @NotNull
    private String fileName;
    @NotNull
    private String className;

    public LincheckClassVisitor(@NotNull InstrumentationMode instrumentationMode, @NotNull ClassVisitor classVisitor) {
        Intrinsics.checkNotNullParameter((Object)((Object)instrumentationMode), (String)"instrumentationMode");
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        super(589824, classVisitor);
        this.instrumentationMode = instrumentationMode;
        this.ideaPluginEnabled = IdeaPluginKt.ideaPluginEnabled();
        this.fileName = "";
        this.className = "";
    }

    @NotNull
    public FieldVisitor visitField(int access, @NotNull String fieldName, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if ((access & 0x10) != 0) {
            FinalFields.INSTANCE.addFinalField(this.className, fieldName);
        } else {
            FinalFields.INSTANCE.addMutableField(this.className, fieldName);
        }
        FieldVisitor fieldVisitor = super.visitField(access, fieldName, descriptor, signature, value);
        Intrinsics.checkNotNullExpressionValue((Object)fieldVisitor, (String)"visitField(...)");
        return fieldVisitor;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
        Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
        this.className = name;
        this.classVersion = version;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(@NotNull String source, @Nullable String debug) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.fileName = source;
        super.visitSource(source, debug);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String methodName, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Object mv = null;
        mv = super.visitMethod(access, methodName, desc, signature, exceptions);
        if ((access & 0x100) != 0) {
            MethodVisitor methodVisitor = mv;
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
            return methodVisitor;
        }
        if (this.instrumentationMode == InstrumentationMode.STRESS) {
            MethodVisitor methodVisitor;
            if (!Intrinsics.areEqual((Object)methodName, (Object)"<clinit>") && !Intrinsics.areEqual((Object)methodName, (Object)"<init>")) {
                MethodVisitor methodVisitor2 = mv;
                Intrinsics.checkNotNullExpressionValue((Object)methodVisitor2, (String)"element");
                methodVisitor = (MethodVisitor)new CoroutineCancellabilitySupportTransformer(methodVisitor2, access, this.className, methodName, desc);
            } else {
                MethodVisitor methodVisitor3 = mv;
                Intrinsics.checkNotNull((Object)methodVisitor3);
                methodVisitor = methodVisitor3;
            }
            return methodVisitor;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"<clinit>") || this.ideaPluginEnabled && Intrinsics.areEqual((Object)methodName, (Object)"toString") && Intrinsics.areEqual((Object)desc, (Object)"()Ljava/lang/String;")) {
            MethodVisitor methodVisitor = mv;
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
            mv = new WrapMethodInIgnoredSectionTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(methodVisitor, access, methodName, desc));
            return mv;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"<init>")) {
            MethodVisitor methodVisitor = mv;
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
            mv = new ObjectCreationTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(methodVisitor, access, methodName, desc));
            return mv;
        }
        if (StringsKt.contains$default((CharSequence)this.className, (CharSequence)"ClassLoader", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)methodName, (Object)"loadClass")) {
                MethodVisitor methodVisitor = mv;
                Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
                mv = new WrapMethodInIgnoredSectionTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(methodVisitor, access, methodName, desc));
            }
            MethodVisitor methodVisitor = mv;
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
            return methodVisitor;
        }
        if (TransformationUtilsKt.isCoroutineInternalClass(this.className)) {
            MethodVisitor methodVisitor = mv;
            Intrinsics.checkNotNullExpressionValue((Object)methodVisitor, (String)"element");
            return methodVisitor;
        }
        mv = new JSRInlinerAdapter(mv, access, methodName, desc, signature, exceptions);
        mv = new TryCatchBlockSorter(mv, access, methodName, desc, signature, exceptions);
        mv = new CoroutineCancellabilitySupportTransformer((MethodVisitor)mv, access, this.className, methodName, desc);
        if ((access & 0x20) != 0) {
            mv = new SynchronizedMethodTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc), this.classVersion);
        }
        Object skipVisitor = mv;
        mv = new MethodCallTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new MonitorTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new WaitNotifyTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new ParkingTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new ObjectCreationTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new DeterministicHashCodeTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new DeterministicTimeTransformer(LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new DeterministicRandomTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new UnsafeMethodTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new AtomicFieldUpdaterMethodTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        mv = new VarHandleMethodTransformer(this.fileName, this.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        LincheckClassVisitor $this$visitMethod_u24lambda_u240 = this;
        boolean bl = false;
        SharedMemoryAccessTransformer sv = new SharedMemoryAccessTransformer($this$visitMethod_u24lambda_u240.fileName, $this$visitMethod_u24lambda_u240.className, methodName, LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        AnalyzerAdapter aa = new AnalyzerAdapter($this$visitMethod_u24lambda_u240.className, access, methodName, desc, (MethodVisitor)sv);
        sv.setAnalyzer(aa);
        mv = aa;
        mv = new CoverageBytecodeFilter(LincheckClassVisitor.visitMethod$newAdapter(skipVisitor, access, methodName, desc), LincheckClassVisitor.visitMethod$newAdapter(mv, access, methodName, desc));
        return mv;
    }

    private static final GeneratorAdapter visitMethod$newAdapter(MethodVisitor $this$visitMethod_u24newAdapter, int $access, String $methodName, String $desc) {
        return new GeneratorAdapter($this$visitMethod_u24newAdapter, $access, $methodName, $desc);
    }
}

