/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.transformation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.IdeaPluginKt;
import org.jetbrains.kotlinx.lincheck.transformation.CodeLocations;
import org.jetbrains.kotlinx.lincheck.transformation.TransformationUtilsKt;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u000fH\u0004J\b\u0010\u0017\u001a\u00020\u0014H\u0004J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/ManagedStrategyMethodVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "fileName", "", "className", "methodName", "adapter", "Lorg/objectweb/asm/commons/GeneratorAdapter;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/objectweb/asm/commons/GeneratorAdapter;)V", "getAdapter", "()Lorg/objectweb/asm/commons/GeneratorAdapter;", "getClassName", "()Ljava/lang/String;", "getFileName", "ideaPluginEnabled", "", "lineNumber", "", "getMethodName", "invokeBeforeEventIfPluginEnabled", "", "type", "setMethodEventId", "loadNewCodeLocationId", "visitLineNumber", "line", "start", "Lorg/objectweb/asm/Label;", "lincheck"})
public class ManagedStrategyMethodVisitor
extends MethodVisitor {
    @NotNull
    private final String fileName;
    @NotNull
    private final String className;
    @NotNull
    private final String methodName;
    @NotNull
    private final GeneratorAdapter adapter;
    private final boolean ideaPluginEnabled;
    private int lineNumber;

    public ManagedStrategyMethodVisitor(@NotNull String fileName, @NotNull String className, @NotNull String methodName, @NotNull GeneratorAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(589824, (MethodVisitor)adapter);
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.adapter = adapter;
        this.ideaPluginEnabled = IdeaPluginKt.ideaPluginEnabled();
    }

    @NotNull
    protected final String getFileName() {
        return this.fileName;
    }

    @NotNull
    protected final String getClassName() {
        return this.className;
    }

    @NotNull
    protected final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final GeneratorAdapter getAdapter() {
        return this.adapter;
    }

    protected final void invokeBeforeEventIfPluginEnabled(@NotNull String type, boolean setMethodEventId) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.ideaPluginEnabled) {
            TransformationUtilsKt.invokeBeforeEvent(this.adapter, type, setMethodEventId);
        }
    }

    public static /* synthetic */ void invokeBeforeEventIfPluginEnabled$default(ManagedStrategyMethodVisitor managedStrategyMethodVisitor, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invokeBeforeEventIfPluginEnabled");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        managedStrategyMethodVisitor.invokeBeforeEventIfPluginEnabled(string, bl);
    }

    protected final void loadNewCodeLocationId() {
        StackTraceElement stackTraceElement = new StackTraceElement(this.className, this.methodName, this.fileName, this.lineNumber);
        int codeLocationId = CodeLocations.newCodeLocation(stackTraceElement);
        this.adapter.push(codeLocationId);
    }

    public void visitLineNumber(int line, @NotNull Label start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        this.lineNumber = line;
        super.visitLineNumber(line, start);
    }
}

