/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.verifier.linearizability;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.Cancelled;
import org.jetbrains.kotlinx.lincheck.Result;
import org.jetbrains.kotlinx.lincheck.Suspended;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionResult;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionResultKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.execution.HBClock;
import org.jetbrains.kotlinx.lincheck.verifier.LTS;
import org.jetbrains.kotlinx.lincheck.verifier.TransitionInfo;
import org.jetbrains.kotlinx.lincheck.verifier.VerifierContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tB;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u0000*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/lincheck/verifier/linearizability/LinearizabilityContext;", "Lorg/jetbrains/kotlinx/lincheck/verifier/VerifierContext;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "results", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;", "state", "Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;", "Lorg/jetbrains/kotlinx/lincheck/verifier/LTS;", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;)V", "executed", "", "suspended", "", "tickets", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionResult;Lorg/jetbrains/kotlinx/lincheck/verifier/LTS$State;[I[Z[I)V", "hblegal", "", "threadId", "", "nextContext", "createContext", "Lorg/jetbrains/kotlinx/lincheck/verifier/TransitionInfo;", "lincheck"})
@SourceDebugExtension(value={"SMAP\nLinearizabilityVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearizabilityVerifier.kt\norg/jetbrains/kotlinx/lincheck/verifier/linearizability/LinearizabilityContext\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,107:1\n13404#2,3:108\n*S KotlinDebug\n*F\n+ 1 LinearizabilityVerifier.kt\norg/jetbrains/kotlinx/lincheck/verifier/linearizability/LinearizabilityContext\n*L\n79#1:108,3\n*E\n"})
public final class LinearizabilityContext
extends VerifierContext {
    public LinearizabilityContext(@NotNull ExecutionScenario scenario, @NotNull ExecutionResult results, @NotNull LTS.State state) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(scenario, results, state, null, null, null, 56, null);
    }

    public LinearizabilityContext(@NotNull ExecutionScenario scenario, @NotNull ExecutionResult results, @NotNull LTS.State state, @NotNull int[] executed, @NotNull boolean[] suspended, @NotNull int[] tickets) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)executed, (String)"executed");
        Intrinsics.checkNotNullParameter((Object)suspended, (String)"suspended");
        Intrinsics.checkNotNullParameter((Object)tickets, (String)"tickets");
        super(scenario, results, state, executed, suspended, tickets);
    }

    @Override
    @Nullable
    public LinearizabilityContext nextContext(int threadId) {
        boolean promptCancel;
        if (this.isCompleted(threadId)) {
            return null;
        }
        if (!this.hblegal(threadId)) {
            return null;
        }
        int actorId = this.getExecuted()[threadId];
        Actor actor = this.getScenario().getThreads().get(threadId).get(actorId);
        Result result2 = ExecutionResultKt.getThreadsResults(this.getResults()).get(threadId).get(actorId);
        Intrinsics.checkNotNull((Object)result2);
        Result expectedResult = result2;
        int ticket = this.getTickets()[threadId];
        boolean bl = promptCancel = actor.getPromptCancellation() && ticket != -1 && expectedResult == Cancelled.INSTANCE;
        if (this.getSuspended()[threadId] || promptCancel) {
            return actor.getCancelOnSuspension() && expectedResult == Cancelled.INSTANCE ? this.createContext(this.getState().nextByCancellation(actor, ticket), threadId) : null;
        }
        TransitionInfo transitionInfo2 = this.getState().next(actor, expectedResult, this.getTickets()[threadId]);
        return transitionInfo2 != null ? this.createContext(transitionInfo2, threadId) : null;
    }

    private final boolean hblegal(int threadId) {
        int actorId = this.getExecuted()[threadId];
        HBClock clocks = this.getResults().getThreadsResultsWithClock().get(threadId).get(actorId).getClockOnStart();
        int n = this.getScenario().getNThreads();
        for (int i = 0; i < n; ++i) {
            if (this.getExecuted()[i] >= clocks.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final LinearizabilityContext createContext(TransitionInfo $this$createContext, int threadId) {
        int n;
        int[] nArray = this.getExecuted();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] nextExecuted = nArray2;
        boolean[] blArray = this.getSuspended();
        boolean[] blArray2 = Arrays.copyOf(blArray, blArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)blArray2, (String)"copyOf(...)");
        boolean[] nextSuspended = blArray2;
        int[] nArray3 = this.getTickets();
        int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
        int[] nextTickets = nArray4;
        int n2 = nextTickets[threadId] = Intrinsics.areEqual((Object)$this$createContext.getResult(), (Object)Suspended.INSTANCE) ? $this$createContext.getTicket() : -1;
        if ($this$createContext.getRf() != null) {
            int[] $this$forEachIndexed$iv = nextTickets;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int item$iv : $this$forEachIndexed$iv) {
                void ticket;
                int n3 = index$iv++;
                int n4 = item$iv;
                int tid = n3;
                boolean bl = false;
                if (tid == threadId || ticket == -1) continue;
                nextTickets[tid] = $this$createContext.getRf()[ticket];
            }
        }
        nextSuspended[threadId] = Intrinsics.areEqual((Object)$this$createContext.getResult(), (Object)Suspended.INSTANCE);
        IntRange intRange = this.getThreads();
        int tid = intRange.getFirst();
        if (tid <= (n = intRange.getLast())) {
            while (true) {
                if ($this$createContext.getResumedTickets().contains(nextTickets[tid])) {
                    nextSuspended[tid] = false;
                }
                if (tid == n) break;
                ++tid;
            }
        }
        if ($this$createContext.getOperationCompleted()) {
            int n5 = nextExecuted[threadId];
            nextExecuted[threadId] = n5 + 1;
        }
        ExecutionScenario executionScenario = this.getScenario();
        LTS.State state = $this$createContext.getNextState();
        ExecutionResult executionResult = this.getResults();
        return new LinearizabilityContext(executionScenario, executionResult, state, nextExecuted, nextSuspended, nextTickets);
    }
}

