/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.default;

import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multik.api.DefaultEngineType;
import org.jetbrains.kotlinx.multik.api.Engine;
import org.jetbrains.kotlinx.multik.api.EngineFactory;
import org.jetbrains.kotlinx.multik.api.EngineType;
import org.jetbrains.kotlinx.multik.api.KEEngineType;
import org.jetbrains.kotlinx.multik.api.NativeEngineType;
import org.jetbrains.kotlinx.multik.default.DefaultEngineFactory;
import org.jetbrains.kotlinx.multik.kotlin.KEEngine;
import org.jetbrains.kotlinx.multik.openblas.JvmNativeEngine;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/multik/default/DefaultEngineFactory;", "Lorg/jetbrains/kotlinx/multik/api/EngineFactory;", "()V", "arch", "", "getArch", "()Ljava/lang/String;", "os", "getOs", "supportNative", "", "getSupportNative", "()Z", "supportNative$delegate", "Lkotlin/Lazy;", "getEngine", "Lorg/jetbrains/kotlinx/multik/api/Engine;", "type", "Lorg/jetbrains/kotlinx/multik/api/EngineType;", "multik-default"})
public final class DefaultEngineFactory
implements EngineFactory {
    @NotNull
    public static final DefaultEngineFactory INSTANCE = new DefaultEngineFactory();
    @NotNull
    private static final Lazy supportNative$delegate = LazyKt.lazy((Function0)supportNative.2.INSTANCE);

    private DefaultEngineFactory() {
    }

    @NotNull
    public Engine getEngine(@Nullable EngineType type) {
        Engine engine;
        EngineType engineType = type;
        if (engineType == null) {
            throw new IllegalStateException("Pass NativeEngineType of KEEngineType".toString());
        }
        if (Intrinsics.areEqual((Object)engineType, (Object)KEEngineType.INSTANCE)) {
            engine = (Engine)new KEEngine();
        } else if (Intrinsics.areEqual((Object)engineType, (Object)NativeEngineType.INSTANCE)) {
            engine = this.getSupportNative() ? (Engine)new JvmNativeEngine() : (Engine)new KEEngine();
        } else {
            if (Intrinsics.areEqual((Object)engineType, (Object)DefaultEngineType.INSTANCE)) {
                throw new IllegalStateException("Default Engine doesn't link to Default Engine".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return engine;
    }

    private final boolean getSupportNative() {
        Lazy lazy = supportNative$delegate;
        return (Boolean)lazy.getValue();
    }

    private final String getOs() {
        String string;
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String osProperty = string3;
        if (StringsKt.contains$default((CharSequence)osProperty, (CharSequence)"mac", (boolean)false, (int)2, null)) {
            string = "macos";
        } else {
            String string4 = System.getProperty("java.vm.name");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
            string = StringsKt.contains$default((CharSequence)string4, (CharSequence)"Dalvik", (boolean)false, (int)2, null) ? "android" : (StringsKt.contains$default((CharSequence)osProperty, (CharSequence)"nux", (boolean)false, (int)2, null) ? "linux" : (StringsKt.contains$default((CharSequence)osProperty, (CharSequence)"win", (boolean)false, (int)2, null) ? "mingw" : "Unknown os"));
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getArch() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String arch = string2;
        switch (arch.hashCode()) {
            case -1221096139: {
                if (arch.equals("aarch64")) return "Arm64";
                return "Unknown arch";
            }
            case 93086174: {
                if (arch.equals("armv8")) return "Arm64";
                return "Unknown arch";
            }
            case -806050265: {
                if (arch.equals("x86_64")) return "X64";
                return "Unknown arch";
            }
            case -806098315: {
                if (arch.equals("x86-64")) return "X64";
                return "Unknown arch";
            }
            case 93084186: {
                if (arch.equals("arm64")) return "Arm64";
                return "Unknown arch";
            }
            case 117046: {
                if (arch.equals("x64")) return "X64";
                return "Unknown arch";
            }
            case 92926582: {
                if (!arch.equals("amd64")) return "Unknown arch";
                return "X64";
            }
        }
        return "Unknown arch";
    }

    public static final /* synthetic */ String access$getOs(DefaultEngineFactory $this) {
        return $this.getOs();
    }

    public static final /* synthetic */ String access$getArch(DefaultEngineFactory $this) {
        return $this.getArch();
    }
}

