/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.kotlin.linalg.UtilsKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.Complex;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDoubleArray;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloatArray;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.Dimension;
import org.jetbrains.kotlinx.multik.ndarray.data.ImmutableMemoryView;
import org.jetbrains.kotlinx.multik.ndarray.data.MemoryViewKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a`\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u0000\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u0000\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u0000\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u0000\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001aP\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\u0016\"\b\b\u0000\u0010\u0014*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0019H\u0000\u001aL\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\u0016\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0019H\u0002\u001a`\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a`\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001aP\u0010\u001c\u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\u0016\"\b\b\u0000\u0010\u0014*\u00020\u001f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u0019H\u0000\u001aP\u0010 \u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\"\"\b\b\u0000\u0010\u0014*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0019H\u0000\u001aL\u0010#\u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\"\"\u0004\b\u0000\u0010\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0019H\u0002\u001aP\u0010$\u001a\u0018\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0013j\b\u0012\u0004\u0012\u0002H\u0014`\"\"\b\b\u0000\u0010\u0014*\u00020\u001f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u00150\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0019H\u0000\u001a@\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010%\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010%\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010%\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010%\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010%\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a?\u0010%\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0019H\u0000\u00a2\u0006\u0002\u0010-\u001a@\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a@\u0010.\u001a\u0002002\u0006\u0010\u0002\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a?\u0010.\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u001f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020!0\u0019H\u0000\u00a2\u0006\u0002\u00101\u001aP\u00102\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001aP\u00102\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000fH\u0002\u001aP\u00102\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0010H\u0002\u001aP\u00102\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001aP\u00102\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0011H\u0002\u001aP\u00102\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0012H\u0002\u001aP\u00103\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u001dH\u0002\u001aP\u00103\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u001eH\u0002\u00a8\u00064"}, d2={"dotMatrix", "", "left", "leftOffset", "", "leftStrides", "", "right", "rightOffset", "rightStrides", "n", "m", "t", "destination", "dStrides", "", "", "", "", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "T", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2Array;", "", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "b", "dotMatrixCommon", "dotMatrixComplex", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDoubleArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloatArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/Complex;", "dotMatrixToVector", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1Array;", "dotMatrixToVectorCommon", "dotMatrixToVectorComplex", "dotVecToVec", "", "lStride", "rStride", "", "", "", "", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Ljava/lang/Number;", "dotVecToVecComplex", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "(Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;)Lorg/jetbrains/kotlinx/multik/ndarray/complex/Complex;", "dotVector", "dotVectorComplex", "multik-kotlin"})
public final class DotKt {
    @NotNull
    public static final <T extends Number> NDArray<T, D2> dotMatrix(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D2> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixCommon(a, b);
    }

    @NotNull
    public static final <T extends Complex> NDArray<T, D2> dotMatrixComplex(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D2> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixCommon(a, b);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> NDArray<T, D2> dotMatrixCommon(MultiArray<T, D2> a, MultiArray<T, D2> b) {
        int[] newShape;
        UtilsKt.requireDotShape(a.getShape(), b.getShape());
        int[] nArray = new int[]{a.getShape()[0], b.getShape()[1]};
        int[] $this$reduce$iv = newShape = nArray;
        boolean $i$f$reduce = false;
        if ($this$reduce$iv.length == 0) {
            throw new UnsupportedOperationException("Empty array can't be reduced.");
        }
        int accumulator$iv = $this$reduce$iv[0];
        IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((int[])$this$reduce$iv)).iterator();
        while (intIterator.hasNext()) {
            void p1;
            int index$iv = intIterator.nextInt();
            int n = $this$reduce$iv[index$iv];
            int p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0 * p1;
        }
        int size = accumulator$iv;
        NDArray ret = new NDArray((ImmutableMemoryView)MemoryViewKt.initMemoryView((int)size, (DataType)a.getDtype()), 0, newShape, null, (Dimension)D2.Companion, null, 40, null);
        switch (WhenMappings.$EnumSwitchMapping$0[a.getDtype().ordinal()]) {
            case 1: {
                DotKt.dotMatrix(a.getData().getFloatArray(), a.getOffset(), a.getStrides(), b.getData().getFloatArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getFloatArray(), ret.getStrides()[0]);
                break;
            }
            case 2: {
                DotKt.dotMatrix(a.getData().getIntArray(), a.getOffset(), a.getStrides(), b.getData().getIntArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getIntArray(), ret.getStrides()[0]);
                break;
            }
            case 3: {
                DotKt.dotMatrix(a.getData().getDoubleArray(), a.getOffset(), a.getStrides(), b.getData().getDoubleArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getDoubleArray(), ret.getStrides()[0]);
                break;
            }
            case 4: {
                DotKt.dotMatrix(a.getData().getLongArray(), a.getOffset(), a.getStrides(), b.getData().getLongArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getLongArray(), ret.getStrides()[0]);
                break;
            }
            case 5: {
                DotKt.dotMatrixComplex(a.getData().getComplexDoubleArray(), a.getOffset(), a.getStrides(), b.getData().getComplexDoubleArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getComplexDoubleArray(), ret.getStrides()[0]);
                break;
            }
            case 6: {
                DotKt.dotMatrixComplex(a.getData().getComplexFloatArray(), a.getOffset(), a.getStrides(), b.getData().getComplexFloatArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getComplexFloatArray(), ret.getStrides()[0]);
                break;
            }
            case 7: {
                DotKt.dotMatrix(a.getData().getShortArray(), a.getOffset(), a.getStrides(), b.getData().getShortArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getShortArray(), ret.getStrides()[0]);
                break;
            }
            case 8: {
                DotKt.dotMatrix(a.getData().getByteArray(), a.getOffset(), a.getStrides(), b.getData().getByteArray(), b.getOffset(), b.getStrides(), newShape[0], newShape[1], a.getShape()[1], ret.getData().getByteArray(), ret.getStrides()[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return ret;
    }

    private static final byte[] dotMatrix(byte[] left, int leftOffset, int[] leftStrides, byte[] right, int rightOffset, int[] rightStrides, int n, int m, int t, byte[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                byte ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    destination[dInd + j] = (byte)(destination[dInd + j] + ceil * right[rInd + j * rightStride_1]);
                }
            }
        }
        return destination;
    }

    private static final short[] dotMatrix(short[] left, int leftOffset, int[] leftStrides, short[] right, int rightOffset, int[] rightStrides, int n, int m, int t, short[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                short ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    destination[dInd + j] = (short)(destination[dInd + j] + ceil * right[rInd + j * rightStride_1]);
                }
            }
        }
        return destination;
    }

    private static final int[] dotMatrix(int[] left, int leftOffset, int[] leftStrides, int[] right, int rightOffset, int[] rightStrides, int n, int m, int t, int[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                int ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination[n2] = destination[n2] + ceil * right[rInd + j * rightStride_1];
                }
            }
        }
        return destination;
    }

    private static final long[] dotMatrix(long[] left, int leftOffset, int[] leftStrides, long[] right, int rightOffset, int[] rightStrides, int n, int m, int t, long[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                long ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination[n2] = destination[n2] + ceil * right[rInd + j * rightStride_1];
                }
            }
        }
        return destination;
    }

    private static final float[] dotMatrix(float[] left, int leftOffset, int[] leftStrides, float[] right, int rightOffset, int[] rightStrides, int n, int m, int t, float[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                float ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination[n2] = destination[n2] + ceil * right[rInd + j * rightStride_1];
                }
            }
        }
        return destination;
    }

    private static final double[] dotMatrix(double[] left, int leftOffset, int[] leftStrides, double[] right, int rightOffset, int[] rightStrides, int n, int m, int t, double[] destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                double ceil = left[lInd + k * leftStride_1];
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination[n2] = destination[n2] + ceil * right[rInd + j * rightStride_1];
                }
            }
        }
        return destination;
    }

    private static final ComplexDoubleArray dotMatrixComplex(ComplexDoubleArray left, int leftOffset, int[] leftStrides, ComplexDoubleArray right, int rightOffset, int[] rightStrides, int n, int m, int t, ComplexDoubleArray destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                ComplexDouble ceil = left.get(lInd + k * leftStride_1);
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination.set(n2, destination.get(n2).plus(ceil.times(right.get(rInd + j * rightStride_1))));
                }
            }
        }
        return destination;
    }

    private static final ComplexFloatArray dotMatrixComplex(ComplexFloatArray left, int leftOffset, int[] leftStrides, ComplexFloatArray right, int rightOffset, int[] rightStrides, int n, int m, int t, ComplexFloatArray destination, int dStrides) {
        int leftStride_0 = leftStrides[0];
        int leftStride_1 = leftStrides[1];
        int rightStride_0 = rightStrides[0];
        int rightStride_1 = rightStrides[1];
        for (int i = 0; i < n; ++i) {
            int dInd = i * dStrides;
            int lInd = i * leftStride_0 + leftOffset;
            for (int k = 0; k < t; ++k) {
                ComplexFloat ceil = left.get(lInd + k * leftStride_1);
                int rInd = k * rightStride_0 + rightOffset;
                for (int j = 0; j < m; ++j) {
                    int n2 = dInd + j;
                    destination.set(n2, destination.get(n2).plus(ceil.times(right.get(rInd + j * rightStride_1))));
                }
            }
        }
        return destination;
    }

    @NotNull
    public static final <T extends Number> NDArray<T, D1> dotMatrixToVector(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixToVectorCommon(a, b);
    }

    @NotNull
    public static final <T extends Complex> NDArray<T, D1> dotMatrixToVectorComplex(@NotNull MultiArray<T, D2> a, @NotNull MultiArray<T, D1> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DotKt.dotMatrixToVectorCommon(a, b);
    }

    private static final <T> NDArray<T, D1> dotMatrixToVectorCommon(MultiArray<T, D2> a, MultiArray<T, D1> b) {
        UtilsKt.requireDotShape(a.getShape(), b.getShape());
        int[] nArray = new int[]{a.getShape()[0]};
        int[] newShape = nArray;
        NDArray ret = new NDArray((ImmutableMemoryView)MemoryViewKt.initMemoryView((int)newShape[0], (DataType)a.getDtype()), 0, newShape, null, (Dimension)D1.Companion, null, 40, null);
        switch (WhenMappings.$EnumSwitchMapping$0[a.getDtype().ordinal()]) {
            case 1: {
                DotKt.dotVector(a.getData().getFloatArray(), a.getOffset(), a.getStrides(), b.getData().getFloatArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getFloatArray());
                break;
            }
            case 2: {
                DotKt.dotVector(a.getData().getIntArray(), a.getOffset(), a.getStrides(), b.getData().getIntArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getIntArray());
                break;
            }
            case 3: {
                DotKt.dotVector(a.getData().getDoubleArray(), a.getOffset(), a.getStrides(), b.getData().getDoubleArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getDoubleArray());
                break;
            }
            case 4: {
                DotKt.dotVector(a.getData().getLongArray(), a.getOffset(), a.getStrides(), b.getData().getLongArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getLongArray());
                break;
            }
            case 5: {
                DotKt.dotVectorComplex(a.getData().getComplexDoubleArray(), a.getOffset(), a.getStrides(), b.getData().getComplexDoubleArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getComplexDoubleArray());
                break;
            }
            case 6: {
                DotKt.dotVectorComplex(a.getData().getComplexFloatArray(), a.getOffset(), a.getStrides(), b.getData().getComplexFloatArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getComplexFloatArray());
                break;
            }
            case 7: {
                DotKt.dotVector(a.getData().getShortArray(), a.getOffset(), a.getStrides(), b.getData().getShortArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getShortArray());
                break;
            }
            case 8: {
                DotKt.dotVector(a.getData().getByteArray(), a.getOffset(), a.getStrides(), b.getData().getByteArray(), b.getOffset(), b.getStrides()[0], newShape[0], b.getShape()[0], ret.getData().getByteArray());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return ret;
    }

    private static final float[] dotVector(float[] left, int leftOffset, int[] leftStrides, float[] right, int rightOffset, int rStride, int n, int m, float[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination[n2] = destination[n2] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset];
            }
        }
        return destination;
    }

    private static final int[] dotVector(int[] left, int leftOffset, int[] leftStrides, int[] right, int rightOffset, int rStride, int n, int m, int[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination[n2] = destination[n2] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset];
            }
        }
        return destination;
    }

    private static final double[] dotVector(double[] left, int leftOffset, int[] leftStrides, double[] right, int rightOffset, int rStride, int n, int m, double[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination[n2] = destination[n2] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset];
            }
        }
        return destination;
    }

    private static final long[] dotVector(long[] left, int leftOffset, int[] leftStrides, long[] right, int rightOffset, int rStride, int n, int m, long[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination[n2] = destination[n2] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset];
            }
        }
        return destination;
    }

    private static final short[] dotVector(short[] left, int leftOffset, int[] leftStrides, short[] right, int rightOffset, int rStride, int n, int m, short[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                destination[i] = (short)(destination[i] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset]);
            }
        }
        return destination;
    }

    private static final byte[] dotVector(byte[] left, int leftOffset, int[] leftStrides, byte[] right, int rightOffset, int rStride, int n, int m, byte[] destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                destination[i] = (byte)(destination[i] + left[lInd + j * lStride_1] * right[j * rStride + rightOffset]);
            }
        }
        return destination;
    }

    private static final ComplexDoubleArray dotVectorComplex(ComplexDoubleArray left, int leftOffset, int[] leftStrides, ComplexDoubleArray right, int rightOffset, int rStride, int n, int m, ComplexDoubleArray destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination.set(n2, destination.get(n2).plus(left.get(lInd + j * lStride_1).times(right.get(j * rStride + rightOffset))));
            }
        }
        return destination;
    }

    private static final ComplexFloatArray dotVectorComplex(ComplexFloatArray left, int leftOffset, int[] leftStrides, ComplexFloatArray right, int rightOffset, int rStride, int n, int m, ComplexFloatArray destination) {
        int lStride_0 = leftStrides[0];
        int lStride_1 = leftStrides[1];
        for (int i = 0; i < n; ++i) {
            int lInd = i * lStride_0 + leftOffset;
            for (int j = 0; j < m; ++j) {
                int n2 = i;
                destination.set(n2, destination.get(n2).plus(left.get(lInd + j * lStride_1).times(right.get(j * rStride + rightOffset))));
            }
        }
        return destination;
    }

    @NotNull
    public static final <T extends Number> T dotVecToVec(@NotNull MultiArray<T, D1> a, @NotNull MultiArray<T, D1> b) {
        Number number;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        switch (WhenMappings.$EnumSwitchMapping$0[a.getDtype().ordinal()]) {
            case 1: {
                number = Float.valueOf(DotKt.dotVecToVec(a.getData().getFloatArray(), a.getOffset(), a.getStrides()[0], b.getData().getFloatArray(), b.getOffset(), b.getStrides()[0], a.getSize()));
                break;
            }
            case 2: {
                number = DotKt.dotVecToVec(a.getData().getIntArray(), a.getOffset(), a.getStrides()[0], b.getData().getIntArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            case 3: {
                number = DotKt.dotVecToVec(a.getData().getDoubleArray(), a.getOffset(), a.getStrides()[0], b.getData().getDoubleArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            case 4: {
                number = DotKt.dotVecToVec(a.getData().getLongArray(), a.getOffset(), a.getStrides()[0], b.getData().getLongArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            case 7: {
                number = DotKt.dotVecToVec(a.getData().getShortArray(), a.getOffset(), a.getStrides()[0], b.getData().getShortArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            case 8: {
                number = DotKt.dotVecToVec(a.getData().getByteArray(), a.getOffset(), a.getStrides()[0], b.getData().getByteArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return (T)number;
    }

    @NotNull
    public static final <T extends Complex> T dotVecToVecComplex(@NotNull MultiArray<T, D1> a, @NotNull MultiArray<T, D1> b) {
        Complex complex;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        switch (WhenMappings.$EnumSwitchMapping$0[a.getDtype().ordinal()]) {
            case 6: {
                complex = (Complex)DotKt.dotVecToVecComplex(a.getData().getComplexFloatArray(), a.getOffset(), a.getStrides()[0], b.getData().getComplexFloatArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            case 5: {
                complex = (Complex)DotKt.dotVecToVecComplex(a.getData().getComplexDoubleArray(), a.getOffset(), a.getStrides()[0], b.getData().getComplexDoubleArray(), b.getOffset(), b.getStrides()[0], a.getSize());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Intrinsics.checkNotNull((Object)complex, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.multik.kotlin.linalg.DotKt.dotVecToVecComplex");
        return (T)complex;
    }

    private static final float dotVecToVec(float[] left, int leftOffset, int lStride, float[] right, int rightOffset, int rStride, int n) {
        float ret = 0.0f;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return ret;
    }

    private static final int dotVecToVec(int[] left, int leftOffset, int lStride, int[] right, int rightOffset, int rStride, int n) {
        int ret = 0;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return ret;
    }

    private static final double dotVecToVec(double[] left, int leftOffset, int lStride, double[] right, int rightOffset, int rStride, int n) {
        double ret = 0.0;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return ret;
    }

    private static final long dotVecToVec(long[] left, int leftOffset, int lStride, long[] right, int rightOffset, int rStride, int n) {
        long ret = 0L;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return ret;
    }

    private static final short dotVecToVec(short[] left, int leftOffset, int lStride, short[] right, int rightOffset, int rStride, int n) {
        int ret = 0;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return (short)ret;
    }

    private static final byte dotVecToVec(byte[] left, int leftOffset, int lStride, byte[] right, int rightOffset, int rStride, int n) {
        int ret = 0;
        for (int i = 0; i < n; ++i) {
            ret += left[leftOffset + lStride * i] * right[rightOffset + rStride * i];
        }
        return (byte)ret;
    }

    private static final ComplexFloat dotVecToVecComplex(ComplexFloatArray left, int leftOffset, int lStride, ComplexFloatArray right, int rightOffset, int rStride, int n) {
        ComplexFloat ret = ComplexFloat.Companion.getZero();
        for (int i = 0; i < n; ++i) {
            ret = ret.plus(left.get(leftOffset + lStride * i).times(right.get(rightOffset + rStride * i)));
        }
        return ret;
    }

    private static final ComplexDouble dotVecToVecComplex(ComplexDoubleArray left, int leftOffset, int lStride, ComplexDoubleArray right, int rightOffset, int rStride, int n) {
        ComplexDouble ret = ComplexDouble.Companion.getZero();
        for (int i = 0; i < n; ++i) {
            ret = ret.plus(left.get(leftOffset + lStride * i).times(right.get(rightOffset + rStride * i)));
        }
        return ret;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            nArray[DataType.FloatDataType.ordinal()] = 1;
            nArray[DataType.IntDataType.ordinal()] = 2;
            nArray[DataType.DoubleDataType.ordinal()] = 3;
            nArray[DataType.LongDataType.ordinal()] = 4;
            nArray[DataType.ComplexDoubleDataType.ordinal()] = 5;
            nArray[DataType.ComplexFloatDataType.ordinal()] = 6;
            nArray[DataType.ShortDataType.ordinal()] = 7;
            nArray[DataType.ByteDataType.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

