/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.CreateNDArrayKt;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.kotlin.linalg.QrFactorizationKt;
import org.jetbrains.kotlinx.multik.kotlin.linalg.UtilsKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0000\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u0005\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00050\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0007H\u0000\u001aT\u0010\b\u001a:\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\t`\u0005\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0002j\b\u0012\u0004\u0012\u00020\t`\u00050\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0007H\u0000\u00a8\u0006\n"}, d2={"upperHessenbergDouble", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2Array;", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "upperHessenbergFloat", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "multik-kotlin"})
public final class HessenbergFormKt {
    @NotNull
    public static final Pair<NDArray<ComplexFloat, D2>, NDArray<ComplexFloat, D2>> upperHessenbergFloat(@NotNull MultiArray<ComplexFloat, D2> a) {
        int i;
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int[] nArray = a.getShape();
        int n = nArray[0];
        int m = nArray[1];
        Multik $this$identity$iv = Multik.INSTANCE;
        boolean $i$f$identity = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(ComplexFloat.class);
        boolean $i$f$ofKClass = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        DataType dtype$iv = dataType;
        NDArray<ComplexFloat, D2> id = CreateNDArrayKt.identity((Multik)$this$identity$iv, (int)n, (DataType)dtype$iv);
        NDArray<ComplexFloat, D2> ans2 = (NDArray<ComplexFloat, D2>)a;
        int this_$iv$iv = n - 1;
        for (i = 1; i < this_$iv$iv; ++i) {
            int j1;
            int i1;
            Pair<ComplexFloat, NDArray<ComplexFloat, D1>> pair = QrFactorizationKt.householderTransformComplexFloat((MultiArray<ComplexFloat, D2>)MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(i - 1, m))));
            ComplexFloat tau = (ComplexFloat)pair.component1();
            NDArray v = (NDArray)pair.component2();
            MultiArray submatrix = MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(i - 1, m)));
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexFloat((MultiArray<ComplexFloat, D2>)submatrix, tau, (MultiArray<ComplexFloat, D1>)((MultiArray)v));
            for (i1 = i; i1 < n; ++i1) {
                for (j1 = i - 1; j1 < m; ++j1) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i1, (int)j1, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)(j1 - (i - 1))));
                }
            }
            ans2 = UtilsKt.conjTransposeFloat(ans2);
            submatrix = MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(0, m)));
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexFloat((MultiArray<ComplexFloat, D2>)submatrix, tau, (MultiArray<ComplexFloat, D1>)((MultiArray)v));
            for (i1 = i; i1 < n; ++i1) {
                for (j1 = 0; j1 < m; ++j1) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i1, (int)j1, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)j1));
                }
            }
            ans2 = UtilsKt.conjTransposeFloat(ans2);
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexFloat((MultiArray<ComplexFloat, D2>)MultiArraysKt.get14((MultiArray)((MultiArray)id), (ClosedRange)((ClosedRange)new IntRange(i, id.getShape()[0])), (ClosedRange)((ClosedRange)new IntRange(0, id.getShape()[1]))), tau, (MultiArray<ComplexFloat, D1>)((MultiArray)v));
            int n2 = id.getShape()[0];
            for (i1 = i; i1 < n2; ++i1) {
                int n3 = id.getShape()[1];
                for (int j12 = 0; j12 < n3; ++j12) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)id), (int)i1, (int)j12, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)j12));
                }
            }
        }
        id = UtilsKt.conjTransposeFloat(id);
        for (i = 2; i < n; ++i) {
            int n4 = i - 1;
            for (int j = 0; j < n4; ++j) {
                MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i, (int)j, (Object)ComplexFloat.Companion.getZero());
            }
        }
        return new Pair(id, (Object)ans2);
    }

    @NotNull
    public static final Pair<NDArray<ComplexDouble, D2>, NDArray<ComplexDouble, D2>> upperHessenbergDouble(@NotNull MultiArray<ComplexDouble, D2> a) {
        int i;
        DataType dataType;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        int[] nArray = a.getShape();
        int n = nArray[0];
        int m = nArray[1];
        Multik $this$identity$iv = Multik.INSTANCE;
        boolean $i$f$identity = false;
        DataType.Companion companion = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(ComplexDouble.class);
        boolean $i$f$ofKClass = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        DataType dtype$iv = dataType;
        NDArray<ComplexDouble, D2> id = CreateNDArrayKt.identity((Multik)$this$identity$iv, (int)n, (DataType)dtype$iv);
        NDArray<ComplexDouble, D2> ans2 = (NDArray<ComplexDouble, D2>)a;
        int this_$iv$iv = n - 1;
        for (i = 1; i < this_$iv$iv; ++i) {
            int j1;
            int i1;
            Pair<ComplexDouble, NDArray<ComplexDouble, D1>> pair = QrFactorizationKt.householderTransformComplexDouble((MultiArray<ComplexDouble, D2>)MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(i - 1, m))));
            ComplexDouble tau = (ComplexDouble)pair.component1();
            NDArray v = (NDArray)pair.component2();
            MultiArray submatrix = MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(i - 1, m)));
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexDouble((MultiArray<ComplexDouble, D2>)submatrix, tau, (MultiArray<ComplexDouble, D1>)((MultiArray)v));
            for (i1 = i; i1 < n; ++i1) {
                for (j1 = i - 1; j1 < m; ++j1) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i1, (int)j1, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)(j1 - (i - 1))));
                }
            }
            ans2 = UtilsKt.conjTransposeDouble(ans2);
            submatrix = MultiArraysKt.get14((MultiArray)((MultiArray)ans2), (ClosedRange)((ClosedRange)new IntRange(i, n)), (ClosedRange)((ClosedRange)new IntRange(0, m)));
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexDouble((MultiArray<ComplexDouble, D2>)submatrix, tau, (MultiArray<ComplexDouble, D1>)((MultiArray)v));
            for (i1 = i; i1 < n; ++i1) {
                for (j1 = 0; j1 < m; ++j1) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i1, (int)j1, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)j1));
                }
            }
            ans2 = UtilsKt.conjTransposeDouble(ans2);
            submatrix = (MultiArray)QrFactorizationKt.applyHouseholderComplexDouble((MultiArray<ComplexDouble, D2>)MultiArraysKt.get14((MultiArray)((MultiArray)id), (ClosedRange)((ClosedRange)new IntRange(i, id.getShape()[0])), (ClosedRange)((ClosedRange)new IntRange(0, id.getShape()[1]))), tau, (MultiArray<ComplexDouble, D1>)((MultiArray)v));
            int n2 = id.getShape()[0];
            for (i1 = i; i1 < n2; ++i1) {
                int n3 = id.getShape()[1];
                for (int j12 = 0; j12 < n3; ++j12) {
                    MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)id), (int)i1, (int)j12, (Object)MultiArraysKt.get2((MultiArray)submatrix, (int)(i1 - i), (int)j12));
                }
            }
        }
        id = UtilsKt.conjTransposeDouble(id);
        for (i = 2; i < n; ++i) {
            int n4 = i - 1;
            for (int j = 0; j < n4; ++j) {
                MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i, (int)j, (Object)ComplexDouble.Companion.getZero());
            }
        }
        return new Pair(id, (Object)ans2);
    }
}

