/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0000\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a@\u0010\u0000\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\u000f"}, d2={"norm", "", "mat", "", "matOffset", "", "matStrides", "", "n", "m", "power", "consistent", "", "", "", "multik-kotlin"})
public final class NormKt {
    public static final float norm(@NotNull float[] mat, int matOffset, @NotNull int[] matStrides, int n, int m, int power, boolean consistent) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)matStrides, (String)"matStrides");
        double result = 0.0;
        int matStride_0 = matStrides[0];
        int matStride_1 = matStrides[1];
        if (consistent) {
            for (float element : mat) {
                result += (double)((float)Math.pow(Math.abs(element), power));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int matInd = i * matStride_0 + matOffset;
                for (int k = 0; k < m; ++k) {
                    float absValue = Math.abs(mat[matInd + k * matStride_1]);
                    result += (double)((float)Math.pow(absValue, power));
                }
            }
        }
        return (float)Math.pow(result, 1.0 / (double)power);
    }

    /*
     * WARNING - void declaration
     */
    public static final double norm(@NotNull double[] mat, int matOffset, @NotNull int[] matStrides, int n, int m, int power, boolean consistent) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        Intrinsics.checkNotNullParameter((Object)matStrides, (String)"matStrides");
        double result = 0.0;
        int matStride_0 = matStrides[0];
        int matStride_1 = matStrides[1];
        if (consistent) {
            double[] dArray = mat;
            double d = 0.0;
            int n2 = dArray.length;
            for (int i = 0; i < n2; ++i) {
                void it;
                double d2;
                double d3 = d2 = dArray[i];
                double d4 = d;
                boolean bl = false;
                double d5 = Math.pow(Math.abs((double)it), power);
                d = d4 + d5;
            }
            result = d;
        } else {
            for (int i = 0; i < n; ++i) {
                int matInd = i * matStride_0 + matOffset;
                for (int k = 0; k < m; ++k) {
                    double absValue = Math.abs(mat[matInd + k * matStride_1]);
                    result += Math.pow(absValue, power);
                }
            }
        }
        return Math.pow(result, 1.0 / (double)power);
    }
}

