/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.multik.kotlin.linalg;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.CreateNDArrayKt;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.D1;
import org.jetbrains.kotlinx.multik.ndarray.data.D2;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArraysKt;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a`\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u0015H\u0080\b\u00f8\u0001\u0000\u001a3\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0001`\u0019*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180\u0017H\u0001\u00a2\u0006\u0002\b\u001a\u001a3\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0003`\u0019*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017H\u0001\u00a2\u0006\u0002\b\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"csqrt", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexDouble;", "a", "Lorg/jetbrains/kotlinx/multik/ndarray/complex/ComplexFloat;", "requireDotShape", "", "aShape", "", "bShape", "requireSquare", "shape", "swapLines", "rowPerm", "Lorg/jetbrains/kotlinx/multik/ndarray/data/MultiArray;", "", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D1;", "from1", "to1", "from2", "to2", "swap", "Lkotlin/Function2;", "conjTranspose", "Lorg/jetbrains/kotlinx/multik/ndarray/data/NDArray;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2;", "Lorg/jetbrains/kotlinx/multik/ndarray/data/D2Array;", "conjTransposeDouble", "conjTransposeFloat", "multik-kotlin"})
public final class UtilsKt {
    public static final void requireSquare(@NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (!(shape[0] == shape[1])) {
            boolean bl = false;
            String string = "Square matrix expected, shape=(" + shape[0] + ", " + shape[1] + ") given";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="conjTransposeFloat")
    @NotNull
    public static final NDArray<ComplexFloat, D2> conjTransposeFloat(@NotNull NDArray<ComplexFloat, D2> $this$conjTranspose) {
        void $this$zeros$iv;
        DataType dataType;
        void dim1$iv;
        Intrinsics.checkNotNullParameter($this$conjTranspose, (String)"<this>");
        Multik multik = Multik.INSTANCE;
        int n = $this$conjTranspose.getShape()[1];
        int dim2$iv = $this$conjTranspose.getShape()[0];
        boolean $i$f$zeros = false;
        Object object = new int[]{dim1$iv, dim2$iv};
        int[] nArray = object;
        object = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(ComplexFloat.class);
        boolean $i$f$ofKClass = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        NDArray ans2 = CreateNDArrayKt.zeros((Multik)$this$zeros$iv, (int[])nArray, (DataType)dataType);
        n = ans2.getShape()[0];
        for (int i = 0; i < n; ++i) {
            int n2 = ans2.getShape()[1];
            for (int j = 0; j < n2; ++j) {
                MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i, (int)j, (Object)((ComplexFloat)MultiArraysKt.get2((MultiArray)((MultiArray)$this$conjTranspose), (int)j, (int)i)).conjugate());
            }
        }
        return ans2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="conjTransposeDouble")
    @NotNull
    public static final NDArray<ComplexDouble, D2> conjTransposeDouble(@NotNull NDArray<ComplexDouble, D2> $this$conjTranspose) {
        void $this$zeros$iv;
        DataType dataType;
        void dim1$iv;
        Intrinsics.checkNotNullParameter($this$conjTranspose, (String)"<this>");
        Multik multik = Multik.INSTANCE;
        int n = $this$conjTranspose.getShape()[1];
        int dim2$iv = $this$conjTranspose.getShape()[0];
        boolean $i$f$zeros = false;
        Object object = new int[]{dim1$iv, dim2$iv};
        int[] nArray = object;
        object = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(ComplexDouble.class);
        boolean $i$f$ofKClass = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        NDArray ans2 = CreateNDArrayKt.zeros((Multik)$this$zeros$iv, (int[])nArray, (DataType)dataType);
        n = ans2.getShape()[0];
        for (int i = 0; i < n; ++i) {
            int n2 = ans2.getShape()[1];
            for (int j = 0; j < n2; ++j) {
                MutableMultiArraysKt.set2((MutableMultiArray)((MutableMultiArray)ans2), (int)i, (int)j, (Object)((ComplexDouble)MultiArraysKt.get2((MultiArray)((MultiArray)$this$conjTranspose), (int)j, (int)i)).conjugate());
            }
        }
        return ans2;
    }

    public static final void requireDotShape(@NotNull int[] aShape, @NotNull int[] bShape) {
        Intrinsics.checkNotNullParameter((Object)aShape, (String)"aShape");
        Intrinsics.checkNotNullParameter((Object)bShape, (String)"bShape");
        if (!(aShape[1] == bShape[0])) {
            boolean bl = false;
            String string = "Shapes mismatch: shapes " + ArraysKt.joinToString$default((int[])aShape, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null) + " and " + ArraysKt.joinToString$default((int[])bShape, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null) + " not aligned: " + aShape[1] + " (dim 1) != " + bShape[0] + " (dim 0)";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final ComplexFloat csqrt(@NotNull ComplexFloat a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        float arg = a.angle();
        float absval = a.abs();
        return new ComplexFloat((float)Math.sqrt(absval) * (float)Math.cos(arg / (float)2), (float)Math.sqrt(absval) * (float)Math.sin(arg / (float)2));
    }

    @NotNull
    public static final ComplexDouble csqrt(@NotNull ComplexDouble a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double arg = a.angle();
        double absval = a.abs();
        return new ComplexDouble(Math.sqrt(absval) * Math.cos(arg / (double)2), Math.sqrt(absval) * Math.sin(arg / (double)2));
    }

    public static final void swapLines(@NotNull MultiArray<Integer, D1> rowPerm, int from1, int to1, int from2, int to2, @NotNull Function2<? super Integer, ? super Integer, Unit> swap) {
        Intrinsics.checkNotNullParameter(rowPerm, (String)"rowPerm");
        Intrinsics.checkNotNullParameter(swap, (String)"swap");
        boolean $i$f$swapLines = false;
        for (int i = from1; i < to1; ++i) {
            if (((Number)MultiArraysKt.get0(rowPerm, (int)i)).intValue() == 0) continue;
            for (int j = from2; j < to2; ++j) {
                swap.invoke((Object)i, (Object)j);
            }
        }
    }

    public static /* synthetic */ void swapLines$default(MultiArray rowPerm, int from1, int to1, int from2, int to2, Function2 swap, int n, Object object) {
        if ((n & 2) != 0) {
            from1 = 0;
        }
        if ((n & 4) != 0) {
            to1 = rowPerm.getSize();
        }
        if ((n & 8) != 0) {
            from2 = 0;
        }
        Intrinsics.checkNotNullParameter((Object)rowPerm, (String)"rowPerm");
        Intrinsics.checkNotNullParameter((Object)swap, (String)"swap");
        boolean $i$f$swapLines = false;
        for (int i = from1; i < to1; ++i) {
            if (((Number)MultiArraysKt.get0((MultiArray)rowPerm, (int)i)).intValue() == 0) continue;
            for (int j = from2; j < to2; ++j) {
                swap.invoke((Object)i, (Object)j);
            }
        }
    }
}

