/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.IntSpan;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001aL\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001aB\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u001a\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001a&\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a\u0016\u0010\u0012\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a&\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"calculateArea", "", "T", "ring", "", "x", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "y", "Ljetbrains/datalore/base/geometry/DoubleVector;", "findRingIntervals", "Ljetbrains/datalore/base/interval/IntSpan;", "path", "isClockwise", "", "makeClosed", "splitRings", "points", "isClosed", "sublist", "range", "base-portable"})
public final class GeometryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<List<T>> splitRings(@NotNull List<? extends T> points) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Iterable $this$map$iv = GeometryKt.findRingIntervals(points);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntSpan intSpan = (IntSpan)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GeometryKt.sublist(points, (IntSpan)it));
        }
        List rings = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (!((Collection)rings).isEmpty() && !GeometryKt.isClosed((List)CollectionsKt.last((List)rings))) {
            rings.set(CollectionsKt.getLastIndex((List)rings), GeometryKt.makeClosed((List)CollectionsKt.last((List)rings)));
        }
        return rings;
    }

    private static final <T> List<T> makeClosed(List<? extends T> path) {
        return CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)path), (Object)CollectionsKt.first(path));
    }

    public static final <T> boolean isClosed(@NotNull List<? extends T> $this$isClosed) {
        Intrinsics.checkNotNullParameter($this$isClosed, (String)"<this>");
        return Intrinsics.areEqual((Object)CollectionsKt.first($this$isClosed), (Object)CollectionsKt.last($this$isClosed));
    }

    private static final <T> List<IntSpan> findRingIntervals(List<? extends T> path) {
        ArrayList<IntSpan> intervals = new ArrayList<IntSpan>();
        int startIndex = 0;
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            if (startIndex == i || !Intrinsics.areEqual(path.get(startIndex), path.get(i))) continue;
            intervals.add(new IntSpan(startIndex, i + 1));
            startIndex = i + 1;
        }
        if (startIndex != path.size()) {
            intervals.add(new IntSpan(startIndex, path.size()));
        }
        return intervals;
    }

    private static final <T> List<T> sublist(List<? extends T> $this$sublist, IntSpan range) {
        return $this$sublist.subList(range.getLowerEnd(), range.getUpperEnd());
    }

    public static final double calculateArea(@NotNull List<DoubleVector> ring) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        return GeometryKt.calculateArea(ring, (Function1)calculateArea.1.INSTANCE, (Function1)calculateArea.2.INSTANCE);
    }

    public static final <T> boolean isClockwise(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        if (!(!((Collection)ring).isEmpty())) {
            boolean bl = false;
            String string = "Ring shouldn't be empty to calculate clockwise";
            throw new IllegalStateException(string.toString());
        }
        double sum = 0.0;
        T prev = ring.get(ring.size() - 1);
        for (T point : ring) {
            sum += ((Number)x2.invoke(prev)).doubleValue() * ((Number)y2.invoke(point)).doubleValue() - ((Number)x2.invoke(point)).doubleValue() * ((Number)y2.invoke(prev)).doubleValue();
            prev = point;
        }
        return sum < 0.0;
    }

    public static final <T> double calculateArea(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        double area = 0.0;
        int j = ring.size() - 1;
        int i = 0;
        int n = ring.size();
        while (i < n) {
            T p1 = ring.get(i);
            T p2 = ring.get(j);
            area += (((Number)x2.invoke(p2)).doubleValue() + ((Number)x2.invoke(p1)).doubleValue()) * (((Number)y2.invoke(p2)).doubleValue() - ((Number)y2.invoke(p1)).doubleValue());
            j = i++;
        }
        return Math.abs(area / (double)2);
    }
}

