/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime;

import jetbrains.datalore.base.datetime.Month;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/base/datetime/DateTimeUtil;", "", "()V", "BASE_YEAR", "", "DAYS_IN_LEAP_YEAR", "getDAYS_IN_LEAP_YEAR$base_portable", "()I", "DAYS_IN_YEAR", "getDAYS_IN_YEAR$base_portable", "LEAP_YEARS_FROM_1969", "", "getLEAP_YEARS_FROM_1969$base_portable", "()[I", "MAX_SUPPORTED_YEAR", "MIN_SUPPORTED_YEAR", "checkYear", "", "year", "isLeap", "", "isLeap$base_portable", "leapYearsBetween", "fromYear", "toYear", "leapYearsBetween$base_portable", "leapYearsFromZero", "base-portable"})
public final class DateTimeUtil {
    @NotNull
    public static final DateTimeUtil INSTANCE = new DateTimeUtil();
    public static final int BASE_YEAR = 1900;
    public static final int MAX_SUPPORTED_YEAR = 2100;
    public static final int MIN_SUPPORTED_YEAR = 1970;
    private static final int DAYS_IN_YEAR;
    private static final int DAYS_IN_LEAP_YEAR;
    @NotNull
    private static final int[] LEAP_YEARS_FROM_1969;

    private DateTimeUtil() {
    }

    public final int getDAYS_IN_YEAR$base_portable() {
        return DAYS_IN_YEAR;
    }

    public final int getDAYS_IN_LEAP_YEAR$base_portable() {
        return DAYS_IN_LEAP_YEAR;
    }

    @NotNull
    public final int[] getLEAP_YEARS_FROM_1969$base_portable() {
        return LEAP_YEARS_FROM_1969;
    }

    public final boolean isLeap$base_portable(int year) {
        this.checkYear(year);
        return LEAP_YEARS_FROM_1969[year - 1970 + 1] - LEAP_YEARS_FROM_1969[year - 1970] == 1;
    }

    public final int leapYearsBetween$base_portable(int fromYear, int toYear) {
        if (fromYear > toYear) {
            throw new IllegalArgumentException();
        }
        this.checkYear(fromYear);
        this.checkYear(toYear);
        return LEAP_YEARS_FROM_1969[toYear - 1970] - LEAP_YEARS_FROM_1969[fromYear - 1970];
    }

    private final int leapYearsFromZero(int year) {
        return year / 4 - year / 100 + year / 400;
    }

    private final void checkYear(int year) {
        if (year > 2100 || year < 1970) {
            throw new IllegalArgumentException(year + "");
        }
    }

    static {
        int[] nArray = new int[]{477, 477, 477, 478, 478, 478, 478, 479, 479, 479, 479, 480, 480, 480, 480, 481, 481, 481, 481, 482, 482, 482, 482, 483, 483, 483, 483, 484, 484, 484, 484, 485, 485, 485, 485, 486, 486, 486, 486, 487, 487, 487, 487, 488, 488, 488, 488, 489, 489, 489, 489, 490, 490, 490, 490, 491, 491, 491, 491, 492, 492, 492, 492, 493, 493, 493, 493, 494, 494, 494, 494, 495, 495, 495, 495, 496, 496, 496, 496, 497, 497, 497, 497, 498, 498, 498, 498, 499, 499, 499, 499, 500, 500, 500, 500, 501, 501, 501, 501, 502, 502, 502, 502, 503, 503, 503, 503, 504, 504, 504, 504, 505, 505, 505, 505, 506, 506, 506, 506, 507, 507, 507, 507, 508, 508, 508, 508, 509, 509, 509, 509, 509};
        LEAP_YEARS_FROM_1969 = nArray;
        int leapYearDays = 0;
        int yearDays = 0;
        for (Month m : Month.Companion.values()) {
            leapYearDays += m.getDaysInLeapYear();
            yearDays += m.getDays();
        }
        DAYS_IN_YEAR = yearDays;
        DAYS_IN_LEAP_YEAR = leapYearDays;
    }
}

