/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.json.JsonLexer;
import jetbrains.datalore.base.json.JsonSupportKt;
import jetbrains.datalore.base.json.Token;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/base/json/JsonParser;", "", "json", "", "(Ljava/lang/String;)V", "parseArray", "", "lexer", "Ljetbrains/datalore/base/json/JsonLexer;", "parseJson", "parseObject", "", "parseValue", "require", "", "current", "Ljetbrains/datalore/base/json/Token;", "expected", "messagePrefix", "JsonException", "base-portable"})
public final class JsonParser {
    @NotNull
    private final String json;

    public JsonParser(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    @Nullable
    public final Object parseJson() {
        JsonLexer lexer = new JsonLexer(this.json);
        return this.parseValue(lexer);
    }

    private final Object parseValue(JsonLexer lexer) {
        Object object;
        Token token = lexer.getCurrentToken();
        switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 1: {
                String string;
                String it = string = JsonSupportKt.unescape(lexer.tokenValue());
                boolean bl = false;
                lexer.nextToken();
                object = string;
                break;
            }
            case 2: {
                Double d = Double.parseDouble(lexer.tokenValue());
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                lexer.nextToken();
                object = d;
                break;
            }
            case 3: {
                Boolean bl = false;
                boolean it = bl;
                boolean bl2 = false;
                lexer.nextToken();
                object = bl;
                break;
            }
            case 4: {
                Boolean bl = true;
                boolean it = bl;
                boolean bl3 = false;
                lexer.nextToken();
                object = bl;
                break;
            }
            case 5: {
                Object var2_6 = null;
                Void it = var2_6;
                boolean bl = false;
                lexer.nextToken();
                object = var2_6;
                break;
            }
            case 6: {
                object = this.parseObject(lexer);
                break;
            }
            case 7: {
                object = this.parseArray(lexer);
                break;
            }
            default: {
                throw new IllegalStateException(("Invalid token: " + (Object)((Object)lexer.getCurrentToken())).toString());
            }
        }
        return object;
    }

    private final List<Object> parseArray(JsonLexer lexer) {
        List list = new ArrayList();
        JsonParser.parseArray$checkCurrentToken(this, lexer, Token.LEFT_BRACKET);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACKET) {
            if (!((Collection)list).isEmpty()) {
                JsonParser.parseArray$checkCurrentToken(this, lexer, Token.COMMA);
                lexer.nextToken();
            }
            list.add(this.parseValue(lexer));
        }
        JsonParser.parseArray$checkCurrentToken(this, lexer, Token.RIGHT_BRACKET);
        lexer.nextToken();
        return list;
    }

    private final Map<String, Object> parseObject(JsonLexer lexer) {
        Map map = new LinkedHashMap();
        JsonParser.parseObject$checkCurrentToken-5(this, lexer, Token.LEFT_BRACE);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACE) {
            if (!map.isEmpty()) {
                JsonParser.parseObject$checkCurrentToken-5(this, lexer, Token.COMMA);
                lexer.nextToken();
            }
            JsonParser.parseObject$checkCurrentToken-5(this, lexer, Token.STRING);
            String key = JsonSupportKt.unescape(lexer.tokenValue());
            lexer.nextToken();
            JsonParser.parseObject$checkCurrentToken-5(this, lexer, Token.COLON);
            lexer.nextToken();
            Object value = this.parseValue(lexer);
            map.put(key, value);
        }
        JsonParser.parseObject$checkCurrentToken-5(this, lexer, Token.RIGHT_BRACE);
        lexer.nextToken();
        return map;
    }

    private final void require(Token current, Token expected, String messagePrefix) {
        if (current != expected) {
            throw new JsonException(messagePrefix + "Expected token: " + (Object)((Object)expected) + ", actual: " + (Object)((Object)current));
        }
    }

    static /* synthetic */ void require$default(JsonParser jsonParser, Token token, Token token2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        jsonParser.require(token, token2, string);
    }

    private static final void parseArray$checkCurrentToken(JsonParser this$0, JsonLexer $lexer, Token token) {
        this$0.require($lexer.getCurrentToken(), token, "[Arr] ");
    }

    private static final void parseObject$checkCurrentToken-5(JsonParser this$0, JsonLexer $lexer, Token token) {
        this$0.require($lexer.getCurrentToken(), token, "[Obj] ");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/base/json/JsonParser$JsonException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "base-portable"})
    public static final class JsonException
    extends Exception {
        public JsonException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.values().length];
            nArray[Token.STRING.ordinal()] = 1;
            nArray[Token.NUMBER.ordinal()] = 2;
            nArray[Token.FALSE.ordinal()] = 3;
            nArray[Token.TRUE.ordinal()] = 4;
            nArray[Token.NULL.ordinal()] = 5;
            nArray[Token.LEFT_BRACE.ordinal()] = 6;
            nArray[Token.LEFT_BRACKET.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

