/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.List;
import jetbrains.datalore.base.json.FluentArray;
import jetbrains.datalore.base.json.FluentObject;
import jetbrains.datalore.base.json.JsonSupport;
import jetbrains.datalore.base.spatial.GeoJson;
import jetbrains.datalore.base.spatial.SimpleFeature;
import jetbrains.datalore.base.typedGeometry.LineString;
import jetbrains.datalore.base.typedGeometry.MultiLineString;
import jetbrains.datalore.base.typedGeometry.MultiPoint;
import jetbrains.datalore.base.typedGeometry.MultiPolygon;
import jetbrains.datalore.base.typedGeometry.Polygon;
import jetbrains.datalore.base.typedGeometry.Ring;
import jetbrains.datalore.base.typedGeometry.Vec;
import jetbrains.datalore.base.typedGeometry.VecKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u001d\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\u0002\b\u000eJ\"\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/base/spatial/GeoJson;", "", "()V", "LAT_INDEX", "", "LON_INDEX", "parse", "", "T", "geoJson", "", "handler", "Lkotlin/Function1;", "Ljetbrains/datalore/base/spatial/SimpleFeature$Consumer;", "Lkotlin/ExtensionFunctionType;", "consumer", "Ljetbrains/datalore/base/spatial/SimpleFeature$GeometryConsumer;", "Parser", "base-portable"})
public final class GeoJson {
    @NotNull
    public static final GeoJson INSTANCE = new GeoJson();
    private static final int LON_INDEX = 0;
    private static final int LAT_INDEX = 1;

    private GeoJson() {
    }

    public final <T> void parse(@NotNull String geoJson, @NotNull Function1<? super SimpleFeature.Consumer<T>, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)geoJson, (String)"geoJson");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        FluentObject geoObj = new FluentObject(JsonSupport.INSTANCE.parseJson(geoJson));
        SimpleFeature.Consumer consumer = new SimpleFeature.Consumer(null, null, null, null, null, null, 63, null);
        handler2.invoke(consumer);
        SimpleFeature.Consumer geometryConsumer = consumer;
        new Parser().parse$base_portable(geoObj, geometryConsumer);
    }

    public final <T> void parse(@NotNull String geoJson, @NotNull SimpleFeature.GeometryConsumer<T> consumer) {
        Intrinsics.checkNotNullParameter((Object)geoJson, (String)"geoJson");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        FluentObject geoObj = new FluentObject(JsonSupport.INSTANCE.parseJson(geoJson));
        new Parser<T>().parse$base_portable(geoObj, consumer);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0000\u00a2\u0006\u0002\b\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00010\"\"\u0004\b\u0001\u0010\u0001*\u00020\u000e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u00010$H\u0002\u00a8\u0006%"}, d2={"Ljetbrains/datalore/base/spatial/GeoJson$Parser;", "T", "", "()V", "parse", "", "obj", "Ljetbrains/datalore/base/json/FluentObject;", "handler", "Ljetbrains/datalore/base/spatial/SimpleFeature$GeometryConsumer;", "parse$base_portable", "parseLineString", "Ljetbrains/datalore/base/typedGeometry/LineString;", "jsonLineString", "Ljetbrains/datalore/base/json/FluentArray;", "parseMultiLineString", "Ljetbrains/datalore/base/typedGeometry/MultiLineString;", "jsonLineStrings", "parseMultiPoint", "Ljetbrains/datalore/base/typedGeometry/MultiPoint;", "jsonMultiPoint", "parseMultiPolygon", "Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "jsonMultiPolygon", "parsePoint", "Ljetbrains/datalore/base/typedGeometry/Vec;", "jsonPoint", "parsePolygon", "Ljetbrains/datalore/base/typedGeometry/Polygon;", "jsonPolygon", "parseRing", "Ljetbrains/datalore/base/typedGeometry/Ring;", "jsonRing", "mapArray", "", "f", "Lkotlin/Function1;", "base-portable"})
    private static final class Parser<T> {
        /*
         * WARNING - void declaration
         */
        public final void parse$base_portable(@NotNull FluentObject obj, @NotNull SimpleFeature.GeometryConsumer<T> handler2) {
            block28: {
                String type;
                block29: {
                    block27: {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
                        type = obj.getString("type");
                        if (!Intrinsics.areEqual((Object)type, (Object)"FeatureCollection")) break block27;
                        if (!obj.contains("features")) {
                            boolean $i$a$-require-GeoJson$Parser$parse$22 = false;
                            String $i$a$-require-GeoJson$Parser$parse$22 = "GeoJson: Missing 'features' in 'FeatureCollection'";
                            throw new IllegalArgumentException($i$a$-require-GeoJson$Parser$parse$22.toString());
                        }
                        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter(obj.getArray("features").fluentObjectStream(), (Function1)parse.2.INSTANCE), (Function1)parse.3.INSTANCE);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FluentObject it = (FluentObject)element$iv;
                            boolean bl = false;
                            this.parse$base_portable(it, handler2);
                        }
                        break block28;
                    }
                    if (!Intrinsics.areEqual((Object)type, (Object)"GeometryCollection")) break block29;
                    if (!obj.contains("geometries")) {
                        boolean $i$a$-require-GeoJson$Parser$parse$62 = false;
                        String $i$a$-require-GeoJson$Parser$parse$62 = "GeoJson: Missing 'geometries' in 'GeometryCollection'";
                        throw new IllegalArgumentException($i$a$-require-GeoJson$Parser$parse$62.toString());
                    }
                    Sequence<FluentObject> $this$forEach$iv = obj.getArray("geometries").fluentObjectStream();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FluentObject it = (FluentObject)element$iv;
                        boolean bl = false;
                        this.parse$base_portable(it, handler2);
                    }
                    break block28;
                }
                if (!obj.contains("coordinates")) {
                    boolean bl = false;
                    String string = "GeoJson: Missing 'coordinates' in " + type;
                    throw new IllegalArgumentException(string.toString());
                }
                FluentArray coordinates = obj.getArray("coordinates");
                switch (type) {
                    case "Point": {
                        Vec<T> p0 = this.parsePoint(coordinates);
                        boolean bl = false;
                        handler2.onPoint(p0);
                        break;
                    }
                    case "LineString": {
                        LineString<T> p0 = this.parseLineString(coordinates);
                        boolean bl = false;
                        handler2.onLineString(p0);
                        break;
                    }
                    case "Polygon": {
                        Polygon<T> p0 = this.parsePolygon(coordinates);
                        boolean bl = false;
                        handler2.onPolygon(p0);
                        break;
                    }
                    case "MultiPoint": {
                        MultiPoint<T> p0 = this.parseMultiPoint(coordinates);
                        boolean bl = false;
                        handler2.onMultiPoint(p0);
                        break;
                    }
                    case "MultiLineString": {
                        MultiLineString<T> p0 = this.parseMultiLineString(coordinates);
                        boolean bl = false;
                        handler2.onMultiLineString(p0);
                        break;
                    }
                    case "MultiPolygon": {
                        MultiPolygon<T> p0 = this.parseMultiPolygon(coordinates);
                        boolean bl = false;
                        handler2.onMultiPolygon(p0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Not support GeoJson type: " + type).toString());
                    }
                }
            }
        }

        private final Vec<T> parsePoint(FluentArray jsonPoint) {
            return VecKt.explicitVec(jsonPoint.getDouble(0), jsonPoint.getDouble(1));
        }

        private final LineString<T> parseLineString(FluentArray jsonLineString) {
            List p0 = this.mapArray(jsonLineString, (Function1)new Function1<FluentArray, Vec<T>>(this){

                @NotNull
                public final Vec<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parsePoint((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new LineString(p0);
        }

        private final Ring<T> parseRing(FluentArray jsonRing) {
            List p0 = this.mapArray(jsonRing, (Function1)new Function1<FluentArray, Vec<T>>(this){

                @NotNull
                public final Vec<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parsePoint((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new Ring(p0);
        }

        private final MultiPoint<T> parseMultiPoint(FluentArray jsonMultiPoint) {
            List p0 = this.mapArray(jsonMultiPoint, (Function1)new Function1<FluentArray, Vec<T>>(this){

                @NotNull
                public final Vec<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parsePoint((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new MultiPoint(p0);
        }

        private final Polygon<T> parsePolygon(FluentArray jsonPolygon) {
            List p0 = this.mapArray(jsonPolygon, (Function1)new Function1<FluentArray, Ring<T>>(this){

                @NotNull
                public final Ring<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parseRing((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new Polygon(p0);
        }

        private final MultiLineString<T> parseMultiLineString(FluentArray jsonLineStrings) {
            List p0 = this.mapArray(jsonLineStrings, (Function1)new Function1<FluentArray, LineString<T>>(this){

                @NotNull
                public final LineString<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parseLineString((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new MultiLineString(p0);
        }

        private final MultiPolygon<T> parseMultiPolygon(FluentArray jsonMultiPolygon) {
            List p0 = this.mapArray(jsonMultiPolygon, (Function1)new Function1<FluentArray, Polygon<T>>(this){

                @NotNull
                public final Polygon<T> invoke(@NotNull FluentArray p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Parser.access$parsePolygon((Parser)this.receiver, p0);
                }
            });
            boolean bl = false;
            return new MultiPolygon(p0);
        }

        private final <T> List<T> mapArray(FluentArray $this$mapArray, Function1<? super FluentArray, ? extends T> f) {
            return SequencesKt.toList((Sequence)SequencesKt.map($this$mapArray.stream(), (Function1)new Function1<Object, T>(f){
                final /* synthetic */ Function1<FluentArray, T> $f;
                {
                    this.$f = $f;
                    super(1);
                }

                public final T invoke(@Nullable Object it) {
                    Object object = it;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
                    }
                    return (T)this.$f.invoke((Object)new FluentArray((List)object));
                }
            }));
        }

        public static final /* synthetic */ Vec access$parsePoint(Parser $this, FluentArray jsonPoint) {
            return $this.parsePoint(jsonPoint);
        }

        public static final /* synthetic */ Ring access$parseRing(Parser $this, FluentArray jsonRing) {
            return $this.parseRing(jsonRing);
        }

        public static final /* synthetic */ LineString access$parseLineString(Parser $this, FluentArray jsonLineString) {
            return $this.parseLineString(jsonLineString);
        }

        public static final /* synthetic */ Polygon access$parsePolygon(Parser $this, FluentArray jsonPolygon) {
            return $this.parsePolygon(jsonPolygon);
        }
    }
}

