/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.canvas;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.LineCap;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.core.canvas.TextBaseline;
import org.jetbrains.letsPlot.core.canvas.TextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J0\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016JP\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016JH\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J(\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0016J \u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u00101\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u000200H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000200H\u0016J\u0010\u00107\u001a\u00020\t2\u0006\u00106\u001a\u000200H\u0016J\u0018\u00108\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u00109\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\tH\u0016J\b\u0010<\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\tH\u0016J\u0018\u0010=\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010?\u001a\u00020\u00072\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\tH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\tH\u0016J\u0010\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\tH\u0016J\u0010\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\tH\u0016J\u0012\u0010V\u001a\u00020\u00072\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0010\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\\H\u0016J8\u0010]\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\t2\u0006\u0010_\u001a\u00020\t2\u0006\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020\t2\u0006\u0010c\u001a\u00020\tH\u0016J\b\u0010d\u001a\u00020\u0007H\u0016J(\u0010e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0016J \u0010f\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J8\u0010g\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010h\u001a\u00020\t2\u0006\u0010i\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010j\u001a\u00020\t2\u0006\u0010k\u001a\u00020\tH\u0016J\u0018\u0010l\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/Context2dDelegate;", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "logEnabled", "", "failIfNotImplemented", "(ZZ)V", "arc", "", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clip", "closePath", "drawImage", "snapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "ellipse", "radiusX", "radiusY", "rotation", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "log", "msg", "measureText", "Lorg/jetbrains/letsPlot/core/canvas/TextMetrics;", "str", "measureTextWidth", "moveTo", "restore", "rotate", "angle", "save", "scale", "xy", "setFillStyle", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "setFont", "f", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "setGlobalAlpha", "alpha", "setLineCap", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "setLineDash", "lineDash", "", "setLineDashOffset", "lineDashOffset", "setLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "setLineWidth", "lineWidth", "setStrokeMiterLimit", "miterLimit", "setStrokeStyle", "setTextAlign", "align", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextBaseline", "baseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTransform", "m00", "m10", "m01", "m11", "m02", "m12", "stroke", "strokeRect", "strokeText", "transform", "ry", "rx", "tx", "ty", "translate", "canvas"})
public final class Context2dDelegate
implements Context2d {
    private final boolean logEnabled;
    private final boolean failIfNotImplemented;

    public Context2dDelegate(boolean logEnabled, boolean failIfNotImplemented) {
        this.logEnabled = logEnabled;
        this.failIfNotImplemented = failIfNotImplemented;
    }

    public /* synthetic */ Context2dDelegate(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    private final void log(String msg) {
        if (this.logEnabled) {
            System.out.println((Object)msg);
        }
        if (this.failIfNotImplemented) {
            throw new UnsupportedOperationException(msg);
        }
    }

    @Override
    public void clearRect(@NotNull DoubleRectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.log("clearRect: " + rect);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.log("drawImage: " + snapshot);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.log("drawImage: " + snapshot + ", x=" + x + ", y=" + y);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x, double y, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.log("drawImage: " + snapshot + ", x=" + x + ", y=" + y + ", dw=" + dw + ", dh=" + dh);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.log("drawImage: " + snapshot + ", sx=" + sx + ", sy=" + sy + ", sw=" + sw + ", sh=" + sh + ", dx=" + dx + ", dy=" + dy + ", dw=" + dw + ", dh=" + dh);
    }

    @Override
    public void beginPath() {
        this.log("beginPath");
    }

    @Override
    public void closePath() {
        this.log("closePath");
    }

    @Override
    public void clip() {
        this.log("clip");
    }

    @Override
    public void stroke() {
        this.log("stroke");
    }

    @Override
    public void fill() {
        this.log("fill");
    }

    @Override
    public void fillEvenOdd() {
        this.log("fillEvenOdd");
    }

    @Override
    public void fillRect(double x, double y, double w, double h) {
        this.log("fillRect: x=" + x + ", y=" + y + ", w=" + w + ", h=" + h);
    }

    @Override
    public void moveTo(double x, double y) {
        this.log("moveTo: x=" + x + ", y=" + y);
    }

    @Override
    public void lineTo(double x, double y) {
        this.log("lineTo: x=" + x + ", y=" + y);
    }

    @Override
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.log("arc: x=" + x + ", y=" + y + ", radius=" + radius + ", startAngle=" + startAngle + ", endAngle=" + endAngle + ", anticlockwise=" + anticlockwise);
    }

    @Override
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this.log("ellipse: x=" + x + ", y=" + y + ", radiusX=" + radiusX + ", radiusY=" + radiusY + ", rotation=" + rotation + ", startAngle=" + startAngle + ", endAngle=" + endAngle + ", anticlockwise=" + anticlockwise);
    }

    @Override
    public void save() {
        this.log("save");
    }

    @Override
    public void restore() {
        this.log("restore");
    }

    @Override
    public void setFillStyle(@Nullable Color color) {
        this.log("setFillStyle: " + color);
    }

    @Override
    public void setStrokeStyle(@Nullable Color color) {
        this.log("setStrokeStyle: " + color);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.log("setGlobalAlpha: " + alpha);
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.log("setFont: " + f);
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.log("setLineWidth: " + lineWidth);
    }

    @Override
    public void strokeRect(double x, double y, double w, double h) {
        this.log("strokeRect: x=" + x + ", y=" + y + ", w=" + w + ", h=" + h);
    }

    @Override
    public void strokeText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.log("strokeText: " + text + ", x=" + x + ", y=" + y);
    }

    @Override
    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.log("fillText: " + text + ", x=" + x + ", y=" + y);
    }

    @Override
    public void scale(double x, double y) {
        this.log("scale: x=" + x + ", y=" + y);
    }

    @Override
    public void scale(double xy) {
        this.log("scale: xy=" + xy);
    }

    @Override
    public void rotate(double angle) {
        this.log("rotate: angle=" + angle);
    }

    @Override
    public void translate(double x, double y) {
        this.log("translate: x=" + x + ", y=" + y);
    }

    @Override
    public void transform(double sx, double ry, double rx, double sy, double tx, double ty) {
        this.log("transform: m11=" + sx + ", m12=" + ry + ", m21=" + rx + ", m22=" + sy + ", dx=" + tx + ", dy=" + ty);
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.log("bezierCurveTo: cp1x=" + cp1x + ", cp1y=" + cp1y + ", cp2x=" + cp2x + ", cp2y=" + cp2y + ", x=" + x + ", y=" + y);
    }

    @Override
    public void setLineJoin(@NotNull LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
        this.log("setLineJoin: " + (Object)((Object)lineJoin));
    }

    @Override
    public void setLineCap(@NotNull LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
        this.log("setLineCap: " + (Object)((Object)lineCap));
    }

    @Override
    public void setStrokeMiterLimit(double miterLimit) {
        this.log("setStrokeMiterLimit: " + miterLimit);
    }

    @Override
    public void setTextBaseline(@NotNull TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        this.log("setTextBaseline: " + (Object)((Object)baseline));
    }

    @Override
    public void setTextAlign(@NotNull TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.log("setTextAlign: " + (Object)((Object)align));
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.log("setTransform: m11=" + m00 + ", m12=" + m10 + ", m21=" + m01 + ", m22=" + m11 + ", dx=" + m02 + ", dy=" + m12);
    }

    @Override
    public void setLineDash(@NotNull double[] lineDash) {
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        this.log("setLineDash: " + lineDash);
    }

    @Override
    public void setLineDashOffset(double lineDashOffset) {
        this.log("setLineDashOffset: " + lineDashOffset);
    }

    @Override
    public double measureTextWidth(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.log("measureTextWidth: '" + str + '\'');
        return (double)str.length() * 8.0;
    }

    @Override
    @NotNull
    public TextMetrics measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.log("measureText: '" + str + '\'');
        return new TextMetrics(0.0, 0.0, DoubleRectangle.Companion.LTRB((Number)0, (Number)0, (Number)((double)str.length() * 8.0), (Number)14.0));
    }

    @Override
    public void drawBezierCurve(@NotNull List<? extends Vec<?>> points) {
        Context2d.DefaultImpls.drawBezierCurve(this, points);
    }

    public Context2dDelegate() {
        this(false, false, 3, null);
    }
}

