/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.Key;
import org.jetbrains.letsPlot.commons.event.KeyStroke;
import org.jetbrains.letsPlot.commons.event.ModifierKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB\u001b\b\u0016\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0005\"\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0006R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/commons/event/KeyStrokeSpec;", "", "key", "Lorg/jetbrains/letsPlot/commons/event/Key;", "modifiers", "", "Lorg/jetbrains/letsPlot/commons/event/ModifierKey;", "(Lorg/jetbrains/letsPlot/commons/event/Key;[Lorg/jetbrains/letsPlot/commons/event/ModifierKey;)V", "keyStrokes", "", "Lorg/jetbrains/letsPlot/commons/event/KeyStroke;", "(Ljava/util/Collection;)V", "([Lorg/jetbrains/letsPlot/commons/event/KeyStroke;)V", "isEmpty", "", "()Z", "", "getKeyStrokes", "()Ljava/lang/Iterable;", "myKeyStrokes", "[Lorg/jetbrains/letsPlot/commons/event/KeyStroke;", "equals", "other", "hashCode", "", "matches", "keyStroke", "toString", "", "with", "commons"})
@SourceDebugExtension(value={"SMAP\nKeyStrokeSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStrokeSpec.kt\norg/jetbrains/letsPlot/commons/event/KeyStrokeSpec\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n37#2,2:64\n*S KotlinDebug\n*F\n+ 1 KeyStrokeSpec.kt\norg/jetbrains/letsPlot/commons/event/KeyStrokeSpec\n*L\n23#1:64,2\n*E\n"})
public final class KeyStrokeSpec {
    @NotNull
    private final KeyStroke[] myKeyStrokes;

    @NotNull
    public final Iterable<KeyStroke> getKeyStrokes() {
        KeyStroke[] keyStrokeArray = this.myKeyStrokes;
        return CollectionsKt.listOf((Object[])Arrays.copyOf(keyStrokeArray, keyStrokeArray.length));
    }

    public final boolean isEmpty() {
        return this.myKeyStrokes.length == 0;
    }

    public KeyStrokeSpec(@NotNull Key key, ModifierKey ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        KeyStroke[] keyStrokeArray = new KeyStroke[]{new KeyStroke(key, Arrays.copyOf(modifiers, modifiers.length))};
        this.myKeyStrokes = keyStrokeArray;
    }

    public KeyStrokeSpec(@NotNull Collection<KeyStroke> keyStrokes) {
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        Collection<KeyStroke> $this$toTypedArray$iv = keyStrokes;
        boolean $i$f$toTypedArray = false;
        Collection<KeyStroke> thisCollection$iv = $this$toTypedArray$iv;
        this.myKeyStrokes = thisCollection$iv.toArray(new KeyStroke[0]);
    }

    public KeyStrokeSpec(KeyStroke ... keyStrokes) {
        Intrinsics.checkNotNullParameter((Object)keyStrokes, (String)"keyStrokes");
        this.myKeyStrokes = Arrays.copyOf(keyStrokes, keyStrokes.length);
    }

    public final boolean matches(@NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        for (KeyStroke spec : this.myKeyStrokes) {
            if (!spec.matches(keyStroke)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final KeyStrokeSpec with(@NotNull ModifierKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        ArrayList<KeyStroke> modified = new ArrayList<KeyStroke>();
        for (KeyStroke keyStroke : this.myKeyStrokes) {
            modified.add(keyStroke.with(key));
        }
        return new KeyStrokeSpec((Collection<KeyStroke>)modified);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeyStrokeSpec that = (KeyStrokeSpec)other;
        return Intrinsics.areEqual(this.getKeyStrokes(), that.getKeyStrokes());
    }

    public int hashCode() {
        return this.getKeyStrokes().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getKeyStrokes().toString();
    }
}

