/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Vector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003J\u0013\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/commons/geometry/Segment;", "", "start", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "end", "(Lorg/jetbrains/letsPlot/commons/geometry/Vector;Lorg/jetbrains/letsPlot/commons/geometry/Vector;)V", "getEnd", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getStart", "contains", "", "v", "distance", "", "equals", "other", "hashCode", "", "intersection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "with", "isDistanceToLineBest", "length", "toDoubleSegment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "toString", "", "commons"})
public final class Segment {
    @NotNull
    private final Vector start;
    @NotNull
    private final Vector end;

    public Segment(@NotNull Vector start, @NotNull Vector end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final Vector getStart() {
        return this.start;
    }

    @NotNull
    public final Vector getEnd() {
        return this.end;
    }

    public final double distance(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vector vs = this.start.sub(v);
        Vector ve = this.end.sub(v);
        if (this.isDistanceToLineBest(v)) {
            double pVolume = Math.abs(vs.getX() * ve.getY() - vs.getY() * ve.getX());
            return pVolume / this.length();
        }
        return Math.min(vs.toDoubleVector().length(), ve.toDoubleVector().length());
    }

    private final boolean isDistanceToLineBest(Vector v) {
        Vector es = this.start.sub(this.end);
        Vector se = es.negate();
        Vector ev = v.sub(this.end);
        Vector sv = v.sub(this.start);
        return es.dotProduct(ev) >= 0 && se.dotProduct(sv) >= 0;
    }

    @NotNull
    public final DoubleSegment toDoubleSegment() {
        return new DoubleSegment(this.start.toDoubleVector(), this.end.toDoubleVector());
    }

    @Nullable
    public final DoubleVector intersection(@NotNull Segment with) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        return this.toDoubleSegment().intersection(with.toDoubleSegment());
    }

    public final double length() {
        return this.start.sub(this.end).length();
    }

    public final boolean contains(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vector p1 = v.sub(this.start);
        Vector p2 = v.sub(this.end);
        return p1.isParallel(p2) ? p1.dotProduct(p2) <= 0 : false;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Segment)) {
            return false;
        }
        Segment l = (Segment)other;
        return Intrinsics.areEqual((Object)l.start, (Object)this.start) && Intrinsics.areEqual((Object)l.end, (Object)this.end);
    }

    public int hashCode() {
        return this.start.hashCode() * 31 + this.end.hashCode();
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.start + " -> " + this.end + ']';
    }
}

