/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.observable.property;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.function.Supplier;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.intern.observable.property.BaseDerivedProperty;
import org.jetbrains.letsPlot.commons.intern.observable.property.PropertyChangeEvent;
import org.jetbrains.letsPlot.commons.intern.observable.property.ReadableProperty;
import org.jetbrains.letsPlot.commons.registration.Registration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\r\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0014J\u001c\u0010\u0017\u001a\u00020\f\"\u0004\b\u0001\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0007H\u0002R\u001a\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/observable/property/SimpleDerivedProperty;", "ValueT", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/BaseDerivedProperty;", "mySupplier", "Lorg/jetbrains/letsPlot/commons/intern/function/Supplier;", "deps", "", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/ReadableProperty;", "(Lorg/jetbrains/letsPlot/commons/intern/function/Supplier;[Lorg/jetbrains/letsPlot/commons/intern/observable/property/ReadableProperty;)V", "myDependencies", "[Lorg/jetbrains/letsPlot/commons/intern/observable/property/ReadableProperty;", "myRegistrations", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "[Lorg/jetbrains/letsPlot/commons/registration/Registration;", "propExpr", "", "getPropExpr", "()Ljava/lang/String;", "doAddListeners", "", "doGet", "()Ljava/lang/Object;", "doRemoveListeners", "register", "DependencyT", "prop", "commons"})
public final class SimpleDerivedProperty<ValueT>
extends BaseDerivedProperty<ValueT> {
    @NotNull
    private final Supplier<ValueT> mySupplier;
    @NotNull
    private final ReadableProperty<?>[] myDependencies;
    @Nullable
    private Registration[] myRegistrations;

    public SimpleDerivedProperty(@NotNull Supplier<ValueT> mySupplier, ReadableProperty<?> ... deps) {
        Intrinsics.checkNotNullParameter(mySupplier, (String)"mySupplier");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        super(mySupplier.get());
        this.mySupplier = mySupplier;
        this.myDependencies = Arrays.copyOf(deps, deps.length);
    }

    @Override
    @NotNull
    public String getPropExpr() {
        StringBuilder result = new StringBuilder();
        result.append("derived(");
        result.append(this.mySupplier);
        for (ReadableProperty<?> d : this.myDependencies) {
            result.append(", ");
            result.append(d.getPropExpr());
        }
        result.append(")");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @Override
    protected void doAddListeners() {
        int n = 0;
        int n2 = this.myDependencies.length;
        Registration[] registrationArray = new Registration[n2];
        SimpleDerivedProperty simpleDerivedProperty = this;
        while (n < n2) {
            int n3 = n++;
            registrationArray[n3] = this.register(this.myDependencies[n3]);
        }
        simpleDerivedProperty.myRegistrations = registrationArray;
    }

    private final <DependencyT> Registration register(ReadableProperty<DependencyT> prop) {
        return prop.addHandler(new EventHandler<PropertyChangeEvent<? extends DependencyT>>(this){
            final /* synthetic */ SimpleDerivedProperty<ValueT> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEvent(@NotNull PropertyChangeEvent<? extends DependencyT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.somethingChanged();
            }
        });
    }

    @Override
    protected void doRemoveListeners() {
        Intrinsics.checkNotNull((Object)this.myRegistrations);
        for (Registration r : this.myRegistrations) {
            r.remove();
        }
        this.myRegistrations = null;
    }

    @Override
    protected ValueT doGet() {
        return this.mySupplier.get();
    }
}

