/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial;

import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u001aP\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\u0004\b\u0001\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00020\n\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"calculateQuadKeys", "", "QuadT", "GeometryT", "mapRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "viewRect", "zoom", "", "quadKeyFactory", "Lkotlin/Function1;", "", "calulateQuadsCount", "xyToKey", "x", "y", "commons"})
@SourceDebugExtension(value={"SMAP\nQuads.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quads.kt\norg/jetbrains/letsPlot/commons/intern/spatial/QuadsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class QuadsKt {
    public static final int calulateQuadsCount(int zoom) {
        return (int)MathKt.ipow(2, zoom);
    }

    @NotNull
    public static final <GeometryT, QuadT> Set<QuadT> calculateQuadKeys(@NotNull Rect<GeometryT> mapRect, @NotNull Rect<GeometryT> viewRect, int zoom, @NotNull Function1<? super String, ? extends QuadT> quadKeyFactory) {
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        Intrinsics.checkNotNullParameter(viewRect, (String)"viewRect");
        Intrinsics.checkNotNullParameter(quadKeyFactory, (String)"quadKeyFactory");
        HashSet<Object> quadKeys = new HashSet<Object>();
        int tileCount = QuadsKt.calulateQuadsCount(zoom);
        int xmin = QuadsKt.calculateQuadKeys$calcQuadNum(RectKt.getLeft(viewRect), RectKt.xRange(mapRect), tileCount);
        int xmax = QuadsKt.calculateQuadKeys$calcQuadNum(RectKt.getRight(viewRect), RectKt.xRange(mapRect), tileCount);
        int ymin = QuadsKt.calculateQuadKeys$calcQuadNum(RectKt.getTop(viewRect), RectKt.yRange(mapRect), tileCount);
        int ymax = QuadsKt.calculateQuadKeys$calcQuadNum(RectKt.getBottom(viewRect), RectKt.yRange(mapRect), tileCount);
        int x2 = xmin;
        if (x2 <= xmax) {
            while (true) {
                int y2;
                if ((y2 = ymin) <= ymax) {
                    while (true) {
                        Object p0 = quadKeyFactory.invoke((Object)QuadsKt.xyToKey(x2, y2, zoom));
                        boolean bl = false;
                        quadKeys.add(p0);
                        if (y2 == ymax) break;
                        ++y2;
                    }
                }
                if (x2 == xmax) break;
                ++x2;
            }
        }
        return quadKeys;
    }

    @NotNull
    public static final String xyToKey(int x2, int y2, int zoom) {
        String key = "";
        for (int i = zoom; 0 < i; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((x2 & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((y2 & mask) != 0) {
                digit = (char)(digit + 2);
            }
            key = key + digit;
        }
        return key;
    }

    private static final int calculateQuadKeys$calcQuadNum(double value, DoubleSpan range, int tileCount) {
        double position = (value - range.getLowerEnd()) / (range.getUpperEnd() - range.getLowerEnd());
        return (int)Math.max(0.0, Math.min(position * (double)tileCount, (double)(tileCount - 1)));
    }
}

