/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial.projections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/ConicEqualAreaProjection;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "y0", "", "y1", "(DD)V", "c", "n", "r0", "invert", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "project", "validDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Companion", "commons"})
public final class ConicEqualAreaProjection
implements Projection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double n;
    private final double c;
    private final double r0;
    @NotNull
    private static final DoubleRectangle VALID_RECTANGLE = DoubleRectangle.Companion.LTRB(-180.0, -90.0, 180.0, 90.0);

    public ConicEqualAreaProjection(double y0, double y1) {
        double sy0 = Math.sin(y0);
        this.n = (sy0 + Math.sin(y1)) / (double)2;
        this.c = 1.0 + sy0 * ((double)2 * this.n - sy0);
        this.r0 = Math.sqrt(this.c) / this.n;
    }

    @Override
    @NotNull
    public DoubleRectangle validDomain() {
        return VALID_RECTANGLE;
    }

    @Override
    @Nullable
    public DoubleVector project(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = MathKt.toRadians(v.getX());
        double y2 = MathKt.toRadians(v.getY());
        double r = Math.sqrt(this.c - 2.0 * this.n * Math.sin(y2)) / this.n;
        double px = r * Math.sin(x2 *= this.n);
        double py = this.r0 - r * Math.cos(x2);
        return ProjectionsKt.finiteDoubleVectorOrNull(px, py);
    }

    @Override
    @Nullable
    public DoubleVector invert(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = v.getX();
        double y2 = v.getY();
        double r0y = this.r0 - y2;
        double ix = MathKt.toDegrees(Math.atan2(x2, Math.abs(r0y)) / this.n * Math.signum(r0y));
        double iy = MathKt.toDegrees(Math.asin((this.c - (x2 * x2 + r0y * r0y) * this.n * this.n) / ((double)2 * this.n)));
        return ProjectionsKt.finiteDoubleVectorOrNull(ix, iy);
    }

    @Override
    public boolean getNonlinear() {
        return Projection.DefaultImpls.getNonlinear(this);
    }

    @Override
    public boolean getCylindrical() {
        return Projection.DefaultImpls.getCylindrical(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/ConicEqualAreaProjection$Companion;", "", "()V", "VALID_RECTANGLE", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

