/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial.projections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.MercatorUtils;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/MercatorProjection;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "()V", "cylindrical", "", "getCylindrical", "()Z", "invert", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "project", "validDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Companion", "commons"})
public final class MercatorProjection
implements Projection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean cylindrical;
    @NotNull
    private static final DoubleRectangle VALID_RECTANGLE = new DoubleRectangle(MercatorUtils.INSTANCE.getVALID_LONGITUDE_RANGE(), MercatorUtils.INSTANCE.getVALID_LATITUDE_RANGE());

    public MercatorProjection() {
        this.cylindrical = true;
    }

    @Override
    public boolean getCylindrical() {
        return this.cylindrical;
    }

    @Override
    @NotNull
    public DoubleVector project(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(MercatorUtils.INSTANCE.getMercatorX(GeographicKt.limitLon(v.getX())), MercatorUtils.INSTANCE.getMercatorY(GeographicKt.limitLat(v.getY())));
    }

    @Override
    @NotNull
    public DoubleVector invert(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(GeographicKt.limitLon(MercatorUtils.INSTANCE.getLongitude(v.getX())), GeographicKt.limitLat(MercatorUtils.INSTANCE.getLatitude(v.getY())));
    }

    @Override
    @NotNull
    public DoubleRectangle validDomain() {
        return VALID_RECTANGLE;
    }

    @Override
    public boolean getNonlinear() {
        return Projection.DefaultImpls.getNonlinear(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/MercatorProjection$Companion;", "", "()V", "VALID_RECTANGLE", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

