/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 %*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002%&B3\b\u0002\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014JC\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J\u001a\u0010\u001e\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010\u001e\u001a\u00028\u0000*\u00028\u00002\u0006\u0010!\u001a\u00020\u0006H\u0082\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 J\u001a\u0010$\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00020\u0006*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler;", "T", "", "transform", "Lkotlin/Function1;", "precision", "", "dataAdapter", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$DataAdapter;", "(Lkotlin/jvm/functions/Function1;DLorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$DataAdapter;)V", "precisionSqr", "x", "getX", "(Ljava/lang/Object;)D", "y", "getY", "resample", "", "p1", "p2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "", "t1", "t2", "output", "", "depth", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;I)V", "points", "div", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "v", "(Ljava/lang/Object;D)Ljava/lang/Object;", "minus", "plus", "Companion", "DataAdapter", "commons"})
@SourceDebugExtension(value={"SMAP\nAdaptiveResampler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveResampler.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,129:1\n1313#2,2:130\n*S KotlinDebug\n*F\n+ 1 AdaptiveResampler.kt\norg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler\n*L\n69#1:130,2\n*E\n"})
public final class AdaptiveResampler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, T> transform;
    @NotNull
    private final DataAdapter<T> dataAdapter;
    private final double precisionSqr;
    private static final int MAX_DEPTH_LIMIT = 9;
    @NotNull
    private static final Companion.DOUBLE_VECTOR_ADAPTER.1 DOUBLE_VECTOR_ADAPTER = new DataAdapter<DoubleVector>(){

        public double x(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.getX();
        }

        public double y(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.getY();
        }

        @NotNull
        public DoubleVector create(double x2, double y2) {
            return new DoubleVector(x2, y2);
        }

        public double getX(@NotNull DoubleVector $this$x) {
            return DataAdapter.DefaultImpls.getX(this, $this$x);
        }

        public double getY(@NotNull DoubleVector $this$y) {
            return DataAdapter.DefaultImpls.getY(this, $this$y);
        }
    };

    private AdaptiveResampler(Function1<? super T, ? extends T> transform2, double precision, DataAdapter<T> dataAdapter) {
        this.transform = transform2;
        this.dataAdapter = dataAdapter;
        this.precisionSqr = precision * precision;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> resample(@NotNull List<? extends T> points) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Object pPrev = null;
        Object object = CollectionsKt.firstOrNull(points);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        pPrev = object;
        Object tPrev = null;
        Object object2 = this.transform.invoke(pPrev);
        if (object2 == null) {
            return CollectionsKt.emptyList();
        }
        tPrev = object2;
        Object object3 = CollectionsKt.lastOrNull(points);
        if (object3 == null) {
            return CollectionsKt.emptyList();
        }
        Object pLast = object3;
        Object object4 = this.transform.invoke(pLast);
        if (object4 == null) {
            return CollectionsKt.emptyList();
        }
        Object tLast = object4;
        ArrayList<Object> output = new ArrayList<Object>(points.size());
        Sequence sequence = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)points), (int)1);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t;
            Object element$iv;
            Object p = element$iv = iterator2.next();
            boolean bl = false;
            if (this.transform.invoke(p) == null) continue;
            output.add(tPrev);
            this.resample(pPrev, tPrev, p, t, (List)output, 9);
            pPrev = p;
            tPrev = t;
        }
        output.add(tLast);
        return output;
    }

    @NotNull
    public final List<T> resample(T p1, T p2) {
        Object object = this.transform.invoke(p1);
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object t1 = object;
        Object object2 = this.transform.invoke(p2);
        if (object2 == null) {
            return CollectionsKt.emptyList();
        }
        Object t2 = object2;
        List output = new ArrayList();
        output.add(t1);
        this.resample(p1, t1, p2, t2, output, 9);
        output.add(t2);
        return output;
    }

    private final void resample(T p1, T t1, T p2, T t2, List<T> output, int depth) {
        if (Intrinsics.areEqual(p1, p2)) {
            return;
        }
        T pm = this.div(this.plus(p1, p2), 2.0);
        Object object = this.transform.invoke(pm);
        if (object == null) {
            return;
        }
        Object tm = object;
        if (MathKt.distance2ToLine(this.getX(tm), this.getY(tm), this.getX(t1), this.getY(t1), this.getX(t2), this.getY(t2)) >= this.precisionSqr && depth > 0) {
            this.resample(p1, t1, pm, tm, output, depth - 1);
            output.add(tm);
            this.resample(pm, tm, p2, t2, output, depth - 1);
        } else if (MathKt.distance2(this.getX(t1), this.getY(t1), this.getX(t2), this.getY(t2)) > this.precisionSqr) {
            output.add(tm);
        }
    }

    public final double getX(T $this$x) {
        return this.dataAdapter.x($this$x);
    }

    public final double getY(T $this$y) {
        return this.dataAdapter.y($this$y);
    }

    private final T minus(T $this$minus, T other) {
        return this.dataAdapter.create(this.getX($this$minus) - this.getX(other), this.getY($this$minus) - this.getY(other));
    }

    private final T plus(T $this$plus, T other) {
        return this.dataAdapter.create(this.getX($this$plus) + this.getX(other), this.getY($this$plus) + this.getY(other));
    }

    private final T div(T $this$div, T other) {
        return this.dataAdapter.create(this.getX($this$div) / this.getX(other), this.getY($this$div) / this.getY(other));
    }

    private final T div(T $this$div, double v) {
        return this.dataAdapter.create(this.getX($this$div) / v, this.getY($this$div) / v);
    }

    public /* synthetic */ AdaptiveResampler(Function1 transform2, double precision, DataAdapter dataAdapter, DefaultConstructorMarker $constructor_marker) {
        this(transform2, precision, dataAdapter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J>\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\t\"\u0004\b\u0001\u0010\u00102\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012J8\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\fJ:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\fR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$Companion;", "", "()V", "DOUBLE_VECTOR_ADAPTER", "org/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$Companion$DOUBLE_VECTOR_ADAPTER$1", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$Companion$DOUBLE_VECTOR_ADAPTER$1;", "MAX_DEPTH_LIMIT", "", "forDoubleVector", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "transform", "Lkotlin/Function1;", "precision", "", "generic", "T", "adapter", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$DataAdapter;", "resample", "", "points", "p1", "p2", "commons"})
    public static final class Companion {
        private Companion() {
        }

        private final AdaptiveResampler<DoubleVector> forDoubleVector(Function1<? super DoubleVector, DoubleVector> transform2, double precision) {
            return new AdaptiveResampler<DoubleVector>(transform2, precision, DOUBLE_VECTOR_ADAPTER, null);
        }

        @NotNull
        public final <T> AdaptiveResampler<T> generic(@NotNull Function1<? super T, ? extends T> transform2, double precision, @NotNull DataAdapter<T> adapter) {
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            return new AdaptiveResampler(transform2, precision, adapter, null);
        }

        @NotNull
        public final List<DoubleVector> resample(@NotNull List<DoubleVector> points, double precision, @NotNull Function1<? super DoubleVector, DoubleVector> transform2) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return this.forDoubleVector(transform2, precision).resample(points);
        }

        @NotNull
        public final List<DoubleVector> resample(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double precision, @NotNull Function1<? super DoubleVector, DoubleVector> transform2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter(transform2, (String)"transform");
            return this.forDoubleVector(transform2, precision).resample(p1, p2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u001d\u0010\t\u001a\u00028\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006R\u0018\u0010\u0003\u001a\u00020\u0004*\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/algorithms/AdaptiveResampler$DataAdapter;", "T", "", "x", "", "getX", "(Ljava/lang/Object;)D", "y", "getY", "create", "(DD)Ljava/lang/Object;", "p", "commons"})
    public static interface DataAdapter<T> {
        public double x(T var1);

        public double y(T var1);

        public T create(double var1, double var3);

        public double getX(T var1);

        public double getY(T var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static <T> double getX(@NotNull DataAdapter<T> $this, T $receiver) {
                return $this.x($receiver);
            }

            public static <T> double getY(@NotNull DataAdapter<T> $this, T $receiver) {
                return $this.y($receiver);
            }
        }
    }
}

