/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.math;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Vector;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003\u001a\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u001a&\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003\u001a\u0016\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u001a6\u0010\u0014\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a6\u0010\u0019\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u001e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b\u001a&\u0010\u001d\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003\u001a6\u0010\u001e\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003\u001a\u001e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b\u001a\u0016\u0010#\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u0016\u0010$\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a2\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030&2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003\u001a\u0016\u0010'\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u001a.\u0010(\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003\u001a\u001e\u0010(\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0003\u001a6\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u001e\u0010*\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b\u001a.\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003\u001a\u0016\u00101\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u000e\u00101\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003\u001a\u000e\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003\u001a.\u00106\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u001e\u00106\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u001a.\u00107\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u001e\u00107\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0012\u00108\u001a\u00020\u0003*\u0002092\u0006\u0010:\u001a\u000209\u00a8\u0006;"}, d2={"areEqual", "", "a", "", "b", "epsilon", "ceil", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "x", "y", "v", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "distance", "x1", "y1", "x2", "y2", "p1", "p2", "distance2", "distance2ToLine", "l1x", "l1y", "l2x", "l2y", "distance2ToSegment", "p", "l1", "l2", "dot", "isOnSegment", "p1x", "p1y", "p2x", "p2y", "length", "length2", "lineParams", "Lkotlin/Pair;", "lineSlope", "pointOnLine", "offset", "projection", "px", "py", "rotateAround", "cx", "cy", "phi", "round", "toDegrees", "radians", "toRadians", "degrees", "xOnLine", "yOnLine", "ipow", "", "e", "commons"})
public final class MathKt {
    public static final double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static final double toDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    @NotNull
    public static final Vector round(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return MathKt.round(v.getX(), v.getY());
    }

    @NotNull
    public static final Vector ceil(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return MathKt.ceil(v.getX(), v.getY());
    }

    @NotNull
    public static final Vector round(double x2, double y2) {
        return new Vector((int)Math.rint(x2), (int)Math.rint(y2));
    }

    @NotNull
    public static final Vector ceil(double x2, double y2) {
        return new Vector((int)Math.ceil(x2), (int)Math.ceil(y2));
    }

    public static final double ipow(int $this$ipow, int e) {
        return Math.pow($this$ipow, e);
    }

    public static final boolean areEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static /* synthetic */ boolean areEqual$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0E-5;
        }
        return MathKt.areEqual(d, d2, d3);
    }

    public static final double length(double x2, double y2) {
        return Math.sqrt(MathKt.length2(x2, y2));
    }

    public static final double length2(double x2, double y2) {
        return x2 * x2 + y2 * y2;
    }

    public static final double dot(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    public static final double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(MathKt.distance2(x1, y1, x2, y2));
    }

    public static final double distance2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    public static final boolean isOnSegment(double x2, double y2, double p1x, double p1y, double p2x, double p2y) {
        double v1x = x2 - p1x;
        double v1y = y2 - p1y;
        double v21x = p2x - p1x;
        double v21y = p2y - p1y;
        double t = MathKt.dot(v1x, v1y, v21x, v21y) / MathKt.length2(v21x, v21y);
        return 0.0 <= t ? t <= 1.0 : false;
    }

    public static final double distance2ToLine(double x2, double y2, double l1x, double l1y, double l2x, double l2y) {
        if (l1x == l2x && l1y == l2y) {
            return MathKt.distance2(x2, y2, l1x, l1y);
        }
        double vX = l2x - l1x;
        double vY = l2y - l1y;
        double vOrtX = -vY;
        double vOrtY = vX;
        double hx = x2 - l1x;
        double hy = y2 - l1y;
        double dot = MathKt.dot(hx, hy, vOrtX, vOrtY);
        double len = MathKt.length2(vOrtX, vOrtY);
        return dot * dot / len;
    }

    public static final double distance2ToSegment(double x2, double y2, double l1x, double l1y, double l2x, double l2y) {
        if (l1x == l2x && l1y == l2y) {
            return MathKt.distance2(x2, y2, l1x, l1y);
        }
        if (MathKt.isOnSegment(x2, y2, l1x, l1y, l2x, l2y)) {
            return MathKt.distance2ToLine(x2, y2, l1x, l1y, l2x, l2y);
        }
        return Math.min(MathKt.distance2(x2, y2, l1x, l1y), MathKt.distance2(x2, y2, l2x, l2y));
    }

    @NotNull
    public static final Pair<Double, Double> lineParams(double p1x, double p1y, double p2x, double p2y) {
        double m = (p2y - p1y) / (p2x - p1x);
        double b = p2y - m * p2x;
        return TuplesKt.to((Object)m, (Object)b);
    }

    public static final double yOnLine(double p1x, double p1y, double p2x, double p2y, double x2) {
        Pair<Double, Double> pair2 = MathKt.lineParams(p1x, p1y, p2x, p2y);
        double m = ((Number)pair2.component1()).doubleValue();
        double b = ((Number)pair2.component2()).doubleValue();
        return m * x2 + b;
    }

    public static final double xOnLine(double p1x, double p1y, double p2x, double p2y, double y2) {
        Pair<Double, Double> pair2 = MathKt.lineParams(p1x, p1y, p2x, p2y);
        double m = ((Number)pair2.component1()).doubleValue();
        double b = ((Number)pair2.component2()).doubleValue();
        return (y2 - b) / m;
    }

    @NotNull
    public static final DoubleVector pointOnLine(double p1x, double p1y, double p2x, double p2y, double offset2) {
        double d = MathKt.distance(p2x, p2y, p1x, p1y);
        if (d == 0.0) {
            return new DoubleVector(p1x, p1y);
        }
        double k = offset2 / d;
        double x2 = p1x + (p2x - p1x) * k;
        double y2 = p1y + (p2y - p1y) * k;
        return new DoubleVector(x2, y2);
    }

    @NotNull
    public static final DoubleVector projection(double px, double py, double l1x, double l1y, double l2x, double l2y) {
        double vx = px - l1x;
        double vy = py - l1y;
        double sx = l2x - l1x;
        double sy = l2y - l1y;
        double c = MathKt.dot(vx, vy, sx, sy) / MathKt.dot(sx, sy, sx, sy);
        return new DoubleVector(sx * c + l1x, sy * c + l1y);
    }

    public static final double distance2ToSegment(@NotNull DoubleVector p, @NotNull DoubleVector l1, @NotNull DoubleVector l2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
        Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
        return MathKt.distance2ToSegment(p.getX(), p.getY(), l1.getX(), l1.getY(), l2.getX(), l2.getY());
    }

    public static final boolean isOnSegment(@NotNull DoubleVector p, @NotNull DoubleVector l1, @NotNull DoubleVector l2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
        Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
        return MathKt.isOnSegment(p.getX(), p.getY(), l1.getX(), l1.getY(), l2.getX(), l2.getY());
    }

    @NotNull
    public static final DoubleVector yOnLine(double x2, @NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return new DoubleVector(x2, MathKt.yOnLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x2));
    }

    @NotNull
    public static final DoubleVector xOnLine(double y2, @NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return new DoubleVector(MathKt.xOnLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), y2), y2);
    }

    @NotNull
    public static final DoubleVector projection(@NotNull DoubleVector p, @NotNull DoubleVector l1, @NotNull DoubleVector l2) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
        Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
        return MathKt.projection(p.getX(), p.getY(), l1.getX(), l1.getY(), l2.getX(), l2.getY());
    }

    public static final double distance2(@NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return MathKt.distance2(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double distance(@NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return MathKt.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double lineSlope(@NotNull DoubleVector p1, @NotNull DoubleVector p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return ((Number)MathKt.lineParams(p1.getX(), p1.getY(), p2.getX(), p2.getY()).getFirst()).doubleValue();
    }

    @NotNull
    public static final DoubleVector pointOnLine(@NotNull DoubleVector p1, @NotNull DoubleVector p2, double offset2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return MathKt.pointOnLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), offset2);
    }

    @NotNull
    public static final DoubleVector rotateAround(double px, double py, double cx, double cy, double phi) {
        double vx = px - cx;
        double vy = py - cy;
        double x2 = vx * Math.cos(phi) - vy * Math.sin(phi);
        double y2 = vx * Math.sin(phi) + vy * Math.cos(phi);
        return new DoubleVector(x2 + cx, y2 + cy);
    }
}

