/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.Arithmetic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\b\u0010%\u001a\u00020\u0005H\u0016R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat;", "", "significand", "", "fraction", "", "exponent", "sign", "(ILjava/lang/String;ILjava/lang/String;)V", "decimalPart", "getDecimalPart", "()Ljava/lang/String;", "getExponent", "()I", "getFraction", "isNegative", "", "()Z", "getSign", "getSignificand", "wholePart", "getWholePart", "wholePartLength", "getWholePartLength", "equals", "other", "formatDecimalStr", "Lkotlin/Pair;", "decimalPartLength", "formatScientificStr", "fractionLength", "hashCode", "shiftDecimalPoint", "delta", "toDecimalPrecision", "precision", "toPrecision", "toString", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nBigFloat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigFloat.kt\norg/jetbrains/letsPlot/commons/formatting/number/BigFloat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public final class BigFloat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int significand;
    @NotNull
    private final String sign;
    @NotNull
    private final String fraction;
    private final int exponent;
    private final boolean isNegative;
    private final int wholePartLength;
    @NotNull
    private static final BigFloat ZERO = new BigFloat(0, "0", 0, "");

    /*
     * WARNING - void declaration
     */
    private BigFloat(int significand, String fraction, int exponent, String sign) {
        void it22;
        this.significand = significand;
        this.sign = sign;
        Object object = new char[]{'0'};
        object = StringsKt.trimEnd((String)fraction, (char[])object);
        Object object2 = object;
        BigFloat bigFloat = this;
        boolean bl = false;
        boolean bl2 = ((CharSequence)it22).length() > 0;
        Object object3 = (char[])(bl2 ? object : null);
        if (object3 == null) {
            object3 = "0";
        }
        bigFloat.fraction = object3;
        object = exponent;
        int it22 = ((Number)object).intValue();
        bigFloat = this;
        boolean bl3 = false;
        bl2 = this.significand != 0 || !Intrinsics.areEqual((Object)this.fraction, (Object)"0");
        Object object4 = bl2 ? object : null;
        bigFloat.exponent = object4 != null ? (Integer)object4 : 0;
        this.isNegative = Intrinsics.areEqual((Object)this.sign, (Object)"-");
        if (this.significand == 0 && !Intrinsics.areEqual((Object)this.fraction, (Object)"0")) {
            boolean $i$a$-require-BigFloat$42 = false;
            String $i$a$-require-BigFloat$42 = "i should be in 0..9, but was " + this.significand;
            throw new IllegalArgumentException($i$a$-require-BigFloat$42.toString());
        }
        if (this.significand != 0) {
            int n = this.significand;
            if (!(1 <= n ? n < 10 : false)) {
                boolean $i$a$-require-BigFloat$52 = false;
                String $i$a$-require-BigFloat$52 = "i should be in 0..9, but was " + this.significand;
                throw new IllegalArgumentException($i$a$-require-BigFloat$52.toString());
            }
        }
        if (!(Intrinsics.areEqual((Object)this.fraction, (Object)"0") || StringsKt.last((CharSequence)this.fraction) != '0')) {
            boolean bl4 = false;
            String string = "fraction should not end with '0'";
            throw new IllegalArgumentException(string.toString());
        }
        this.wholePartLength = exponent;
    }

    /* synthetic */ BigFloat(int n, String string, int n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            string2 = "";
        }
        this(n, string, n2, string2);
    }

    public final int getSignificand() {
        return this.significand;
    }

    @NotNull
    public final String getSign() {
        return this.sign;
    }

    @NotNull
    public final String getFraction() {
        return this.fraction;
    }

    public final int getExponent() {
        return this.exponent;
    }

    public final boolean isNegative() {
        return this.isNegative;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDecimalPart() {
        String string;
        if (this.exponent == 0) {
            string = this.fraction;
        } else if (this.exponent < 0) {
            void it;
            String string2;
            String string3 = string2 = this.fraction;
            StringBuilder stringBuilder = new StringBuilder().append(StringsKt.repeat((CharSequence)"0", (int)(-this.exponent - 1))).append(CharsKt.digitToChar((int)this.significand));
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)"0");
            String string4 = bl2 ? string2 : null;
            if (string4 == null) {
                string4 = "";
            }
            string = stringBuilder.append(string4).toString();
        } else if (this.exponent > 0) {
            if (Intrinsics.areEqual((Object)this.fraction, (Object)"0")) {
                string = "0";
            } else {
                String string5;
                String p0 = string5 = StringsKt.drop((String)this.fraction, (int)this.exponent);
                boolean bl = false;
                string = ((CharSequence)p0).length() > 0 ? string5 : null;
                if (string == null) {
                    string = "0";
                }
            }
        } else {
            throw new IllegalStateException(("Unexpected state: " + this.exponent).toString());
        }
        return string;
    }

    public final int getWholePartLength() {
        return this.wholePartLength;
    }

    @NotNull
    public final String getWholePart() {
        if (this.exponent < 0) {
            return "0";
        }
        return StringsKt.padEnd((String)(this.significand + StringsKt.take((String)this.fraction, (int)this.exponent)), (int)(this.exponent + 1), (char)'0');
    }

    @NotNull
    public final Pair<String, String> formatDecimalStr(int decimalPartLength) {
        return decimalPartLength < 0 ? TuplesKt.to((Object)this.getWholePart(), (Object)this.getDecimalPart()) : TuplesKt.to((Object)this.getWholePart(), (Object)StringsKt.padEnd((String)StringsKt.take((String)this.getDecimalPart(), (int)decimalPartLength), (int)decimalPartLength, (char)'0'));
    }

    public static /* synthetic */ Pair formatDecimalStr$default(BigFloat bigFloat, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return bigFloat.formatDecimalStr(n);
    }

    @NotNull
    public final Pair<String, String> formatScientificStr(int fractionLength) {
        return fractionLength < 0 ? TuplesKt.to((Object)String.valueOf(this.significand), (Object)this.fraction) : TuplesKt.to((Object)String.valueOf(this.significand), (Object)StringsKt.padEnd((String)StringsKt.take((String)this.fraction, (int)fractionLength), (int)fractionLength, (char)'0'));
    }

    public static /* synthetic */ Pair formatScientificStr$default(BigFloat bigFloat, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return bigFloat.formatScientificStr(n);
    }

    @NotNull
    public final BigFloat toDecimalPrecision(int precision) {
        return this.toPrecision(Math.max(0, precision + this.exponent));
    }

    @NotNull
    public final BigFloat toPrecision(int precision) {
        if (!(precision >= 0)) {
            boolean $i$a$-require-BigFloat$toPrecision$22 = false;
            String $i$a$-require-BigFloat$toPrecision$22 = "Precision should be non-negative, but was " + precision;
            throw new IllegalArgumentException($i$a$-require-BigFloat$toPrecision$22.toString());
        }
        if (precision > this.fraction.length()) {
            return this;
        }
        Pair<String, Boolean> pair2 = Arithmetic.INSTANCE.round(this.fraction, precision);
        String roundedFraction = (String)pair2.component1();
        boolean carry = (Boolean)pair2.component2();
        return carry ? (this.significand == 9 ? new BigFloat(1, '0' + roundedFraction, this.exponent + 1, this.sign) : new BigFloat(this.significand + 1, roundedFraction, this.exponent, this.sign)) : new BigFloat(this.significand, roundedFraction, this.exponent, this.sign);
    }

    @NotNull
    public final BigFloat shiftDecimalPoint(int delta) {
        return new BigFloat(this.significand, this.fraction, this.exponent + delta, this.sign);
    }

    @NotNull
    public String toString() {
        return "Floating(i=" + this.significand + ", fraction='" + this.fraction + "', e=" + this.exponent + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BigFloat cfr_ignored_0 = (BigFloat)other;
        if (this.significand != ((BigFloat)other).significand) {
            return false;
        }
        if (this.exponent != ((BigFloat)other).exponent) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sign, (Object)((BigFloat)other).sign)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fraction, (Object)((BigFloat)other).fraction);
    }

    public int hashCode() {
        int result = this.significand;
        result = 31 * result + this.exponent;
        result = 31 * result + this.sign.hashCode();
        result = 31 * result + this.fraction.hashCode();
        return result;
    }

    public /* synthetic */ BigFloat(int significand, String fraction, int exponent, String sign, DefaultConstructorMarker $constructor_marker) {
        this(significand, fraction, exponent, sign);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ/\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat$Companion;", "", "()V", "ZERO", "Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat;", "getZERO", "()Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat;", "fromNumber", "number", "", "fromScientific", "i", "", "fraction", "", "exponent", "sign", "fromScientific$commons", "commons"})
    @SourceDebugExtension(value={"SMAP\nBigFloat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigFloat.kt\norg/jetbrains/letsPlot/commons/formatting/number/BigFloat$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,201:1\n151#2,6:202\n*S KotlinDebug\n*F\n+ 1 BigFloat.kt\norg/jetbrains/letsPlot/commons/formatting/number/BigFloat$Companion\n*L\n173#1:202,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BigFloat fromNumber(@NotNull Number number) {
            BigFloat bigFloat;
            MatchResult.Destructured destructured;
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            double dbl = number.doubleValue();
            if (dbl == 0.0) {
                return this.getZERO();
            }
            if (Double.isNaN(dbl)) {
                return null;
            }
            if (Double.isInfinite(dbl)) {
                return null;
            }
            String sign = Math.signum(dbl) < 0.0 ? "-" : "";
            Regex regex = new Regex("^(\\d+)\\.?(\\d+)?e?([+-]?\\d+)?$");
            String string = String.valueOf(Math.abs(dbl)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            if (matchResult == null || (destructured = matchResult.getDestructured()) == null) {
                throw new IllegalStateException(("Wrong number: " + number).toString());
            }
            MatchResult.Destructured destructured2 = destructured;
            String significandStr = (String)destructured2.getMatch().getGroupValues().get(1);
            String fractionStr = (String)destructured2.getMatch().getGroupValues().get(2);
            String exponentString = (String)destructured2.getMatch().getGroupValues().get(3);
            if (((CharSequence)exponentString).length() > 0) {
                if (!(significandStr.length() == 1)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                bigFloat = new BigFloat(Integer.parseInt(significandStr), fractionStr, Integer.parseInt(exponentString), sign, null);
            } else if (Math.abs(dbl) < 1.0) {
                int n;
                block12: {
                    CharSequence $this$indexOfFirst$iv = fractionStr;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it != '0')) continue;
                        n = index$iv;
                        break block12;
                    }
                    n = -1;
                }
                int significantDigitPos = n;
                char significand = fractionStr.charAt(significantDigitPos);
                String fraction = StringsKt.drop((String)fractionStr, (int)(significantDigitPos + 1));
                int exponent = -significantDigitPos - 1;
                bigFloat = new BigFloat(CharsKt.digitToInt((char)significand), fraction, exponent, sign, null);
            } else if (Math.abs(dbl) >= 1.0) {
                Pair pair2 = TuplesKt.to((Object)Integer.parseInt(StringsKt.take((String)significandStr, (int)1)), (Object)StringsKt.drop((String)significandStr, (int)1));
                int significand = ((Number)pair2.component1()).intValue();
                String fractionPartStart = (String)pair2.component2();
                String fraction = fractionPartStart + fractionStr;
                int exponent = fractionPartStart.length();
                bigFloat = new BigFloat(significand, fraction, exponent, sign, null);
            } else {
                throw new IllegalStateException(("Unexpected number: " + number).toString());
            }
            return bigFloat;
        }

        @NotNull
        public final BigFloat fromScientific$commons(int i, @NotNull String fraction, int exponent, @NotNull String sign) {
            Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            return new BigFloat(i, fraction, exponent, sign, null);
        }

        public static /* synthetic */ BigFloat fromScientific$commons$default(Companion companion, int n, String string, int n2, String string2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                string2 = "";
            }
            return companion.fromScientific$commons(n, string, n2, string2);
        }

        @NotNull
        public final BigFloat getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

