/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.WeekDay;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u0011\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0003H\u0016J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "", "day", "", "month", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Month;", "year", "(ILorg/jetbrains/letsPlot/commons/intern/datetime/Month;I)V", "kotlinxLocalDate", "Lkotlinx/datetime/LocalDate;", "(Lkotlinx/datetime/LocalDate;)V", "getDay", "()I", "getKotlinxLocalDate$commons", "()Lkotlinx/datetime/LocalDate;", "getMonth", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Month;", "weekDay", "Lorg/jetbrains/letsPlot/commons/intern/datetime/WeekDay;", "getWeekDay", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/WeekDay;", "getYear", "addDays", "count", "addMonths", "compareTo", "other", "daysFromYearStart", "daysUntil", "equals", "", "", "hashCode", "nextDate", "prevDate", "subtractDays", "toString", "", "Companion", "commons"})
public final class Date
implements Comparable<Date> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDate kotlinxLocalDate;
    @NotNull
    private static final Date EPOCH = new Date(1, Month.JANUARY, 1970);

    public Date(int day, @NotNull Month month, int year) {
        Intrinsics.checkNotNullParameter((Object)((Object)month), (String)"month");
        this.kotlinxLocalDate = new LocalDate(year, month.getNumber(), day);
    }

    public Date(@NotNull LocalDate kotlinxLocalDate) {
        Intrinsics.checkNotNullParameter((Object)kotlinxLocalDate, (String)"kotlinxLocalDate");
        this.kotlinxLocalDate = kotlinxLocalDate;
    }

    @NotNull
    public final LocalDate getKotlinxLocalDate$commons() {
        return this.kotlinxLocalDate;
    }

    public final int getDay() {
        return this.kotlinxLocalDate.getDayOfMonth();
    }

    @NotNull
    public final Month getMonth() {
        return Month.Companion.of(this.kotlinxLocalDate.getMonthNumber());
    }

    public final int getYear() {
        return this.kotlinxLocalDate.getYear();
    }

    @NotNull
    public final WeekDay getWeekDay() {
        return (WeekDay)((Object)WeekDay.getEntries().get(this.kotlinxLocalDate.getDayOfWeek().ordinal()));
    }

    @NotNull
    public final Date nextDate() {
        return new Date(LocalDateJvmKt.plus((LocalDate)this.kotlinxLocalDate, (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())));
    }

    @NotNull
    public final Date prevDate() {
        return new Date(LocalDateJvmKt.plus((LocalDate)this.kotlinxLocalDate, (int)-1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())));
    }

    @NotNull
    public final Date addDays(int count) {
        return new Date(LocalDateJvmKt.plus((LocalDate)this.kotlinxLocalDate, (int)count, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())));
    }

    @NotNull
    public final Date subtractDays(int count) {
        return new Date(LocalDateJvmKt.minus((LocalDate)this.kotlinxLocalDate, (int)count, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())));
    }

    @NotNull
    public final Date addMonths(int count) {
        return new Date(LocalDateJvmKt.plus((LocalDate)this.kotlinxLocalDate, (int)count, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getMONTH())));
    }

    public final int daysFromYearStart() {
        LocalDate yearStart = new LocalDate(this.getYear(), 1, 1);
        return this.kotlinxLocalDate.toEpochDays() - yearStart.toEpochDays();
    }

    public final int daysUntil(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LocalDateJvmKt.daysUntil((LocalDate)this.kotlinxLocalDate, (LocalDate)other.kotlinxLocalDate);
    }

    @Override
    public int compareTo(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.kotlinxLocalDate.compareTo(other.kotlinxLocalDate);
    }

    public int hashCode() {
        return this.kotlinxLocalDate.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Date)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kotlinxLocalDate, (Object)((Date)other).kotlinxLocalDate);
    }

    @NotNull
    public String toString() {
        return this.kotlinxLocalDate.toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/Date$Companion;", "", "()V", "EPOCH", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "getEPOCH", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "parse", "s", "", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Date getEPOCH() {
            return EPOCH;
        }

        @NotNull
        public final Date parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return new Date(LocalDate.Companion.parse$default((LocalDate.Companion)LocalDate.Companion, (CharSequence)s, null, (int)2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

