/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.markdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Lexer;", "", "text", "", "(Ljava/lang/String;)V", "currentToken", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Token;", "i", "", "tokenStart", "advance", "", "n", "advanceText", "isFinished", "", "isPunctuation", "ch", "", "matchToken", "token", "nextToken", "peek", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "startToken", "Companion", "Token", "TokenType", "commons"})
public final class Lexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    private int i;
    private int tokenStart;
    private Token currentToken;

    private Lexer(String text) {
        this.text = text;
    }

    private final void nextToken() {
        if (this.isFinished()) {
            this.currentToken = new Token(TokenType.EOF, "");
            return;
        }
        this.startToken();
        TokenType token = this.peek();
        switch (WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 1: {
                this.advance(3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.advance(1);
                break;
            }
            case 8: {
                this.advanceText();
            }
        }
        String string = this.text.substring(this.tokenStart, this.i);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.currentToken = new Token(token, string);
    }

    private final TokenType peek() {
        char c = this.text.charAt(this.i);
        return this.matchToken("  \n") ? TokenType.LINE_BREAK : (this.matchToken("\n") ? TokenType.SOFT_BREAK : (CharsKt.isWhitespace((char)c) ? TokenType.WHITE_SPACE : (this.matchToken("*") ? TokenType.ASTERISK : (this.matchToken("_") ? TokenType.UNDERSCORE : (this.matchToken(" ") ? TokenType.WHITE_SPACE : (this.matchToken("\\") ? TokenType.BACKSLASH : (this.isPunctuation(c) ? TokenType.PUNCTUATION : TokenType.TEXT)))))));
    }

    private final boolean isPunctuation(char ch) {
        Object[] objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~')};
        return SetsKt.setOf((Object[])objectArray).contains(Character.valueOf(ch));
    }

    private final boolean matchToken(String token) {
        if (this.text.length() - this.i < token.length()) {
            return false;
        }
        return StringsKt.regionMatches$default((String)this.text, (int)this.i, (String)token, (int)0, (int)token.length(), (boolean)false, (int)16, null);
    }

    private final boolean isFinished() {
        return this.i >= this.text.length();
    }

    private final void advanceText() {
        while (!this.isFinished() && this.peek() == TokenType.TEXT) {
            Lexer.advance$default(this, 0, 1, null);
        }
    }

    private final void startToken() {
        this.tokenStart = this.i;
    }

    private final void advance(int n) {
        this.i += n;
    }

    static /* synthetic */ void advance$default(Lexer lexer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        lexer.advance(n);
    }

    public /* synthetic */ Lexer(String text, DefaultConstructorMarker $constructor_marker) {
        this(text);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Companion;", "", "()V", "tokenize", "", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Token;", "text", "", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Token> tokenize(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Lexer lexer = new Lexer(text, null);
            List tokens = new ArrayList();
            while (!lexer.isFinished()) {
                lexer.nextToken();
                Collection collection = tokens;
                Token token = lexer.currentToken;
                if (token == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentToken");
                    token = null;
                }
                collection.add(token);
            }
            return tokens;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Token;", "", "type", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "value", "", "(Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;Ljava/lang/String;)V", "getType", "()Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "getValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "commons"})
    public static final class Token {
        @NotNull
        private final TokenType type;
        @NotNull
        private final String value;

        public Token(@NotNull TokenType type, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.type = type;
            this.value = value;
        }

        @NotNull
        public final TokenType getType() {
            return this.type;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final TokenType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Token copy(@NotNull TokenType type, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Token(type, value);
        }

        public static /* synthetic */ Token copy$default(Token token, TokenType tokenType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                tokenType = token.type;
            }
            if ((n & 2) != 0) {
                string = token.value;
            }
            return token.copy(tokenType, string);
        }

        @NotNull
        public String toString() {
            return "Token(type=" + (Object)((Object)this.type) + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (this.type != token.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)token.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "", "(Ljava/lang/String;I)V", "EOF", "BACKSLASH", "WHITE_SPACE", "PUNCTUATION", "TEXT", "ASTERISK", "UNDERSCORE", "LINE_BREAK", "SOFT_BREAK", "commons"})
    public static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType EOF = new TokenType();
        public static final /* enum */ TokenType BACKSLASH = new TokenType();
        public static final /* enum */ TokenType WHITE_SPACE = new TokenType();
        public static final /* enum */ TokenType PUNCTUATION = new TokenType();
        public static final /* enum */ TokenType TEXT = new TokenType();
        public static final /* enum */ TokenType ASTERISK = new TokenType();
        public static final /* enum */ TokenType UNDERSCORE = new TokenType();
        public static final /* enum */ TokenType LINE_BREAK = new TokenType();
        public static final /* enum */ TokenType SOFT_BREAK = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String value) {
            return Enum.valueOf(TokenType.class, value);
        }

        @NotNull
        public static EnumEntries<TokenType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tokenTypeArray = new TokenType[]{TokenType.EOF, TokenType.BACKSLASH, TokenType.WHITE_SPACE, TokenType.PUNCTUATION, TokenType.TEXT, TokenType.ASTERISK, TokenType.UNDERSCORE, TokenType.LINE_BREAK, TokenType.SOFT_BREAK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.LINE_BREAK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ASTERISK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.UNDERSCORE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.SOFT_BREAK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.WHITE_SPACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.BACKSLASH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.PUNCTUATION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TEXT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.EOF.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

