/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.values;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "", "width", "", "height", "argbInts", "", "(II[I)V", "getArgbInts", "()[I", "getHeight", "()I", "getWidth", "getPixel", "Lorg/jetbrains/letsPlot/commons/values/Color;", "x", "y", "rgbaBytes", "", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nBitmap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bitmap.kt\norg/jetbrains/letsPlot/commons/values/Bitmap\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,61:1\n13330#2,2:62\n*S KotlinDebug\n*F\n+ 1 Bitmap.kt\norg/jetbrains/letsPlot/commons/values/Bitmap\n*L\n30#1:62,2\n*E\n"})
public final class Bitmap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final int[] argbInts;

    public Bitmap(int width, int height, @NotNull int[] argbInts) {
        Intrinsics.checkNotNullParameter((Object)argbInts, (String)"argbInts");
        this.width = width;
        this.height = height;
        this.argbInts = argbInts;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final int[] getArgbInts() {
        return this.argbInts;
    }

    @Nullable
    public final Color getPixel(int x2, int y2) {
        if (x2 < 0 || x2 >= this.width || y2 < 0 || y2 >= this.height) {
            return null;
        }
        int argb = this.argbInts[y2 * this.width + x2];
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new Color(r, g, b, a);
    }

    @NotNull
    public final byte[] rgbaBytes() {
        byte[] rgba = new byte[this.width * this.height * 4];
        int i = 0;
        int[] $this$forEach$iv = this.argbInts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            int element$iv;
            int pixel = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            int a = pixel >> 24 & 0xFF;
            int r = pixel >> 16 & 0xFF;
            int g = pixel >> 8 & 0xFF;
            int b = pixel & 0xFF;
            int n2 = i;
            i = n2 + 1;
            rgba[n2] = (byte)r;
            n2 = i;
            i = n2 + 1;
            rgba[n2] = (byte)g;
            n2 = i;
            i = n2 + 1;
            rgba[n2] = (byte)b;
            n2 = i;
            i = n2 + 1;
            rgba[n2] = (byte)a;
        }
        return rgba;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/commons/values/Bitmap$Companion;", "", "()V", "fromRGBABytes", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "w", "", "h", "rgba", "", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Bitmap fromRGBABytes(int w, int h, @NotNull byte[] rgba) {
            Intrinsics.checkNotNullParameter((Object)rgba, (String)"rgba");
            int[] argbValues = new int[w * h];
            int i = 0;
            for (int y2 = 0; y2 < h; ++y2) {
                for (int x2 = 0; x2 < w; ++x2) {
                    int r = rgba[i++] & 0xFF;
                    int g = rgba[i++] & 0xFF;
                    int b = rgba[i++] & 0xFF;
                    int a = rgba[i++] & 0xFF;
                    argbValues[y2 * w + x2] = a << 24 | r << 16 | g << 8 | b;
                }
            }
            return new Bitmap(w, h, argbValues);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

