/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.mapping.framework;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.datamodel.mapping.framework.BaseRoleSynchronizer;
import org.jetbrains.letsPlot.datamodel.mapping.framework.DifferenceBuilder;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper;
import org.jetbrains.letsPlot.datamodel.mapping.framework.MappingContext;
import org.jetbrains.letsPlot.datamodel.mapping.framework.SynchronizerContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001\u0017B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0014R*\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u00050\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR'\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/datamodel/mapping/framework/BaseCollectionRoleSynchronizer;", "SourceT", "TargetT", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/BaseRoleSynchronizer;", "mapper", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;)V", "mappers", "", "getMappers", "()Ljava/util/List;", "modifiableMappers", "", "getModifiableMappers", "myMappingContext", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContext;", "attach", "", "ctx", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/SynchronizerContext;", "detach", "onAttach", "onDetach", "MapperUpdater", "datamodel"})
public abstract class BaseCollectionRoleSynchronizer<SourceT, TargetT>
extends BaseRoleSynchronizer<SourceT, TargetT> {
    @NotNull
    private final List<Mapper<? extends SourceT, ? extends TargetT>> modifiableMappers;
    @Nullable
    private MappingContext myMappingContext;

    public BaseCollectionRoleSynchronizer(@NotNull Mapper<?, ?> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.modifiableMappers = (List)mapper.createChildList();
    }

    @NotNull
    public final List<Mapper<? extends SourceT, ? extends TargetT>> getModifiableMappers() {
        return this.modifiableMappers;
    }

    @Override
    @NotNull
    public List<Mapper<? extends SourceT, ? extends TargetT>> getMappers() {
        return this.modifiableMappers;
    }

    @Override
    public void attach(@NotNull SynchronizerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.myMappingContext != null) {
            throw new IllegalStateException();
        }
        this.myMappingContext = ctx.getMappingContext();
        this.onAttach();
    }

    @Override
    public void detach() {
        if (this.myMappingContext == null) {
            throw new IllegalStateException();
        }
        this.onDetach();
        this.myMappingContext = null;
    }

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\bH\u0014J(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\bH\u0014J\u0014\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/datamodel/mapping/framework/BaseCollectionRoleSynchronizer$MapperUpdater;", "", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/BaseCollectionRoleSynchronizer;)V", "mapperAdded", "", "index", "", "mapper", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "mapperRemoved", "update", "sourceList", "", "datamodel"})
    protected class MapperUpdater {
        public final void update(@NotNull List<? extends SourceT> sourceList) {
            Intrinsics.checkNotNullParameter(sourceList, (String)"sourceList");
            ArrayList targetContent = new ArrayList();
            List mappers = BaseCollectionRoleSynchronizer.this.getModifiableMappers();
            for (Mapper m : mappers) {
                targetContent.add(m.getSource());
            }
            List<DifferenceBuilder.DifferenceItem> difference = new DifferenceBuilder(sourceList, targetContent).build();
            for (DifferenceBuilder.DifferenceItem item : difference) {
                Mapper mapper;
                int itemIndex = item.getIndex();
                if (item.isAdd()) {
                    mapper = BaseCollectionRoleSynchronizer.this.createMapper(item.getItem());
                    mappers.add(itemIndex, mapper);
                    this.mapperAdded(itemIndex, mapper);
                    BaseCollectionRoleSynchronizer.this.processMapper(mapper);
                    continue;
                }
                mapper = mappers.remove(itemIndex);
                this.mapperRemoved(itemIndex, mapper);
            }
        }

        protected void mapperAdded(int index, @NotNull Mapper<? extends SourceT, ? extends TargetT> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        }

        protected void mapperRemoved(int index, @NotNull Mapper<? extends SourceT, ? extends TargetT> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        }
    }
}

