/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.mapping.framework.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.function.Functions;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.Composite;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.Composites;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.CompositesWithBounds;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.HasBounds;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.HasFocusability;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.HasParent;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.HasVisibility;
import org.jetbrains.letsPlot.datamodel.mapping.framework.composite.NavComposite;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\bC\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\n\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0013\u001a\u00020\u0014\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0015\u001a\u0002H\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u0004\u0018\u0001H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u001a\u001a\u0002H\u000e2\u0006\u0010\u001b\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u00020\u001e\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u001f\u001a\u0002H\u00072\u0006\u0010 \u001a\u0002H\u0007H\u0000\u00a2\u0006\u0004\b!\u0010\"J/\u0010#\u001a\u0002H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%*\u00020&2\u0006\u0010'\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J-\u0010)\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010,J5\u0010)\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u00072\u0006\u0010-\u001a\u00020.\u00a2\u0006\u0002\u0010/J#\u00100\u001a\u0002H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J)\u00101\u001a\u0004\u0018\u0001H\u000e\"\u0012\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020$2\u0006\u0010+\u001a\u0002H\u000e\u00a2\u0006\u0002\u00102J1\u00101\u001a\u0004\u0018\u0001H\u000e\"\u0012\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020$2\u0006\u0010+\u001a\u0002H\u000e2\u0006\u00103\u001a\u00020.\u00a2\u0006\u0002\u00104JK\u00105\u001a\u0004\u0018\u0001H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e2\u0006\u00103\u001a\u00020.2\u001c\u00106\u001a\u0018\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020.07j\b\u0012\u0004\u0012\u0002H\u000e`8\u00a2\u0006\u0002\u00109J/\u0010:\u001a\u0002H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%*\u00020&2\u0006\u0010'\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J;\u0010;\u001a\u00020\u0014\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010<\u001a\u0002H\u00072\u0006\u0010\n\u001a\u0002H\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0017H\u0002\u00a2\u0006\u0002\u0010>J;\u0010?\u001a\u00020.\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010@\u001a\u0002H\u00072\u0006\u0010\n\u001a\u0002H\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0017H\u0002\u00a2\u0006\u0002\u0010AJ%\u0010B\u001a\u00020.\"\b\b\u0000\u0010\u0007*\u00020&2\u0006\u0010C\u001a\u0002H\u00072\u0006\u0010D\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010EJ+\u0010F\u001a\u00020.\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u001f\u001a\u0002H\u00072\u0006\u0010 \u001a\u0002H\u0007\u00a2\u0006\u0002\u0010GJ%\u0010H\u001a\u00020.\"\b\b\u0000\u0010\u0007*\u00020&2\u0006\u0010D\u001a\u0002H\u00072\u0006\u0010C\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010EJ-\u0010I\u001a\u00020.\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\b\u0010J\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010KJ'\u0010L\u001a\u00020.\"\u0012\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020%2\u0006\u0010'\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010MJ+\u0010N\u001a\u00020.\"\u0016\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010OJ'\u0010P\u001a\u00020.\"\u0012\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020%2\u0006\u0010+\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010MJ#\u0010Q\u001a\u00020.\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010RJ'\u0010S\u001a\u00020.\"\u0012\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f*\u00020%2\u0006\u0010+\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010OJ9\u0010T\u001a\b\u0012\u0004\u0012\u0002HU0\r\"\u0004\b\u0000\u0010U2\u0006\u0010V\u001a\u0002HU2\u0014\u0010W\u001a\u0010\u0012\u0004\u0012\u0002HU\u0012\u0006\u0012\u0004\u0018\u0001HU07H\u0000\u00a2\u0006\u0004\bX\u0010YJ9\u0010Z\u001a\b\u0012\u0004\u0012\u0002HU0\r\"\u0004\b\u0000\u0010U2\b\u0010V\u001a\u0004\u0018\u0001HU2\u0014\u0010W\u001a\u0010\u0012\u0004\u0012\u0002HU\u0012\u0006\u0012\u0004\u0018\u0001HU07H\u0002\u00a2\u0006\u0002\u0010YJ-\u0010[\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020$*\u00020%2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010,J5\u0010[\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070**\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u00072\u0006\u0010-\u001a\u00020.\u00a2\u0006\u0002\u0010/J#\u0010\\\u001a\u0002H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J9\u0010]\u001a\u0004\u0018\u0001H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%*\u00020&2\u0006\u0010+\u001a\u0002H\u00072\u0006\u0010^\u001a\u00020\u001e\u00a2\u0006\u0002\u0010_JC\u0010`\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u00072\u001c\u00106\u001a\u0018\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020.07j\b\u0012\u0004\u0012\u0002H\u0007`8\u00a2\u0006\u0002\u0010aJ-\u0010b\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J%\u0010c\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J/\u0010c\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u00072\b\u0010d\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010eJ)\u0010f\u001a\b\u0012\u0004\u0012\u0002H\u00070\r\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010gJ)\u0010h\u001a\b\u0012\u0004\u0012\u0002H\u00070\r\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010gJ/\u0010h\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010i\u001a\u0002H\u00072\u0006\u0010\u0010\u001a\u0002H\u0007H\u0002\u00a2\u0006\u0002\u0010eJ%\u0010j\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070*2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010,JC\u0010k\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010+\u001a\u0002H\u00072\u001c\u00106\u001a\u0018\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020.07j\b\u0012\u0004\u0012\u0002H\u0007`8\u00a2\u0006\u0002\u0010aJ-\u0010l\u001a\u0004\u0018\u0001H\u0007\"\u0016\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%2\u0006\u0010+\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J%\u0010m\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010(J/\u0010m\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0015\u001a\u0002H\u00072\b\u0010d\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010eJ)\u0010n\u001a\b\u0012\u0004\u0012\u0002H\u00070\r\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010gJ)\u0010o\u001a\b\u0012\u0004\u0012\u0002H\u00070\r\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010gJ/\u0010o\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010i\u001a\u0002H\u00072\u0006\u0010\u0010\u001a\u0002H\u0007H\u0002\u00a2\u0006\u0002\u0010eJ%\u0010p\u001a\u0004\u0018\u0001H\u0007\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070*2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010,J#\u0010q\u001a\u00020\u0014\"\u000e\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070*2\u0006\u0010\u0015\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010rJ+\u0010s\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0015\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010tJ#\u0010u\u001a\u0002H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0010\u001a\u0002H\u000e\u00a2\u0006\u0002\u00102J'\u0010v\u001a\b\u0012\u0004\u0012\u0002Hw0\u0006\"\u0004\b\u0000\u0010w2\f\u0010x\u001a\b\u0012\u0004\u0012\u0002Hw0\rH\u0000\u00a2\u0006\u0002\byJ9\u0010z\u001a\u0004\u0018\u0001H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b*\u00020$*\u00020%*\u00020&2\u0006\u0010+\u001a\u0002H\u00072\u0006\u0010^\u001a\u00020\u001e\u00a2\u0006\u0002\u0010_R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composites;", "", "()V", "ourWithBounds", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/CompositesWithBounds;", "allBetween", "", "CompositeT", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;", "from", "to", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Ljava/util/List;", "ancestors", "", "HasParentT", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;", "current", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Ljava/lang/Iterable;", "ancestorsFrom", "collectReverseAncestors", "", "c", "result", "", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;Ljava/util/List;)V", "commonAncestor", "object1", "object2", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;", "deltaBetween", "", "c1", "c2", "deltaBetween$datamodel", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)I", "endElement", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasFocusability;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasVisibility;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasBounds;", "cell", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;", "firstFocusable", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;", "v", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;", "deepest", "", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;Z)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;", "firstLeaf", "focusableParent", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;", "acceptSelf", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;Z)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;", "getClosestAncestor", "p", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/intern/function/Predicate;", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;ZLkotlin/jvm/functions/Function1;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;", "homeElement", "includeClosed", "left", "res", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Ljava/util/List;)V", "includeOpen", "node", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Ljava/util/List;)Z", "isAbove", "upper", "lower", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasBounds;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasBounds;)Z", "isBefore", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Z", "isBelow", "isDescendant", "ancestor", "(Ljava/lang/Object;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Z", "isFirstChild", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;)Z", "isFocusable", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Z", "isLastChild", "isNonCompositeChild", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Z", "isVisible", "iterate", "ValueT", "initial", "trans", "iterate$datamodel", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Iterable;", "iterateFrom", "lastFocusable", "lastLeaf", "lowerFocusable", "xOffset", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;I)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;", "next", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;", "nextFocusable", "nextLeaf", "within", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;", "nextLeaves", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/NavComposite;)Ljava/lang/Iterable;", "nextNavOrder", "start", "nextSibling", "prev", "prevFocusable", "prevLeaf", "prevLeaves", "prevNavOrder", "prevSibling", "removeFromParent", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/Composite;)V", "reverseAncestors", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/composite/HasParent;)Ljava/util/List;", "root", "toList", "ItemT", "it", "toList$datamodel", "upperFocusable", "datamodel"})
public final class Composites {
    @NotNull
    public static final Composites INSTANCE = new Composites();
    @NotNull
    private static final CompositesWithBounds ourWithBounds = new CompositesWithBounds(0);

    private Composites() {
    }

    public final <CompositeT extends Composite<CompositeT>> void removeFromParent(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Composite composite = (Composite)c.getParent();
        if (composite == null) {
            return;
        }
        Composite parent = composite;
        parent.children().remove(c);
    }

    public final <CompositeT extends NavComposite<CompositeT>> boolean isNonCompositeChild(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.getParent() == null) {
            return false;
        }
        if (c.nextSibling() != null) {
            return false;
        }
        if (c.prevSibling() != null) {
            return false;
        }
        Object ParentT = c.getParent();
        Intrinsics.checkNotNull(ParentT);
        List children2 = ((NavComposite)ParentT).children();
        if (children2.size() != 1) {
            return true;
        }
        return children2.get(0) != c;
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT>> CompositeT nextSibling(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Composite composite = (Composite)c.getParent();
        if (composite == null) {
            return null;
        }
        Composite parent = composite;
        int index = parent.children().indexOf(c);
        if (index == -1) {
            return null;
        }
        return (CompositeT)(index + 1 < parent.children().size() ? (Composite)parent.children().get(index + 1) : null);
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT>> CompositeT prevSibling(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Composite composite = (Composite)c.getParent();
        if (composite == null) {
            return null;
        }
        Composite parent = composite;
        int index = parent.children().indexOf(c);
        if (index == -1) {
            return null;
        }
        return (CompositeT)(index > 0 ? (Composite)parent.children().get(index - 1) : null);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT firstLeaf(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        CompositeT CompositeT = c.firstChild();
        if (CompositeT == null) {
            return c;
        }
        CompositeT first = CompositeT;
        return this.firstLeaf(first);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT lastLeaf(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        CompositeT CompositeT = c.lastChild();
        if (CompositeT == null) {
            return c;
        }
        CompositeT last = CompositeT;
        return this.lastLeaf(last);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT nextLeaf(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this.nextLeaf(c, null);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT nextLeaf(@NotNull CompositeT c, @Nullable CompositeT within) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Object current = c;
        CompositeT nextSibling;
        while ((nextSibling = current.nextSibling()) == null) {
            if (this.isNonCompositeChild(current)) {
                return null;
            }
            NavComposite parent = (NavComposite)current.getParent();
            if (parent == within) {
                return null;
            }
            Intrinsics.checkNotNull((Object)parent);
        }
        return this.firstLeaf(nextSibling);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT prevLeaf(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this.prevLeaf(c, null);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT prevLeaf(@NotNull CompositeT c, @Nullable CompositeT within) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Object current = c;
        CompositeT prevSibling;
        while ((prevSibling = current.prevSibling()) == null) {
            if (this.isNonCompositeChild(current)) {
                return null;
            }
            NavComposite parent = (NavComposite)current.getParent();
            if (parent == within) {
                return null;
            }
            Intrinsics.checkNotNull((Object)parent);
        }
        return this.lastLeaf(prevSibling);
    }

    @NotNull
    public final <HasParentT extends HasParent<HasParentT>> HasParentT root(@NotNull HasParentT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        HasParentT c = current;
        while (c.getParent() != null) {
            Intrinsics.checkNotNull(c.getParent());
        }
        return c;
    }

    @NotNull
    public final <HasParentT extends HasParent<HasParentT>> Iterable<HasParentT> ancestorsFrom(@NotNull HasParentT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterateFrom(current, ancestorsFrom.1.INSTANCE);
    }

    @NotNull
    public final <HasParentT extends HasParent<HasParentT>> Iterable<HasParentT> ancestors(@NotNull HasParentT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterate$datamodel(current, ancestors.1.INSTANCE);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> Iterable<CompositeT> nextLeaves(@NotNull CompositeT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterate$datamodel(current, nextLeaves.1.INSTANCE);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> Iterable<CompositeT> prevLeaves(@NotNull CompositeT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterate$datamodel(current, prevLeaves.1.INSTANCE);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> Iterable<CompositeT> nextNavOrder(@NotNull CompositeT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterate$datamodel(current, (Function1)new Function1<CompositeT, CompositeT>(current){
            final /* synthetic */ CompositeT $current;
            {
                this.$current = $current;
                super(1);
            }

            @Nullable
            public final CompositeT invoke(@NotNull CompositeT it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (CompositeT)Composites.access$nextNavOrder(Composites.INSTANCE, this.$current, it);
            }
        });
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> Iterable<CompositeT> prevNavOrder(@NotNull CompositeT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.iterate$datamodel(current, (Function1)new Function1<CompositeT, CompositeT>(current){
            final /* synthetic */ CompositeT $current;
            {
                this.$current = $current;
                super(1);
            }

            @Nullable
            public final CompositeT invoke(@NotNull CompositeT it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (CompositeT)Composites.access$prevNavOrder(Composites.INSTANCE, this.$current, it);
            }
        });
    }

    private final <CompositeT extends NavComposite<CompositeT>> CompositeT nextNavOrder(CompositeT start, CompositeT current) {
        NavComposite navComposite;
        CompositeT nextSibling = current.nextSibling();
        if (nextSibling != null) {
            return this.firstLeaf(nextSibling);
        }
        if (this.isNonCompositeChild(current)) {
            return null;
        }
        NavComposite parent = (NavComposite)current.getParent();
        if (!this.isDescendant(parent, (HasParent)start)) {
            navComposite = parent;
        } else {
            NavComposite navComposite2 = parent;
            Intrinsics.checkNotNull((Object)navComposite2);
            navComposite = this.nextNavOrder(start, navComposite2);
        }
        return (CompositeT)navComposite;
    }

    private final <CompositeT extends NavComposite<CompositeT>> CompositeT prevNavOrder(CompositeT start, CompositeT current) {
        NavComposite navComposite;
        CompositeT prevSibling = current.prevSibling();
        if (prevSibling != null) {
            return this.lastLeaf(prevSibling);
        }
        if (this.isNonCompositeChild(current)) {
            return null;
        }
        NavComposite parent = (NavComposite)current.getParent();
        if (!this.isDescendant(parent, (HasParent)start)) {
            navComposite = parent;
        } else {
            NavComposite navComposite2 = parent;
            Intrinsics.checkNotNull((Object)navComposite2);
            navComposite = this.prevNavOrder(start, navComposite2);
        }
        return (CompositeT)navComposite;
    }

    public final <CompositeT extends NavComposite<CompositeT>> boolean isBefore(@NotNull CompositeT c1, @NotNull CompositeT c2) {
        Intrinsics.checkNotNullParameter(c1, (String)"c1");
        Intrinsics.checkNotNullParameter(c2, (String)"c2");
        if (c1 == c2) {
            return false;
        }
        List<HasParent> c1a = this.reverseAncestors((HasParent)c1);
        List<HasParent> c2a = this.reverseAncestors((HasParent)c2);
        if (c1a.get(0) != c2a.get(0)) {
            throw new IllegalArgumentException("Items are in different trees");
        }
        int commonLength = Math.min(c1a.size(), c2a.size());
        for (int i = 1; i < commonLength; ++i) {
            NavComposite second;
            NavComposite first = (NavComposite)c1a.get(i);
            if (first == (second = (NavComposite)c2a.get(i))) continue;
            return this.deltaBetween$datamodel(first, second) > 0;
        }
        throw new IllegalArgumentException("One parameter is an ancestor of the other");
    }

    public final <CompositeT extends NavComposite<CompositeT>> int deltaBetween$datamodel(@NotNull CompositeT c1, @NotNull CompositeT c2) {
        Intrinsics.checkNotNullParameter(c1, (String)"c1");
        Intrinsics.checkNotNullParameter(c2, (String)"c2");
        CompositeT left = c1;
        CompositeT right = c1;
        int delta = 0;
        while (left != c2) {
            if (right == c2) {
                return delta;
            }
            ++delta;
            if (left == null && right == null) {
                throw new IllegalStateException("Both left and right are null");
            }
            if (left != null) {
                left = left.prevSibling();
            }
            if (right == null) continue;
            right = right.nextSibling();
        }
        return -delta;
    }

    @Nullable
    public final <HasParentT extends HasParent<HasParentT>> HasParentT commonAncestor(@NotNull HasParentT object1, @NotNull HasParentT object2) {
        Intrinsics.checkNotNullParameter(object1, (String)"object1");
        Intrinsics.checkNotNullParameter(object2, (String)"object2");
        if (object1 == object2) {
            return object1;
        }
        if (this.isDescendant(object1, object2)) {
            return object1;
        }
        if (this.isDescendant(object2, object1)) {
            return object2;
        }
        List stack1 = new ArrayList();
        List stack2 = new ArrayList();
        for (HasParentT c : this.ancestorsFrom(object1)) {
            stack1.add(c);
        }
        for (HasParentT c : this.ancestorsFrom(object2)) {
            stack2.add(c);
        }
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return null;
        }
        do {
            HasParent pop2;
            HasParent pop1;
            if ((pop1 = (HasParent)stack1.remove(stack1.size() - 1)) == (pop2 = (HasParent)stack2.remove(stack2.size() - 1))) continue;
            return (HasParentT)pop1.getParent();
        } while (!((Collection)stack1).isEmpty() && !((Collection)stack2).isEmpty());
        return null;
    }

    @Nullable
    public final <HasParentT extends HasParent<HasParentT>> HasParentT getClosestAncestor(@NotNull HasParentT current, boolean acceptSelf, @NotNull Function1<? super HasParentT, Boolean> p) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        Iterable<HasParentT> ancestors2 = acceptSelf ? this.ancestorsFrom(current) : this.ancestors(current);
        for (HasParentT c : ancestors2) {
            if (!((Boolean)p.invoke(c)).booleanValue()) continue;
            return c;
        }
        return null;
    }

    public final <HasParentT extends HasParent<HasParentT>> boolean isDescendant(@Nullable Object ancestor, @NotNull HasParentT current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        return this.getClosestAncestor(current, true, Functions.INSTANCE.same(ancestor)) != null;
    }

    private final <HasParentT extends HasParent<HasParentT>> List<HasParentT> reverseAncestors(HasParentT c) {
        ArrayList result = new ArrayList();
        this.collectReverseAncestors(c, result);
        return result;
    }

    private final <HasParentT extends HasParent<HasParentT>> void collectReverseAncestors(HasParentT c, List<HasParentT> result) {
        HasParentT parent = c.getParent();
        if (parent != null) {
            this.collectReverseAncestors(parent, result);
        }
        result.add(c);
    }

    @NotNull
    public final <ItemT> List<ItemT> toList$datamodel(@NotNull Iterable<? extends ItemT> it) {
        Intrinsics.checkNotNullParameter(it, (String)"it");
        ArrayList<ItemT> result = new ArrayList<ItemT>();
        for (ItemT i : it) {
            result.add(i);
        }
        return result;
    }

    public final <CompositeT extends Composite<CompositeT> & HasVisibility> boolean isLastChild(@NotNull CompositeT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Composite composite = (Composite)v.getParent();
        if (composite == null) {
            return false;
        }
        Composite parent = composite;
        List siblings = parent.children();
        int index = siblings.indexOf(v);
        for (Composite cv : siblings.subList(index + 1, siblings.size())) {
            if (!((Boolean)((HasVisibility)((Object)cv)).visible().get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public final <CompositeT extends Composite<CompositeT> & HasVisibility> boolean isFirstChild(@NotNull CompositeT cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        Composite composite = (Composite)cell.getParent();
        if (composite == null) {
            return false;
        }
        Composite parent = composite;
        List siblings = parent.children();
        int index = siblings.indexOf(cell);
        for (Composite cv : siblings.subList(0, index)) {
            if (!((Boolean)((HasVisibility)((Object)cv)).visible().get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT> & HasFocusability> CompositeT firstFocusable(@NotNull CompositeT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.firstFocusable(v, true);
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT> & HasFocusability> CompositeT firstFocusable(@NotNull CompositeT v, boolean deepest) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        for (Composite cv : v.children()) {
            if (!((Boolean)((HasVisibility)((Object)cv)).visible().get()).booleanValue()) continue;
            if (!deepest && ((Boolean)((HasFocusability)((Object)cv)).focusable().get()).booleanValue()) {
                return (CompositeT)cv;
            }
            Composite result = this.firstFocusable(cv);
            if (result == null) continue;
            return (CompositeT)result;
        }
        return (CompositeT)((Boolean)((HasFocusability)v).focusable().get() != false ? v : null);
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT> & HasFocusability> CompositeT lastFocusable(@NotNull CompositeT c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this.lastFocusable(c, true);
    }

    @Nullable
    public final <CompositeT extends Composite<CompositeT> & HasFocusability> CompositeT lastFocusable(@NotNull CompositeT v, boolean deepest) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        List<CompositeT> children2 = v.children();
        int n = children2.size() + -1;
        if (0 <= n) {
            do {
                int i;
                Composite cv;
                if (!((Boolean)((HasVisibility)((Object)(cv = (Composite)children2.get(i = n--)))).visible().get()).booleanValue()) continue;
                if (!deepest && ((Boolean)((HasFocusability)((Object)cv)).focusable().get()).booleanValue()) {
                    return (CompositeT)cv;
                }
                Composite result = this.lastFocusable(cv, deepest);
                if (result == null) continue;
                return (CompositeT)result;
            } while (0 <= n);
        }
        return (CompositeT)((Boolean)((HasFocusability)v).focusable().get() != false ? v : null);
    }

    public final <HasParentT extends HasParent<HasParentT> & HasVisibility> boolean isVisible(@NotNull HasParentT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getClosestAncestor(v, true, isVisible.1.INSTANCE) == null;
    }

    @Nullable
    public final <HasParentT extends HasParent<HasParentT> & HasFocusability> HasParentT focusableParent(@NotNull HasParentT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.focusableParent(v, false);
    }

    @Nullable
    public final <HasParentT extends HasParent<HasParentT> & HasFocusability> HasParentT focusableParent(@NotNull HasParentT v, boolean acceptSelf) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getClosestAncestor(v, acceptSelf, focusableParent.1.INSTANCE);
    }

    public final <HasParentT extends HasParent<HasParentT> & HasFocusability> boolean isFocusable(@NotNull HasParentT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return (Boolean)((HasFocusability)v).focusable().get() != false && this.isVisible(v);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT next(@NotNull CompositeT c, @NotNull Function1<? super CompositeT, Boolean> p) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        for (CompositeT next : this.nextNavOrder(c)) {
            if (!((Boolean)p.invoke(next)).booleanValue()) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT>> CompositeT prev(@NotNull CompositeT v, @NotNull Function1<? super CompositeT, Boolean> p) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        for (CompositeT prev : this.prevNavOrder(v)) {
            if (!((Boolean)p.invoke(prev)).booleanValue()) continue;
            return prev;
        }
        return null;
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability> CompositeT nextFocusable(@NotNull CompositeT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        for (NavComposite<CompositeT> cv : this.nextNavOrder(v)) {
            if (!this.isFocusable((HasParent)cv)) continue;
            return (CompositeT)cv;
        }
        return null;
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability> CompositeT prevFocusable(@NotNull CompositeT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        for (NavComposite<CompositeT> cv : this.prevNavOrder(v)) {
            if (!this.isFocusable((HasParent)cv)) continue;
            return (CompositeT)cv;
        }
        return null;
    }

    @NotNull
    public final <ValueT> Iterable<ValueT> iterate$datamodel(ValueT initial, @NotNull Function1<? super ValueT, ? extends ValueT> trans) {
        Intrinsics.checkNotNullParameter(trans, (String)"trans");
        return this.iterateFrom(trans.invoke(initial), trans);
    }

    private final <ValueT> Iterable<ValueT> iterateFrom(ValueT initial, Function1<? super ValueT, ? extends ValueT> trans) {
        return new Iterable<ValueT>(initial, trans){
            final /* synthetic */ ValueT $initial;
            final /* synthetic */ Function1<ValueT, ValueT> $trans;
            {
                this.$initial = $initial;
                this.$trans = $trans;
            }

            @NotNull
            public Iterator<ValueT> iterator() {
                return new Iterator<ValueT>(this.$initial, this.$trans){
                    @Nullable
                    private ValueT myCurrent;
                    final /* synthetic */ Function1<ValueT, ValueT> $trans;
                    {
                        this.$trans = $trans;
                        this.myCurrent = $initial;
                    }

                    public boolean hasNext() {
                        return this.myCurrent != null;
                    }

                    public ValueT next() {
                        ValueT result;
                        if (this.myCurrent == null) {
                            throw new NoSuchElementException();
                        }
                        ValueT ValueT = result = this.myCurrent;
                        Intrinsics.checkNotNull(ValueT);
                        this.myCurrent = this.$trans.invoke(ValueT);
                        return result;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT>> List<CompositeT> allBetween(@NotNull CompositeT from, @NotNull CompositeT to) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        ArrayList res = new ArrayList();
        if (to != from) {
            this.includeClosed(from, to, res);
        }
        return res;
    }

    private final <CompositeT extends NavComposite<CompositeT>> void includeClosed(CompositeT left, CompositeT to, List<CompositeT> res) {
        for (CompositeT next = left.nextSibling(); next != null; next = next.nextSibling()) {
            if (!this.includeOpen(next, to, res)) continue;
            return;
        }
        if (left.getParent() == null) {
            throw new IllegalArgumentException("Right bound not found in left's bound hierarchy. to=" + to);
        }
        Object ParentT = left.getParent();
        Intrinsics.checkNotNull(ParentT);
        this.includeClosed((NavComposite)ParentT, to, res);
    }

    private final <CompositeT extends NavComposite<CompositeT>> boolean includeOpen(CompositeT node, CompositeT to, List<CompositeT> res) {
        if (node == to) {
            return true;
        }
        for (NavComposite c : node.children()) {
            if (!this.includeOpen(c, to, res)) continue;
            return true;
        }
        res.add(node);
        return false;
    }

    public final <CompositeT extends HasBounds> boolean isAbove(@NotNull CompositeT upper, @NotNull CompositeT lower) {
        Intrinsics.checkNotNullParameter(upper, (String)"upper");
        Intrinsics.checkNotNullParameter(lower, (String)"lower");
        return ourWithBounds.isAbove(upper, lower);
    }

    public final <CompositeT extends HasBounds> boolean isBelow(@NotNull CompositeT lower, @NotNull CompositeT upper) {
        Intrinsics.checkNotNullParameter(lower, (String)"lower");
        Intrinsics.checkNotNullParameter(upper, (String)"upper");
        return ourWithBounds.isBelow(lower, upper);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability & HasBounds> CompositeT homeElement(@NotNull CompositeT cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        return ourWithBounds.homeElement(cell);
    }

    @NotNull
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability & HasBounds> CompositeT endElement(@NotNull CompositeT cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        return ourWithBounds.endElement(cell);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability & HasBounds> CompositeT upperFocusable(@NotNull CompositeT v, int xOffset) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return ourWithBounds.upperFocusable(v, xOffset);
    }

    @Nullable
    public final <CompositeT extends NavComposite<CompositeT> & HasFocusability & HasBounds> CompositeT lowerFocusable(@NotNull CompositeT v, int xOffset) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return ourWithBounds.lowerFocusable(v, xOffset);
    }

    public static final /* synthetic */ NavComposite access$nextNavOrder(Composites $this, NavComposite start, NavComposite current) {
        return $this.nextNavOrder(start, current);
    }

    public static final /* synthetic */ NavComposite access$prevNavOrder(Composites $this, NavComposite start, NavComposite current) {
        return $this.prevNavOrder(start, current);
    }
}

