/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColor;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextContent;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u00012\u00020\u00022\u00020\u0003:\u00011B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dH\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dH\u0016J\u0010\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 H\u0016J\u0010\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dH\u0016J\u0010\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dH\u0016J\u0010\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dH\u0016J\u0010\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dH\u0016J\u0010\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000\u001dH\u0016J\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dJ\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGraphicsElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformable;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextContent;", "content", "", "(Ljava/lang/String;)V", "x", "", "y", "(DDLjava/lang/String;)V", "()V", "bBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBBox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "computedTextLength", "getComputedTextLength", "()D", "elementName", "getElementName", "()Ljava/lang/String;", "addTSpan", "", "text", "tspan", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "addTextNode", "fill", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgColor;", "fillColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillOpacity", "pointToAbsoluteCoordinates", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "setTSpan", "setTextNode", "stroke", "strokeColor", "strokeOpacity", "strokeWidth", "textAnchor", "textDy", "transform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "Companion", "datamodel"})
public final class SvgTextElement
extends SvgGraphicsElement
implements SvgTransformable,
SvgTextContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X = SvgAttributeSpec.Companion.createSpec("x");
    @NotNull
    private static final SvgAttributeSpec<Double> Y = SvgAttributeSpec.Companion.createSpec("y");

    public SvgTextElement() {
        this.elementName = "text";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public double getComputedTextLength() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getComputedTextLength(this);
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgTextElement(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this();
        this.setTextNode(content);
    }

    public SvgTextElement(double x, double y, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this();
        this.setAttribute(X, x);
        this.setAttribute(Y, y);
        this.setTextNode(content);
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    public final void setTextNode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.children().clear();
        this.addTextNode(text);
    }

    public final void addTextNode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SvgTextNode textNode = new SvgTextNode(text);
        this.children().add((Object)textNode);
    }

    public final void setTSpan(@NotNull SvgTSpanElement tspan) {
        Intrinsics.checkNotNullParameter((Object)tspan, (String)"tspan");
        this.children().clear();
        this.addTSpan(tspan);
    }

    public final void setTSpan(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.children().clear();
        this.addTSpan(text);
    }

    public final void addTSpan(@NotNull SvgTSpanElement tspan) {
        Intrinsics.checkNotNullParameter((Object)tspan, (String)"tspan");
        this.children().add((Object)tspan);
    }

    public final void addTSpan(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.children().add((Object)new SvgTSpanElement(text));
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgTextContent.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgTextContent.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public Property<String> textAnchor() {
        return this.getAttribute(SvgTextContent.Companion.getTEXT_ANCHOR());
    }

    @Override
    @NotNull
    public Property<String> textDy() {
        return this.getAttribute(SvgTextContent.Companion.getTEXT_DY());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement$Companion;", "", "()V", "X", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "", "getX", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "Y", "getY", "datamodel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX() {
            return X;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY() {
            return Y;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

