/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001GB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\n\u0010\u000f\u001a\u00020\u0010\"\u00020\tH\u0002J1\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0006\u0010\u001d\u001a\u00020\u0000JB\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u001e\u0010\u001e\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aJ&\u0010\u001e\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010(\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J \u0010)\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001c\u001a\u00020\tH\u0002J$\u0010*\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0016\u0010,\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0-H\u0002JJ\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J6\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001aJ>\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020\t052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u001a\u00106\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J*\u00107\u001a\u00020\u00002\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t092\u0006\u0010;\u001a\u00020<J\u001c\u00107\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a092\u0006\u0010;\u001a\u00020<J\"\u0010=\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u001aJ\u0016\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\"\u0010@\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u001aJ\u0016\u0010@\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J2\u0010A\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aJ\u001e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010C\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\tJ2\u0010D\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u0016\u0010D\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aJ\u001e\u0010D\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\"\u0010E\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001aJ\u0016\u0010E\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003J\u001a\u0010F\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "", "myDefaultAbsolute", "", "(Z)V", "myStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "myTension", "", "addAction", "", "action", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathData$Action;", "absolute", "coordinates", "", "addActionWithStringTokens", "tokens", "", "", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathData$Action;Z[Ljava/lang/String;)V", "build", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathData;", "cardinalTangents", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "points", "tension", "closePath", "curveTo", "x1", "y1", "x2", "y2", "x", "y", "controlStart", "controlEnd", "to", "doBasicInterpolation", "doCardinalInterpolation", "doHermiteInterpolation", "tangents", "doLinearInterpolation", "", "ellipticalArc", "rx", "ry", "xAxisRotation", "largeArc", "sweep", "finiteDifferences", "", "horizontalLineTo", "interpolatePoints", "xs", "", "ys", "interpolation", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder$Interpolation;", "lineTo", "point", "monotoneTangents", "moveTo", "quadraticBezierCurveTo", "control", "setTension", "smoothCurveTo", "smoothQuadraticBezierCurveTo", "verticalLineTo", "Interpolation", "datamodel"})
public final class SvgPathDataBuilder {
    private final boolean myDefaultAbsolute;
    @NotNull
    private final StringBuilder myStringBuilder;
    private double myTension;

    @JvmOverloads
    public SvgPathDataBuilder(boolean myDefaultAbsolute) {
        this.myDefaultAbsolute = myDefaultAbsolute;
        this.myTension = 0.7;
        this.myStringBuilder = new StringBuilder();
    }

    public /* synthetic */ SvgPathDataBuilder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public final SvgPathData build() {
        String string = this.myStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SvgPathData(string);
    }

    private final void addAction(SvgPathData.Action action, boolean absolute, double ... coordinates) {
        if (absolute) {
            this.myStringBuilder.append(action.absoluteCmd());
        } else {
            this.myStringBuilder.append(action.relativeCmd());
        }
        for (double coord : coordinates) {
            this.myStringBuilder.append(coord).append(' ');
        }
    }

    private final void addActionWithStringTokens(SvgPathData.Action action, boolean absolute, String ... tokens) {
        if (absolute) {
            this.myStringBuilder.append(action.absoluteCmd());
        } else {
            this.myStringBuilder.append(action.relativeCmd());
        }
        for (String token : tokens) {
            this.myStringBuilder.append(token).append(' ');
        }
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder moveTo(double x, double y, boolean absolute) {
        double[] dArray = new double[]{x, y};
        this.addAction(SvgPathData.Action.MOVE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder moveTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.moveTo(d, d2, bl);
    }

    @NotNull
    public final SvgPathDataBuilder moveTo(@NotNull DoubleVector point, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.moveTo(point.getX(), point.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder moveTo(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return SvgPathDataBuilder.moveTo$default(this, point.getX(), point.getY(), false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder lineTo(double x, double y, boolean absolute) {
        double[] dArray = new double[]{x, y};
        this.addAction(SvgPathData.Action.LINE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder lineTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.lineTo(d, d2, bl);
    }

    @NotNull
    public final SvgPathDataBuilder lineTo(@NotNull DoubleVector point, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.lineTo(point.getX(), point.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder lineTo(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return SvgPathDataBuilder.lineTo$default(this, point.getX(), point.getY(), false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder horizontalLineTo(double x, boolean absolute) {
        double[] dArray = new double[]{x};
        this.addAction(SvgPathData.Action.HORIZONTAL_LINE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder horizontalLineTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.horizontalLineTo(d, bl);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder verticalLineTo(double y, boolean absolute) {
        double[] dArray = new double[]{y};
        this.addAction(SvgPathData.Action.VERTICAL_LINE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder verticalLineTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.verticalLineTo(d, bl);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder curveTo(double x1, double y1, double x2, double y2, double x, double y, boolean absolute) {
        double[] dArray = new double[]{x1, y1, x2, y2, x, y};
        this.addAction(SvgPathData.Action.CURVE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder curveTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.curveTo(d, d2, d3, d4, d5, d6, bl);
    }

    @NotNull
    public final SvgPathDataBuilder curveTo(@NotNull DoubleVector controlStart, @NotNull DoubleVector controlEnd, @NotNull DoubleVector to, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)controlStart, (String)"controlStart");
        Intrinsics.checkNotNullParameter((Object)controlEnd, (String)"controlEnd");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.curveTo(controlStart.getX(), controlStart.getY(), controlEnd.getX(), controlEnd.getY(), to.getX(), to.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder curveTo(@NotNull DoubleVector controlStart, @NotNull DoubleVector controlEnd, @NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)controlStart, (String)"controlStart");
        Intrinsics.checkNotNullParameter((Object)controlEnd, (String)"controlEnd");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SvgPathDataBuilder.curveTo$default(this, controlStart.getX(), controlStart.getY(), controlEnd.getX(), controlEnd.getY(), to.getX(), to.getY(), false, 64, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder smoothCurveTo(double x2, double y2, double x, double y, boolean absolute) {
        double[] dArray = new double[]{x2, y2, x, y};
        this.addAction(SvgPathData.Action.SMOOTH_CURVE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder smoothCurveTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, double d3, double d4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.smoothCurveTo(d, d2, d3, d4, bl);
    }

    @NotNull
    public final SvgPathDataBuilder smoothCurveTo(@NotNull DoubleVector controlEnd, @NotNull DoubleVector to, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)controlEnd, (String)"controlEnd");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.smoothCurveTo(controlEnd.getX(), controlEnd.getY(), to.getX(), to.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder smoothCurveTo(@NotNull DoubleVector controlEnd, @NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)controlEnd, (String)"controlEnd");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SvgPathDataBuilder.smoothCurveTo$default(this, controlEnd.getX(), controlEnd.getY(), to.getX(), to.getY(), false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder quadraticBezierCurveTo(double x1, double y1, double x, double y, boolean absolute) {
        double[] dArray = new double[]{x1, y1, x, y};
        this.addAction(SvgPathData.Action.QUADRATIC_BEZIER_CURVE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder quadraticBezierCurveTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, double d3, double d4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.quadraticBezierCurveTo(d, d2, d3, d4, bl);
    }

    @NotNull
    public final SvgPathDataBuilder quadraticBezierCurveTo(@NotNull DoubleVector control, @NotNull DoubleVector to, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.quadraticBezierCurveTo(control.getX(), control.getY(), to.getX(), to.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder quadraticBezierCurveTo(@NotNull DoubleVector control, @NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SvgPathDataBuilder.quadraticBezierCurveTo$default(this, control.getX(), control.getY(), to.getX(), to.getY(), false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder smoothQuadraticBezierCurveTo(double x, double y, boolean absolute) {
        double[] dArray = new double[]{x, y};
        this.addAction(SvgPathData.Action.SMOOTH_QUADRATIC_BEZIER_CURVE_TO, absolute, dArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder smoothQuadraticBezierCurveTo$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.smoothQuadraticBezierCurveTo(d, d2, bl);
    }

    @NotNull
    public final SvgPathDataBuilder smoothQuadraticBezierCurveTo(@NotNull DoubleVector to, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.smoothQuadraticBezierCurveTo(to.getX(), to.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder smoothQuadraticBezierCurveTo(@NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SvgPathDataBuilder.smoothQuadraticBezierCurveTo$default(this, to.getX(), to.getY(), false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder ellipticalArc(double rx, double ry, double xAxisRotation, boolean largeArc, boolean sweep, double x, double y, boolean absolute) {
        String[] stringArray = new String[]{String.valueOf(rx), String.valueOf(ry), String.valueOf(xAxisRotation), largeArc ? "1" : "0", sweep ? "1" : "0", String.valueOf(x), String.valueOf(y)};
        this.addActionWithStringTokens(SvgPathData.Action.ELLIPTICAL_ARC, absolute, stringArray);
        return this;
    }

    public static /* synthetic */ SvgPathDataBuilder ellipticalArc$default(SvgPathDataBuilder svgPathDataBuilder, double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = svgPathDataBuilder.myDefaultAbsolute;
        }
        return svgPathDataBuilder.ellipticalArc(d, d2, d3, bl, bl2, d4, d5, bl3);
    }

    @NotNull
    public final SvgPathDataBuilder ellipticalArc(double rx, double ry, double xAxisRotation, boolean largeArc, boolean sweep, @NotNull DoubleVector to, boolean absolute) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.ellipticalArc(rx, ry, xAxisRotation, largeArc, sweep, to.getX(), to.getY(), absolute);
    }

    @NotNull
    public final SvgPathDataBuilder ellipticalArc(double rx, double ry, double xAxisRotation, boolean largeArc, boolean sweep, @NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return SvgPathDataBuilder.ellipticalArc$default(this, rx, ry, xAxisRotation, largeArc, sweep, to.getX(), to.getY(), false, 128, null);
    }

    @NotNull
    public final SvgPathDataBuilder closePath() {
        this.addAction(SvgPathData.Action.CLOSE_PATH, this.myDefaultAbsolute, new double[0]);
        return this;
    }

    public final void setTension(double tension) {
        if (0.0 > tension || tension > 1.0) {
            throw new IllegalArgumentException("Tension should be within [0, 1] interval");
        }
        this.myTension = tension;
    }

    private final List<Double> finiteDifferences(List<DoubleVector> points) {
        ArrayList<Double> result = new ArrayList<Double>(points.size());
        double curSlope = MathKt.lineSlope((DoubleVector)points.get(0), (DoubleVector)points.get(1));
        result.add(curSlope);
        int n = points.size() - 1;
        for (int i = 1; i < n; ++i) {
            double newSlope = MathKt.lineSlope((DoubleVector)points.get(i), (DoubleVector)points.get(i + 1));
            result.add((curSlope + newSlope) / (double)2);
            curSlope = newSlope;
        }
        result.add(curSlope);
        return result;
    }

    private final void doLinearInterpolation(Iterable<DoubleVector> points) {
        for (DoubleVector point : points) {
            SvgPathDataBuilder.lineTo$default(this, point.getX(), point.getY(), false, 4, null);
        }
    }

    private final void doCardinalInterpolation(List<DoubleVector> points, double tension) {
        this.doHermiteInterpolation(points, this.cardinalTangents(points, tension));
    }

    static /* synthetic */ void doCardinalInterpolation$default(SvgPathDataBuilder svgPathDataBuilder, List list, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = svgPathDataBuilder.myTension;
        }
        svgPathDataBuilder.doCardinalInterpolation(list, d);
    }

    private final void doHermiteInterpolation(List<DoubleVector> points, List<DoubleVector> tangents) {
        DoubleVector initTangent;
        if (tangents.size() < 1 || points.size() != tangents.size() && points.size() != tangents.size() + 2) {
            this.doLinearInterpolation((Iterable<DoubleVector>)points);
        }
        boolean quad = points.size() != tangents.size();
        DoubleVector initPoint = points.get(0);
        DoubleVector curPoint = points.get(1);
        DoubleVector curTangent = initTangent = tangents.get(0);
        int pointIndex = 1;
        if (quad) {
            this.quadraticBezierCurveTo(points.get(1).getX() - tangents.get(0).getX() * (double)2 / (double)3, curPoint.getY() - initTangent.getY() * (double)2 / (double)3, curPoint.getX(), curPoint.getY(), true);
            initPoint = points.get(1);
            pointIndex = 2;
        }
        if (tangents.size() > 1) {
            curTangent = tangents.get(1);
            curPoint = points.get(pointIndex);
            ++pointIndex;
            this.curveTo(initPoint.getX() + initTangent.getX(), initPoint.getY() + initTangent.getY(), curPoint.getX() - curTangent.getX(), curPoint.getY() - curTangent.getY(), curPoint.getX(), curPoint.getY(), true);
            int tangentIndex = 2;
            while (tangentIndex < tangents.size()) {
                curPoint = points.get(pointIndex);
                curTangent = tangents.get(tangentIndex);
                SvgPathDataBuilder.smoothCurveTo$default(this, curPoint.getX() - curTangent.getX(), curPoint.getY() - curTangent.getY(), curPoint.getX(), curPoint.getY(), false, 16, null);
                ++tangentIndex;
                ++pointIndex;
            }
        }
        if (quad) {
            DoubleVector lastPoint = points.get(pointIndex);
            this.quadraticBezierCurveTo(curPoint.getX() + curTangent.getX() * (double)2 / (double)3, curPoint.getY() + curTangent.getY() * (double)2 / (double)3, lastPoint.getX(), lastPoint.getY(), true);
        }
    }

    private final List<DoubleVector> cardinalTangents(List<DoubleVector> points, double tension) {
        ArrayList<DoubleVector> tangents = new ArrayList<DoubleVector>();
        double a = (1.0 - tension) / (double)2;
        DoubleVector prevPoint = null;
        DoubleVector curPoint = points.get(0);
        DoubleVector nextPoint = points.get(1);
        int n = points.size();
        for (int i = 2; i < n; ++i) {
            prevPoint = curPoint;
            curPoint = nextPoint;
            nextPoint = points.get(i);
            tangents.add(new DoubleVector(a * (nextPoint.getX() - prevPoint.getX()), a * (nextPoint.getY() - prevPoint.getY())));
        }
        return tangents;
    }

    private final List<DoubleVector> monotoneTangents(List<DoubleVector> points) {
        List<Double> m = this.finiteDifferences(points);
        double eps = 1.0E-7;
        int n = points.size() - 1;
        for (int i = 0; i < n; ++i) {
            double b;
            double slope = MathKt.lineSlope((DoubleVector)points.get(i), (DoubleVector)points.get(i + 1));
            if (Math.abs(slope) < eps) {
                m.set(i, 0.0);
                m.set(i + 1, 0.0);
                continue;
            }
            double a = ((Number)m.get(i)).doubleValue() / slope;
            double s = a * a + (b = ((Number)m.get(i + 1)).doubleValue() / slope) * b;
            if (!(s > 9.0)) continue;
            s = slope * (double)3 / Math.sqrt(s);
            m.set(i, s * a);
            m.set(i + 1, s * b);
        }
        ArrayList<DoubleVector> tangents = new ArrayList<DoubleVector>();
        int n2 = points.size();
        for (int i = 0; i < n2; ++i) {
            double slope = (points.get(Math.min(i + 1, points.size() - 1)).getX() - points.get(Math.max(i - 1, 0)).getX()) / ((double)6 * (1.0 + ((Number)m.get(i)).doubleValue() * ((Number)m.get(i)).doubleValue()));
            tangents.add(new DoubleVector(slope, ((Number)m.get(i)).doubleValue() * slope));
        }
        return tangents;
    }

    private final void doBasicInterpolation(List<DoubleVector> points) {
        Object[] objectArray = new Double[]{0.0, 0.6666666666666666, 0.3333333333333333, 0.0};
        List lineBasisBezier1 = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{0.0, 0.3333333333333333, 0.6666666666666666, 0.0};
        List lineBasisBezier2 = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new Double[]{0.0, 0.16666666666666666, 0.6666666666666666, 0.16666666666666666};
        List lineBasisBezier3 = CollectionsKt.listOf((Object[])objectArray3);
        Object[] objectArray4 = new Double[]{points.get(0).getX(), points.get(0).getX(), points.get(0).getX(), points.get(1).getX()};
        ArrayList px = CollectionsKt.arrayListOf((Object[])objectArray4);
        Object[] objectArray5 = new Double[]{points.get(0).getY(), points.get(0).getY(), points.get(0).getY(), points.get(1).getY()};
        ArrayList py = CollectionsKt.arrayListOf((Object[])objectArray5);
        SvgPathDataBuilder.lineTo$default(this, SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier3, px), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier3, py), false, 4, null);
        int i = 2;
        int n = points.size();
        if (i <= n) {
            while (true) {
                DoubleVector curPoint = i < points.size() ? points.get(i) : (DoubleVector)CollectionsKt.last(points);
                CollectionsKt.removeFirst((List)px);
                px.add(curPoint.getX());
                CollectionsKt.removeFirst((List)py);
                py.add(curPoint.getY());
                SvgPathDataBuilder.curveTo$default(this, SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier1, px), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier1, py), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier2, px), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier2, py), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier3, px), SvgPathDataBuilder.doBasicInterpolation$lineDot4(lineBasisBezier3, py), false, 64, null);
                if (i == n) break;
                ++i;
            }
        }
        this.lineTo((DoubleVector)CollectionsKt.last(points));
    }

    @NotNull
    public final SvgPathDataBuilder interpolatePoints(@NotNull Collection<Double> xs, @NotNull Collection<Double> ys, @NotNull Interpolation interpolation) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
        if (xs.size() != ys.size()) {
            throw new IllegalArgumentException("Sizes of xs and ys must be equal");
        }
        ArrayList<DoubleVector> points = new ArrayList<DoubleVector>(xs.size());
        ArrayList<Double> xsArray = new ArrayList<Double>(xs);
        ArrayList<Double> ysArray = new ArrayList<Double>(ys);
        int n = xs.size();
        for (int i = 0; i < n; ++i) {
            Double d = xsArray.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
            double d2 = ((Number)d).doubleValue();
            Double d3 = ysArray.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"get(...)");
            points.add(new DoubleVector(d2, ((Number)d3).doubleValue()));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[interpolation.ordinal()]) {
            case 1: {
                this.doLinearInterpolation((Iterable<DoubleVector>)points);
                break;
            }
            case 2: {
                if (points.size() < 3) {
                    this.doLinearInterpolation((Iterable<DoubleVector>)points);
                    break;
                }
                SvgPathDataBuilder.doCardinalInterpolation$default(this, points, 0.0, 2, null);
                break;
            }
            case 3: {
                if (points.size() < 3) {
                    this.doLinearInterpolation((Iterable<DoubleVector>)points);
                    break;
                }
                this.doHermiteInterpolation((List<DoubleVector>)points, this.monotoneTangents((List<DoubleVector>)points));
                break;
            }
            case 4: {
                if (points.size() < 3) {
                    this.doLinearInterpolation((Iterable<DoubleVector>)points);
                    break;
                }
                this.doBasicInterpolation((List<DoubleVector>)points);
            }
        }
        return this;
    }

    @NotNull
    public final SvgPathDataBuilder interpolatePoints(@NotNull Collection<DoubleVector> points, @NotNull Interpolation interpolation) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
        ArrayList<Double> xs = new ArrayList<Double>(points.size());
        ArrayList<Double> ys = new ArrayList<Double>(points.size());
        for (DoubleVector point : points) {
            xs.add(point.getX());
            ys.add(point.getY());
        }
        return this.interpolatePoints((Collection<Double>)xs, (Collection<Double>)ys, interpolation);
    }

    @JvmOverloads
    public SvgPathDataBuilder() {
        this(false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder moveTo(double x, double y) {
        return SvgPathDataBuilder.moveTo$default(this, x, y, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder lineTo(double x, double y) {
        return SvgPathDataBuilder.lineTo$default(this, x, y, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder horizontalLineTo(double x) {
        return SvgPathDataBuilder.horizontalLineTo$default(this, x, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder verticalLineTo(double y) {
        return SvgPathDataBuilder.verticalLineTo$default(this, y, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder curveTo(double x1, double y1, double x2, double y2, double x, double y) {
        return SvgPathDataBuilder.curveTo$default(this, x1, y1, x2, y2, x, y, false, 64, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder smoothCurveTo(double x2, double y2, double x, double y) {
        return SvgPathDataBuilder.smoothCurveTo$default(this, x2, y2, x, y, false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder quadraticBezierCurveTo(double x1, double y1, double x, double y) {
        return SvgPathDataBuilder.quadraticBezierCurveTo$default(this, x1, y1, x, y, false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder smoothQuadraticBezierCurveTo(double x, double y) {
        return SvgPathDataBuilder.smoothQuadraticBezierCurveTo$default(this, x, y, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SvgPathDataBuilder ellipticalArc(double rx, double ry, double xAxisRotation, boolean largeArc, boolean sweep, double x, double y) {
        return SvgPathDataBuilder.ellipticalArc$default(this, rx, ry, xAxisRotation, largeArc, sweep, x, y, false, 128, null);
    }

    private static final double doBasicInterpolation$lineDot4(List<Double> a, List<Double> b) {
        return ((Number)a.get(0)).doubleValue() * ((Number)b.get(0)).doubleValue() + ((Number)a.get(1)).doubleValue() * ((Number)b.get(1)).doubleValue() + ((Number)a.get(2)).doubleValue() * ((Number)b.get(2)).doubleValue() + ((Number)a.get(3)).doubleValue() * ((Number)b.get(3)).doubleValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder$Interpolation;", "", "(Ljava/lang/String;I)V", "LINEAR", "CARDINAL", "MONOTONE", "BSPLINE", "datamodel"})
    public static final class Interpolation
    extends Enum<Interpolation> {
        public static final /* enum */ Interpolation LINEAR = new Interpolation();
        public static final /* enum */ Interpolation CARDINAL = new Interpolation();
        public static final /* enum */ Interpolation MONOTONE = new Interpolation();
        public static final /* enum */ Interpolation BSPLINE = new Interpolation();
        private static final /* synthetic */ Interpolation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Interpolation[] values() {
            return (Interpolation[])$VALUES.clone();
        }

        public static Interpolation valueOf(String value) {
            return Enum.valueOf(Interpolation.class, value);
        }

        @NotNull
        public static EnumEntries<Interpolation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = interpolationArray = new Interpolation[]{Interpolation.LINEAR, Interpolation.CARDINAL, Interpolation.MONOTONE, Interpolation.BSPLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Interpolation.values().length];
            try {
                nArray[Interpolation.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Interpolation.CARDINAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Interpolation.MONOTONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Interpolation.BSPLINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

