/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.common.twkb;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.function.Function;
import org.jetbrains.letsPlot.commons.intern.function.Functions;
import org.jetbrains.letsPlot.commons.intern.gcommon.collect.Stack;
import org.jetbrains.letsPlot.commons.intern.spatial.SimpleFeature;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Ring;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Untyped;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.gis.common.twkb.InputBuffer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\t#$%&'()*+B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\u0011J\u001c\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017J\u001c\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\fH\u0002J\u001c\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017J\b\u0010\u001f\u001a\u00020\u000eH\u0002J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!H\u0000\u00a2\u0006\u0002\b\"R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "", "myPrecision", "", "myInputBuffer", "Lorg/jetbrains/letsPlot/gis/common/twkb/InputBuffer;", "myGeometryConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "(DLorg/jetbrains/letsPlot/gis/common/twkb/InputBuffer;Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;)V", "myParsers", "Lorg/jetbrains/letsPlot/commons/intern/gcommon/collect/Stack;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryParser;", "x", "", "y", "nextCoordinate", "", "nextCoordinate$gis", "parseLineString", "parseMultiLine", "n", "ids", "", "parseMultiPoint", "parsePoint", "parsePolygon", "parsingObject", "", "popParser", "pushMultiPolygon", "readCount", "readPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "readPoint$gis", "GeometryListParser", "GeometryParser", "MultiLineStringParser", "MultiPointParser", "MultiPolygonParser", "NestedGeometryParser", "PointParser", "PointsParser", "PolygonParser", "gis"})
public final class SimpleFeatureParser {
    private final double myPrecision;
    @NotNull
    private final InputBuffer myInputBuffer;
    @NotNull
    private final SimpleFeature.GeometryConsumer<Untyped> myGeometryConsumer;
    @NotNull
    private final Stack<GeometryParser> myParsers;
    private int x;
    private int y;

    public SimpleFeatureParser(double myPrecision, @NotNull InputBuffer myInputBuffer, @NotNull SimpleFeature.GeometryConsumer<Untyped> myGeometryConsumer) {
        Intrinsics.checkNotNullParameter((Object)myInputBuffer, (String)"myInputBuffer");
        Intrinsics.checkNotNullParameter(myGeometryConsumer, (String)"myGeometryConsumer");
        this.myPrecision = myPrecision;
        this.myInputBuffer = myInputBuffer;
        this.myGeometryConsumer = myGeometryConsumer;
        this.myParsers = new Stack();
    }

    @NotNull
    public final Vec<Untyped> readPoint$gis() {
        this.x += this.myInputBuffer.readVarInt();
        this.y += this.myInputBuffer.readVarInt();
        return VecKt.explicitVec((double)((double)this.x / this.myPrecision), (double)((double)this.y / this.myPrecision));
    }

    public final boolean parsingObject() {
        return !this.myParsers.empty();
    }

    public final void parsePoint() {
        this.myParsers.push((Object)new PointParser((Function1<? super Vec<Untyped>, Unit>)((Function1)new Function1<Vec<? extends Untyped>, Unit>(this.myGeometryConsumer){

            public final void invoke(@NotNull Vec<Untyped> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((SimpleFeature.GeometryConsumer)this.receiver).onPoint(p0);
            }
        }), this));
    }

    public final void parseLineString() {
        this.myParsers.push((Object)new PointsParser((Function1<? super List<Vec<Untyped>>, Unit>)((Function1)new Function1<List<? extends Vec<? extends Untyped>>, Unit>(this){
            final /* synthetic */ SimpleFeatureParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<Vec<Untyped>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0).onLineString(new LineString(it));
            }
        }), this));
    }

    public final void parsePolygon() {
        this.myParsers.push((Object)new PolygonParser((Function1<? super List<Ring<Untyped>>, Unit>)((Function1)new Function1<List<? extends Ring<Untyped>>, Unit>(this){
            final /* synthetic */ SimpleFeatureParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<Ring<Untyped>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0).onPolygon(new Polygon(it));
            }
        }), this));
    }

    public final void parseMultiPoint(int n, @NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.myParsers.push((Object)new MultiPointParser(n, (Function1<? super List<Vec<Untyped>>, Unit>)((Function1)new Function1<List<? extends Vec<? extends Untyped>>, Unit>(ids, this){
            final /* synthetic */ List<Integer> $ids;
            final /* synthetic */ SimpleFeatureParser this$0;
            {
                this.$ids = $ids;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<Vec<Untyped>> multiPoint) {
                Intrinsics.checkNotNullParameter(multiPoint, (String)"multiPoint");
                if (this.$ids.isEmpty()) {
                    SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0).onMultiPoint(new MultiPoint(multiPoint));
                } else {
                    void $this$forEach$iv;
                    Iterable iterable = multiPoint;
                    SimpleFeature.GeometryConsumer geometryConsumer = SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Vec p0 = (Vec)element$iv;
                        boolean bl = false;
                        geometryConsumer.onPoint(p0);
                    }
                }
            }
        }), this));
    }

    public final void parseMultiLine(int n, @NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.myParsers.push((Object)new MultiLineStringParser(n, (Function1<? super List<LineString<Untyped>>, Unit>)((Function1)new Function1<List<? extends LineString<Untyped>>, Unit>(ids, this){
            final /* synthetic */ List<Integer> $ids;
            final /* synthetic */ SimpleFeatureParser this$0;
            {
                this.$ids = $ids;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<LineString<Untyped>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.$ids.isEmpty()) {
                    SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0).onMultiLineString(new MultiLineString(it));
                } else {
                    void $this$forEach$iv;
                    Iterable iterable = it;
                    SimpleFeature.GeometryConsumer geometryConsumer = SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LineString p0 = (LineString)element$iv;
                        boolean bl = false;
                        geometryConsumer.onLineString(p0);
                    }
                }
            }
        }), this));
    }

    public final void pushMultiPolygon(int n, @NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.myParsers.push((Object)new MultiPolygonParser(n, (Function1<? super List<Polygon<Untyped>>, Unit>)((Function1)new Function1<List<? extends Polygon<Untyped>>, Unit>(ids, this){
            final /* synthetic */ List<Integer> $ids;
            final /* synthetic */ SimpleFeatureParser this$0;
            {
                this.$ids = $ids;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<Polygon<Untyped>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (this.$ids.isEmpty()) {
                    SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0).onMultiPolygon(new MultiPolygon(it));
                } else {
                    void $this$forEach$iv;
                    Iterable iterable = it;
                    SimpleFeature.GeometryConsumer geometryConsumer = SimpleFeatureParser.access$getMyGeometryConsumer$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Polygon p0 = (Polygon)element$iv;
                        boolean bl = false;
                        geometryConsumer.onPolygon(p0);
                    }
                }
            }
        }), this));
    }

    private final int readCount() {
        return this.myInputBuffer.readVarUInt();
    }

    public final void nextCoordinate$gis() {
        block0: {
            GeometryParser geometryParser = (GeometryParser)this.myParsers.peek();
            if (geometryParser == null) break block0;
            geometryParser.parseNext$gis();
        }
    }

    private final GeometryParser popParser() {
        GeometryParser geometryParser = (GeometryParser)this.myParsers.pop();
        if (geometryParser == null) {
            throw new IllegalStateException("No more parsers".toString());
        }
        return geometryParser;
    }

    public static final /* synthetic */ SimpleFeature.GeometryConsumer access$getMyGeometryConsumer$p(SimpleFeatureParser $this) {
        return $this.myGeometryConsumer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012(\u0010\u0005\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryListParser;", "GeometryT", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryParser;", "myCount", "", "myParsingResultConsumer", "Lkotlin/Function1;", "", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(ILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "myGeometries", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addGeometry", "geometry", "(Ljava/lang/Object;)V", "allRead", "", "done", "gis"})
    private static abstract class GeometryListParser<GeometryT>
    extends GeometryParser {
        private final int myCount;
        @NotNull
        private final Function1<List<? extends GeometryT>, Unit> myParsingResultConsumer;
        @NotNull
        private final ArrayList<GeometryT> myGeometries;

        public GeometryListParser(int myCount, @NotNull Function1<? super List<? extends GeometryT>, Unit> myParsingResultConsumer, @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(myParsingResultConsumer, (String)"myParsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(ctx);
            this.myCount = myCount;
            this.myParsingResultConsumer = myParsingResultConsumer;
            this.myGeometries = new ArrayList(this.myCount);
        }

        public final void addGeometry(GeometryT geometry) {
            this.myGeometries.add(geometry);
        }

        public final boolean allRead() {
            return this.myGeometries.size() == this.myCount;
        }

        public final void done() {
            this.popThisParser();
            this.myParsingResultConsumer.invoke(this.myGeometries);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0007J\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0000J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryParser;", "", "myCtx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "parseNext", "", "parseNext$gis", "popThisParser", "pushParser", "parser", "readPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "gis"})
    private static abstract class GeometryParser {
        @NotNull
        private final SimpleFeatureParser myCtx;

        public GeometryParser(@NotNull SimpleFeatureParser myCtx) {
            Intrinsics.checkNotNullParameter((Object)myCtx, (String)"myCtx");
            this.myCtx = myCtx;
        }

        public abstract void parseNext$gis();

        public final void popThisParser() {
            GeometryParser removed = this.myCtx.popParser();
            if (removed != this) {
                throw new IllegalStateException();
            }
        }

        @NotNull
        public final Vec<Untyped> readPoint() {
            return this.myCtx.readPoint$gis();
        }

        public final void pushParser(@NotNull GeometryParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            this.myCtx.myParsers.push((Object)parser);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002 \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0001BK\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00124\u0010\b\u001a0\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002\u0012\u0004\u0012\u00020\n0\tj\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$MultiLineStringParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$NestedGeometryParser;", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/LineString;", "nGeometries", "", "parsingResultConsumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(ILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "gis"})
    private static final class MultiLineStringParser
    extends NestedGeometryParser<List<? extends Vec<? extends Untyped>>, LineString<Untyped>> {
        public MultiLineStringParser(int nGeometries, @NotNull Function1<? super List<LineString<Untyped>>, Unit> parsingResultConsumer, final @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(nGeometries, Functions.INSTANCE.funcOf((Function1)new Function1<Function1<? super List<? extends Vec<? extends Untyped>>, ? extends Unit>, GeometryParser>(){

                @NotNull
                public final GeometryParser invoke(@NotNull Function1<? super List<Vec<Untyped>>, Unit> points) {
                    Intrinsics.checkNotNullParameter(points, (String)"points");
                    return new PointsParser(points, ctx);
                }
            }), Functions.INSTANCE.funcOf((Function1)2.INSTANCE), parsingResultConsumer, ctx);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001BK\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00124\u0010\u0006\u001a0\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\b`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$MultiPointParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$NestedGeometryParser;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "nGeometries", "", "parsingResultConsumer", "Lkotlin/Function1;", "", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(ILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "gis"})
    private static final class MultiPointParser
    extends NestedGeometryParser<Vec<? extends Untyped>, Vec<? extends Untyped>> {
        public MultiPointParser(int nGeometries, @NotNull Function1<? super List<Vec<Untyped>>, Unit> parsingResultConsumer, final @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(nGeometries, Functions.INSTANCE.funcOf((Function1)new Function1<Function1<? super Vec<? extends Untyped>, ? extends Unit>, GeometryParser>(){

                @NotNull
                public final GeometryParser invoke(@NotNull Function1<? super Vec<Untyped>, Unit> point) {
                    Intrinsics.checkNotNullParameter(point, (String)"point");
                    return new PointParser(point, ctx);
                }
            }), Functions.INSTANCE.funcOf(Functions.INSTANCE.identity()), parsingResultConsumer, ctx);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002 \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0001BK\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00124\u0010\b\u001a0\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002\u0012\u0004\u0012\u00020\n0\tj\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$MultiPolygonParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$NestedGeometryParser;", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Ring;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Polygon;", "nGeometries", "", "parsingResultConsumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(ILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "gis"})
    private static final class MultiPolygonParser
    extends NestedGeometryParser<List<? extends Ring<Untyped>>, Polygon<Untyped>> {
        public MultiPolygonParser(int nGeometries, @NotNull Function1<? super List<Polygon<Untyped>>, Unit> parsingResultConsumer, final @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(nGeometries, Functions.INSTANCE.funcOf((Function1)new Function1<Function1<? super List<? extends Ring<Untyped>>, ? extends Unit>, GeometryParser>(){

                @NotNull
                public final GeometryParser invoke(@NotNull Function1<? super List<Ring<Untyped>>, Unit> ringsConsumer) {
                    Intrinsics.checkNotNullParameter(ringsConsumer, (String)"ringsConsumer");
                    return new PolygonParser(ringsConsumer, ctx);
                }
            }), Functions.INSTANCE.funcOf((Function1)2.INSTANCE), parsingResultConsumer, ctx);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B}\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012(\u0010\u0006\u001a$\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012(\u0010\r\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e`\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0016R0\u0010\u0006\u001a$\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00028\u0000`\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$NestedGeometryParser;", "NestedGeometriesT", "GeometryT", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryListParser;", "count", "", "myNestedParserFactory", "Lorg/jetbrains/letsPlot/commons/intern/function/Function;", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryParser;", "myNestedToGeometry", "parsingResultConsumer", "", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(ILorg/jetbrains/letsPlot/commons/intern/function/Function;Lorg/jetbrains/letsPlot/commons/intern/function/Function;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "onNestedParsed", "nestedGeometries", "(Ljava/lang/Object;)V", "parseNext", "parseNext$gis", "gis"})
    private static class NestedGeometryParser<NestedGeometriesT, GeometryT>
    extends GeometryListParser<GeometryT> {
        @NotNull
        private final Function<Function1<NestedGeometriesT, Unit>, GeometryParser> myNestedParserFactory;
        @NotNull
        private final Function<NestedGeometriesT, GeometryT> myNestedToGeometry;

        public NestedGeometryParser(int count, @NotNull Function<Function1<NestedGeometriesT, Unit>, GeometryParser> myNestedParserFactory, @NotNull Function<NestedGeometriesT, GeometryT> myNestedToGeometry, @NotNull Function1<? super List<? extends GeometryT>, Unit> parsingResultConsumer, @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(myNestedParserFactory, (String)"myNestedParserFactory");
            Intrinsics.checkNotNullParameter(myNestedToGeometry, (String)"myNestedToGeometry");
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(count, parsingResultConsumer, ctx);
            this.myNestedParserFactory = myNestedParserFactory;
            this.myNestedToGeometry = myNestedToGeometry;
        }

        @Override
        public void parseNext$gis() {
            this.pushParser((GeometryParser)this.myNestedParserFactory.apply((Object)new Function1<NestedGeometriesT, Unit>(this){

                public final void invoke(NestedGeometriesT p0) {
                    NestedGeometryParser.access$onNestedParsed((NestedGeometryParser)this.receiver, p0);
                }
            }));
        }

        private final void onNestedParsed(NestedGeometriesT nestedGeometries) {
            this.addGeometry(this.myNestedToGeometry.apply(nestedGeometries));
            if (this.allRead()) {
                this.done();
            }
        }

        public static final /* synthetic */ void access$onNestedParsed(NestedGeometryParser $this, Object nestedGeometries) {
            $this.onNestedParsed(nestedGeometries);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B7\u0012(\u0010\u0002\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\f\u001a\u00020\u0006H\u0002J\r\u0010\r\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R0\u0010\u0002\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$PointParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryParser;", "myParsingResultConsumer", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "myP", "done", "parseNext", "parseNext$gis", "gis"})
    private static final class PointParser
    extends GeometryParser {
        @NotNull
        private final Function1<Vec<Untyped>, Unit> myParsingResultConsumer;
        private Vec<Untyped> myP;

        public PointParser(@NotNull Function1<? super Vec<Untyped>, Unit> myParsingResultConsumer, @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(myParsingResultConsumer, (String)"myParsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(ctx);
            this.myParsingResultConsumer = myParsingResultConsumer;
        }

        @Override
        public void parseNext$gis() {
            this.myP = this.readPoint();
            this.done();
        }

        private final void done() {
            this.popThisParser();
            Vec<Untyped> vec = this.myP;
            if (vec == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myP");
                vec = null;
            }
            this.myParsingResultConsumer.invoke(vec);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001BC\u00124\u0010\u0004\u001a0\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0006`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$PointsParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$GeometryListParser;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "parsingResultConsumer", "Lkotlin/Function1;", "", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "parseNext", "parseNext$gis", "gis"})
    private static final class PointsParser
    extends GeometryListParser<Vec<? extends Untyped>> {
        public PointsParser(@NotNull Function1<? super List<Vec<Untyped>>, Unit> parsingResultConsumer, @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(ctx.readCount(), parsingResultConsumer, ctx);
        }

        @Override
        public void parseNext$gis() {
            this.addGeometry(this.readPoint());
            if (this.allRead()) {
                this.done();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002 \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0001BC\u00124\u0010\u0006\u001a0\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002\u0012\u0004\u0012\u00020\b0\u0007j\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$PolygonParser;", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser$NestedGeometryParser;", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Ring;", "parsingResultConsumer", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/commons/intern/function/Consumer;", "ctx", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;)V", "gis"})
    private static final class PolygonParser
    extends NestedGeometryParser<List<? extends Vec<? extends Untyped>>, Ring<Untyped>> {
        public PolygonParser(@NotNull Function1<? super List<Ring<Untyped>>, Unit> parsingResultConsumer, final @NotNull SimpleFeatureParser ctx) {
            Intrinsics.checkNotNullParameter(parsingResultConsumer, (String)"parsingResultConsumer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(ctx.readCount(), Functions.INSTANCE.funcOf((Function1)new Function1<Function1<? super List<? extends Vec<? extends Untyped>>, ? extends Unit>, GeometryParser>(){

                @NotNull
                public final GeometryParser invoke(@NotNull Function1<? super List<Vec<Untyped>>, Unit> points) {
                    Intrinsics.checkNotNullParameter(points, (String)"points");
                    return new PointsParser(points, ctx);
                }
            }), Functions.INSTANCE.funcOf((Function1)2.INSTANCE), parsingResultConsumer, ctx);
        }
    }
}

