/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.common.twkb;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.SimpleFeature;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Untyped;
import org.jetbrains.letsPlot.gis.common.twkb.InputBuffer;
import org.jetbrains.letsPlot.gis.common.twkb.SimpleFeatureParser;
import org.jetbrains.letsPlot.gis.common.twkb.VarInt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb;", "", "()V", "META_BBOX_BIT", "", "META_EMPTY_GEOMETRY_BIT", "META_EXTRA_PRECISION_BIT", "META_ID_LIST_BIT", "META_SIZE_BIT", "parse", "", "data", "", "geometryConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "parser", "Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser;", "Parser", "gis"})
public final class Twkb {
    @NotNull
    public static final Twkb INSTANCE = new Twkb();
    private static final int META_ID_LIST_BIT = 2;
    private static final int META_EMPTY_GEOMETRY_BIT = 4;
    private static final int META_BBOX_BIT = 0;
    private static final int META_SIZE_BIT = 1;
    private static final int META_EXTRA_PRECISION_BIT = 3;

    private Twkb() {
    }

    public final void parse(@NotNull byte[] data, @NotNull SimpleFeature.GeometryConsumer<Untyped> geometryConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(geometryConsumer, (String)"geometryConsumer");
        Parser parser = new Parser(data, geometryConsumer);
        while (parser.next()) {
        }
    }

    @NotNull
    public final Parser parser(@NotNull byte[] data, @NotNull SimpleFeature.GeometryConsumer<Untyped> geometryConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(geometryConsumer, (String)"geometryConsumer");
        return new Parser(data, geometryConsumer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001dB\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\t\u0010\u0010\u001a\u00020\u0011H\u0082\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\t\u0010\u0018\u001a\u00020\u0011H\u0086\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001cR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser;", "", "data", "", "myGeometryConsumer", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "([BLorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;)V", "myFeatureParser", "Lorg/jetbrains/letsPlot/gis/common/twkb/SimpleFeatureParser;", "myInputBuffer", "Lorg/jetbrains/letsPlot/gis/common/twkb/InputBuffer;", "assertNoMeta", "", "meta", "", "hasNext", "", "isMulti", "type", "Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser$GeometryType;", "isSet", "b", "bit", "next", "precision", "typeAndPrec", "startGeometryParsing", "type$gis", "GeometryType", "gis"})
    public static final class Parser {
        @NotNull
        private final SimpleFeature.GeometryConsumer<Untyped> myGeometryConsumer;
        @NotNull
        private final InputBuffer myInputBuffer;
        @Nullable
        private SimpleFeatureParser myFeatureParser;

        public Parser(@NotNull byte[] data, @NotNull SimpleFeature.GeometryConsumer<Untyped> myGeometryConsumer) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(myGeometryConsumer, (String)"myGeometryConsumer");
            this.myGeometryConsumer = myGeometryConsumer;
            this.myInputBuffer = new InputBuffer(data);
        }

        private final boolean hasNext() {
            return this.myInputBuffer.hasNext();
        }

        public final boolean next() {
            block6: {
                block5: {
                    if (!this.hasNext()) {
                        return false;
                    }
                    if (this.myFeatureParser == null) break block5;
                    SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                    Intrinsics.checkNotNull((Object)simpleFeatureParser);
                    if (simpleFeatureParser.parsingObject()) break block6;
                }
                if (!this.startGeometryParsing()) {
                    return false;
                }
            }
            SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
            Intrinsics.checkNotNull((Object)simpleFeatureParser);
            simpleFeatureParser.nextCoordinate$gis();
            return true;
        }

        private final boolean startGeometryParsing() {
            while (this.hasNext()) {
                GeometryType geometryType = null;
                boolean isEmpty = false;
                double precision = 0.0;
                int nGeometries = 0;
                ArrayList<Integer> idList = null;
                idList = new ArrayList<Integer>();
                Parser $this$startGeometryParsing_u24lambda_u240 = this;
                boolean bl = false;
                int typeAndPrecision = $this$startGeometryParsing_u24lambda_u240.myInputBuffer.readByte();
                geometryType = $this$startGeometryParsing_u24lambda_u240.type$gis(typeAndPrecision);
                precision = Math.pow(10.0, $this$startGeometryParsing_u24lambda_u240.precision(typeAndPrecision));
                int meta = $this$startGeometryParsing_u24lambda_u240.myInputBuffer.readByte();
                isEmpty = $this$startGeometryParsing_u24lambda_u240.isSet(meta, 4);
                if (!isEmpty && $this$startGeometryParsing_u24lambda_u240.isMulti($this$startGeometryParsing_u24lambda_u240.type$gis(typeAndPrecision))) {
                    nGeometries = $this$startGeometryParsing_u24lambda_u240.myInputBuffer.readVarUInt();
                    if ($this$startGeometryParsing_u24lambda_u240.isSet(meta, 2)) {
                        idList = new ArrayList(nGeometries);
                        int n = nGeometries;
                        for (int i = 0; i < n; ++i) {
                            idList.add($this$startGeometryParsing_u24lambda_u240.myInputBuffer.readVarInt());
                        }
                    }
                }
                $this$startGeometryParsing_u24lambda_u240.assertNoMeta(meta);
                if (isEmpty) continue;
                this.myFeatureParser = new SimpleFeatureParser(precision, this.myInputBuffer, this.myGeometryConsumer);
                switch (WhenMappings.$EnumSwitchMapping$0[geometryType.ordinal()]) {
                    case 1: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.parsePoint();
                        return true;
                    }
                    case 2: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.parseLineString();
                        return true;
                    }
                    case 3: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.parsePolygon();
                        return true;
                    }
                    case 4: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.parseMultiPoint(nGeometries, (List<Integer>)idList);
                        return true;
                    }
                    case 5: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.parseMultiLine(nGeometries, (List<Integer>)idList);
                        return true;
                    }
                    case 6: {
                        SimpleFeatureParser simpleFeatureParser = this.myFeatureParser;
                        Intrinsics.checkNotNull((Object)simpleFeatureParser);
                        simpleFeatureParser.pushMultiPolygon(nGeometries, (List<Integer>)idList);
                        return true;
                    }
                }
            }
            return false;
        }

        private final boolean isSet(int b, int bit) {
            return (b & 1 << bit) != 0;
        }

        private final boolean isMulti(GeometryType type) {
            return type == GeometryType.MULTI_POINT || type == GeometryType.MULTI_LINESTRING || type == GeometryType.MULTI_POLYGON || type == GeometryType.GEOMETRY_COLLECTION;
        }

        private final int precision(int typeAndPrec) {
            return VarInt.INSTANCE.decodeZigZag$gis((typeAndPrec & 0xF0) >> 4);
        }

        @NotNull
        public final GeometryType type$gis(int typeAndPrec) {
            return GeometryType.Companion.fromCode$gis(typeAndPrec & 0xF);
        }

        private final void assertNoMeta(int meta) {
            if (this.isSet(meta, 3)) {
                throw new IllegalStateException("META_EXTRA_PRECISION_BIT is not supported");
            }
            if (this.isSet(meta, 1)) {
                throw new IllegalStateException("META_SIZE_BIT is not supported");
            }
            if (this.isSet(meta, 0)) {
                throw new IllegalStateException("META_BBOX_BIT is not supported");
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser$GeometryType;", "", "(Ljava/lang/String;I)V", "POINT", "LINESTRING", "POLYGON", "MULTI_POINT", "MULTI_LINESTRING", "MULTI_POLYGON", "GEOMETRY_COLLECTION", "Companion", "gis"})
        public static final class GeometryType
        extends Enum<GeometryType> {
            @NotNull
            public static final Companion Companion;
            public static final /* enum */ GeometryType POINT;
            public static final /* enum */ GeometryType LINESTRING;
            public static final /* enum */ GeometryType POLYGON;
            public static final /* enum */ GeometryType MULTI_POINT;
            public static final /* enum */ GeometryType MULTI_LINESTRING;
            public static final /* enum */ GeometryType MULTI_POLYGON;
            public static final /* enum */ GeometryType GEOMETRY_COLLECTION;
            private static final /* synthetic */ GeometryType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static GeometryType[] values() {
                return (GeometryType[])$VALUES.clone();
            }

            public static GeometryType valueOf(String value) {
                return Enum.valueOf(GeometryType.class, value);
            }

            @NotNull
            public static EnumEntries<GeometryType> getEntries() {
                return $ENTRIES;
            }

            static {
                POINT = new GeometryType();
                LINESTRING = new GeometryType();
                POLYGON = new GeometryType();
                MULTI_POINT = new GeometryType();
                MULTI_LINESTRING = new GeometryType();
                MULTI_POLYGON = new GeometryType();
                GEOMETRY_COLLECTION = new GeometryType();
                $VALUES = geometryTypeArray = new GeometryType[]{GeometryType.POINT, GeometryType.LINESTRING, GeometryType.POLYGON, GeometryType.MULTI_POINT, GeometryType.MULTI_LINESTRING, GeometryType.MULTI_POLYGON, GeometryType.GEOMETRY_COLLECTION};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser$GeometryType$Companion;", "", "()V", "fromCode", "Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser$GeometryType;", "code", "", "fromCode$gis", "gis"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final GeometryType fromCode$gis(int code) {
                    switch (code) {
                        case 1: {
                            return POINT;
                        }
                        case 2: {
                            return LINESTRING;
                        }
                        case 3: {
                            return POLYGON;
                        }
                        case 4: {
                            return MULTI_POINT;
                        }
                        case 5: {
                            return MULTI_LINESTRING;
                        }
                        case 6: {
                            return MULTI_POLYGON;
                        }
                        case 7: {
                            return GEOMETRY_COLLECTION;
                        }
                    }
                    throw new IllegalArgumentException("Unkown geometry type: " + code);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GeometryType.values().length];
                try {
                    nArray[GeometryType.POINT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.LINESTRING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.POLYGON.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.MULTI_POINT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.MULTI_LINESTRING.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.MULTI_POLYGON.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeometryType.GEOMETRY_COLLECTION.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

