/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.geoprotocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.encoding.Base64;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoJson;
import org.jetbrains.letsPlot.commons.intern.spatial.SimpleFeature;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Untyped;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.gis.common.twkb.Twkb;
import org.jetbrains.letsPlot.gis.geoprotocol.Boundary;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010\t\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries;", "", "()V", "fromGeoJson", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundary;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "boundary", "", "fromTwkb", "getRawData", "getRawData$gis", "GeoJsonBoundary", "StringBoundary", "TinyBoundary", "gis"})
public final class Boundaries {
    @NotNull
    public static final Boundaries INSTANCE = new Boundaries();

    private Boundaries() {
    }

    @NotNull
    public final Boundary<Untyped> fromTwkb(@NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        return new TinyBoundary(boundary);
    }

    @NotNull
    public final Boundary<Untyped> fromGeoJson(@NotNull String boundary) {
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        return new GeoJsonBoundary(boundary);
    }

    @NotNull
    public final String getRawData$gis(@NotNull Boundary<Untyped> boundary) {
        Intrinsics.checkNotNullParameter(boundary, (String)"boundary");
        return ((StringBoundary)boundary).getRawData$gis();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries$GeoJsonBoundary;", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries$StringBoundary;", "boundary", "", "(Ljava/lang/String;)V", "parse", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "parse$gis", "gis"})
    private static final class GeoJsonBoundary
    extends StringBoundary {
        public GeoJsonBoundary(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            super(boundary);
        }

        @Override
        @NotNull
        public MultiPolygon<Untyped> parse$gis(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            Ref.ObjectRef boundaryPolygon = new Ref.ObjectRef();
            GeoJson.INSTANCE.parse(boundary, (Function1)new Function1<SimpleFeature.Consumer<Untyped>, Unit>((Ref.ObjectRef<MultiPolygon<Untyped>>)boundaryPolygon){
                final /* synthetic */ Ref.ObjectRef<MultiPolygon<Untyped>> $boundaryPolygon;
                {
                    this.$boundaryPolygon = $boundaryPolygon;
                    super(1);
                }

                public final void invoke(@NotNull SimpleFeature.Consumer<Untyped> $this$parse) {
                    Intrinsics.checkNotNullParameter($this$parse, (String)"$this$parse");
                    $this$parse.setOnPolygon((Function1)new Function1<Polygon<Untyped>, Unit>(this.$boundaryPolygon){
                        final /* synthetic */ Ref.ObjectRef<MultiPolygon<Untyped>> $boundaryPolygon;
                        {
                            this.$boundaryPolygon = $boundaryPolygon;
                            super(1);
                        }

                        public final void invoke(@NotNull Polygon<Untyped> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            if (!(this.$boundaryPolygon.element == null)) {
                                String string = "Failed requirement.";
                                throw new IllegalArgumentException(string.toString());
                            }
                            this.$boundaryPolygon.element = new MultiPolygon(CollectionsKt.listOf(it));
                        }
                    });
                    $this$parse.setOnMultiPolygon((Function1)new Function1<MultiPolygon<Untyped>, Unit>(this.$boundaryPolygon){
                        final /* synthetic */ Ref.ObjectRef<MultiPolygon<Untyped>> $boundaryPolygon;
                        {
                            this.$boundaryPolygon = $boundaryPolygon;
                            super(1);
                        }

                        public final void invoke(@NotNull MultiPolygon<Untyped> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            if (!(this.$boundaryPolygon.element == null)) {
                                String string = "Failed requirement.";
                                throw new IllegalArgumentException(string.toString());
                            }
                            this.$boundaryPolygon.element = it;
                        }
                    });
                }
            });
            MultiPolygon multiPolygon = (MultiPolygon)boundaryPolygon.element;
            if (multiPolygon == null) {
                multiPolygon = new MultiPolygon(CollectionsKt.emptyList());
            }
            return multiPolygon;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u0017R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries$StringBoundary;", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundary;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "rawData", "", "(Ljava/lang/String;)V", "myMultipolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "getMyMultipolygon", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "myMultipolygon$delegate", "Lkotlin/Lazy;", "getRawData$gis", "()Ljava/lang/String;", "asMultipolygon", "equals", "", "other", "", "hashCode", "", "parse", "boundary", "parse$gis", "gis"})
    private static abstract class StringBoundary
    implements Boundary<Untyped> {
        @NotNull
        private final String rawData;
        @NotNull
        private final Lazy myMultipolygon$delegate;

        public StringBoundary(@NotNull String rawData) {
            Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
            this.rawData = rawData;
            this.myMultipolygon$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MultiPolygon<Untyped>>(this){
                final /* synthetic */ StringBoundary this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MultiPolygon<Untyped> invoke() {
                    return this.this$0.parse$gis(this.this$0.getRawData$gis());
                }
            }));
        }

        @NotNull
        public final String getRawData$gis() {
            return this.rawData;
        }

        private final MultiPolygon<Untyped> getMyMultipolygon() {
            Lazy lazy = this.myMultipolygon$delegate;
            return (MultiPolygon)lazy.getValue();
        }

        @Override
        @NotNull
        public MultiPolygon<Untyped> asMultipolygon() {
            return this.getMyMultipolygon();
        }

        @NotNull
        public abstract MultiPolygon<Untyped> parse$gis(@NotNull String var1);

        public int hashCode() {
            return this.rawData.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            StringBoundary cfr_ignored_0 = (StringBoundary)other;
            return Intrinsics.areEqual((Object)this.rawData, (Object)((StringBoundary)other).rawData);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries$TinyBoundary;", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundaries$StringBoundary;", "boundary", "", "(Ljava/lang/String;)V", "parse", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "parse$gis", "gis"})
    private static final class TinyBoundary
    extends StringBoundary {
        public TinyBoundary(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            super(boundary);
        }

        @Override
        @NotNull
        public MultiPolygon<Untyped> parse$gis(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            ArrayList<Polygon<Untyped>> polygons = new ArrayList<Polygon<Untyped>>();
            Twkb.INSTANCE.parse(Base64.INSTANCE.decode(boundary), (SimpleFeature.GeometryConsumer<Untyped>)((SimpleFeature.GeometryConsumer)new SimpleFeature.GeometryConsumer<Untyped>(polygons){
                final /* synthetic */ ArrayList<Polygon<Untyped>> $polygons;
                {
                    this.$polygons = $polygons;
                }

                public void onPolygon(@NotNull Polygon<Untyped> polygon) {
                    Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
                    this.$polygons.add(polygon);
                }

                public void onMultiPolygon(@NotNull MultiPolygon<Untyped> multipolygon) {
                    Intrinsics.checkNotNullParameter(multipolygon, (String)"multipolygon");
                    this.$polygons.addAll((Collection)multipolygon);
                }

                public void onLineString(@NotNull LineString<Untyped> lineString) {
                    SimpleFeature.GeometryConsumer.DefaultImpls.onLineString((SimpleFeature.GeometryConsumer)this, lineString);
                }

                public void onMultiLineString(@NotNull MultiLineString<Untyped> multiLineString) {
                    SimpleFeature.GeometryConsumer.DefaultImpls.onMultiLineString((SimpleFeature.GeometryConsumer)this, multiLineString);
                }

                public void onMultiPoint(@NotNull MultiPoint<Untyped> multiPoint) {
                    SimpleFeature.GeometryConsumer.DefaultImpls.onMultiPoint((SimpleFeature.GeometryConsumer)this, multiPoint);
                }

                public void onPoint(@NotNull Vec<Untyped> point) {
                    SimpleFeature.GeometryConsumer.DefaultImpls.onPoint((SimpleFeature.GeometryConsumer)this, point);
                }
            }));
            return new MultiPolygon((List)polygons);
        }
    }
}

