/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.geoprotocol.json;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.json.FluentObject;
import org.jetbrains.letsPlot.commons.intern.json.UtilsKt;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/json/ProtocolJsonHelper;", "", "()V", "MAX_LAT", "", "MAX_LON", "MIN_LAT", "MIN_LON", "formatGeoRectangle", "Lorg/jetbrains/letsPlot/commons/intern/json/FluentObject;", "rect", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "parseGeoRectangle", "obj", "", "Lorg/jetbrains/letsPlot/commons/intern/json/Obj;", "gis"})
public final class ProtocolJsonHelper {
    @NotNull
    public static final ProtocolJsonHelper INSTANCE = new ProtocolJsonHelper();
    @NotNull
    private static final String MIN_LON = "min_lon";
    @NotNull
    private static final String MIN_LAT = "min_lat";
    @NotNull
    private static final String MAX_LON = "max_lon";
    @NotNull
    private static final String MAX_LAT = "max_lat";

    private ProtocolJsonHelper() {
    }

    @NotNull
    public final GeoRectangle parseGeoRectangle(@NotNull Map<?, ?> obj) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        return new GeoRectangle(UtilsKt.getDouble(obj, (String)MIN_LON), UtilsKt.getDouble(obj, (String)MIN_LAT), UtilsKt.getDouble(obj, (String)MAX_LON), UtilsKt.getDouble(obj, (String)MAX_LAT));
    }

    @NotNull
    public final FluentObject formatGeoRectangle(@NotNull GeoRectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new FluentObject().put(MIN_LON, (Number)rect.startLongitude()).put(MIN_LAT, (Number)rect.minLatitude()).put(MAX_LAT, (Number)rect.maxLatitude()).put(MAX_LON, (Number)rect.endLongitude());
    }
}

