/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.geoprotocol.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.FluentObject;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Untyped;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.gis.geoprotocol.Boundaries;
import org.jetbrains.letsPlot.gis.geoprotocol.Boundary;
import org.jetbrains.letsPlot.gis.geoprotocol.FeatureLevel;
import org.jetbrains.letsPlot.gis.geoprotocol.Fragment;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoResponse;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoResponseBuilder;
import org.jetbrains.letsPlot.gis.geoprotocol.json.ProtocolJsonHelper;
import org.jetbrains.letsPlot.gis.geoprotocol.json.ResponseStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nj\u0002`\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/gis/geoprotocol/json/ResponseJsonParser;", "", "()V", "ambiguous", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeoResponse;", "responseJson", "Lorg/jetbrains/letsPlot/commons/intern/json/FluentObject;", "error", "parse", "json", "", "Lorg/jetbrains/letsPlot/commons/intern/json/Obj;", "parseCentroid", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "centroid", "parseGeoParent", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeoResponse$SuccessGeoResponse$GeoParent;", "parent", "parseGeoRectangle", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "data", "readBoundary", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Boundary;", "boundary", "", "readGeometry", "geoJson", "success", "gis"})
public final class ResponseJsonParser {
    @NotNull
    public static final ResponseJsonParser INSTANCE = new ResponseJsonParser();

    private ResponseJsonParser() {
    }

    @NotNull
    public final GeoResponse parse(@NotNull Map<?, ?> json) {
        GeoResponse geoResponse;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        FluentObject responseJson = new FluentObject(json);
        switch (WhenMappings.$EnumSwitchMapping$0[((ResponseStatus)responseJson.getEnum("status", (Enum[])ResponseStatus.values())).ordinal()]) {
            case 1: {
                geoResponse = this.success(responseJson);
                break;
            }
            case 2: {
                geoResponse = this.ambiguous(responseJson);
                break;
            }
            case 3: {
                geoResponse = this.error(responseJson);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return geoResponse;
    }

    private final GeoResponse success(FluentObject responseJson) {
        GeoResponseBuilder.SuccessResponseBuilder successResponse = new GeoResponseBuilder.SuccessResponseBuilder();
        responseJson.getObject("data", (Function1)new Function1<FluentObject, Unit>(successResponse){
            final /* synthetic */ GeoResponseBuilder.SuccessResponseBuilder $successResponse;
            {
                this.$successResponse = $successResponse;
                super(1);
            }

            public final void invoke(@NotNull FluentObject data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getOptionalEnum("level", (Function1)new Function1<FeatureLevel, Unit>((Object)this.$successResponse){

                    public final void invoke(@Nullable FeatureLevel p0) {
                        ((GeoResponseBuilder.SuccessResponseBuilder)this.receiver).setLevel(p0);
                    }
                }, (Enum[])FeatureLevel.values()).forObjects("answers", (Function1)new Function1<FluentObject, Unit>(this.$successResponse){
                    final /* synthetic */ GeoResponseBuilder.SuccessResponseBuilder $successResponse;
                    {
                        this.$successResponse = $successResponse;
                        super(1);
                    }

                    public final void invoke(@NotNull FluentObject answerJson) {
                        Intrinsics.checkNotNullParameter((Object)answerJson, (String)"answerJson");
                        GeoResponseBuilder.GeocodingAnswerBuilder answer = new GeoResponseBuilder.GeocodingAnswerBuilder();
                        answerJson.forObjects("features", (Function1)new Function1<FluentObject, Unit>(answer){
                            final /* synthetic */ GeoResponseBuilder.GeocodingAnswerBuilder $answer;
                            {
                                this.$answer = $answer;
                                super(1);
                            }

                            public final void invoke(@NotNull FluentObject featureJson) {
                                Intrinsics.checkNotNullParameter((Object)featureJson, (String)"featureJson");
                                GeoResponseBuilder.GeocodedFeatureBuilder feature = new GeoResponseBuilder.GeocodedFeatureBuilder();
                                featureJson.getString("id", (Function1)new Function1<String, Unit>((Object)feature){

                                    public final void invoke(@NotNull String p0) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        ((GeoResponseBuilder.GeocodedFeatureBuilder)this.receiver).setId(p0);
                                    }
                                }).getString("name", (Function1)new Function1<String, Unit>((Object)feature){

                                    public final void invoke(@NotNull String p0) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        ((GeoResponseBuilder.GeocodedFeatureBuilder)this.receiver).setName(p0);
                                    }
                                }).forExistingStrings("highlights", (Function1)new Function1<String, Unit>((Object)feature){

                                    public final void invoke(@NotNull String p0) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        ((GeoResponseBuilder.GeocodedFeatureBuilder)this.receiver).addHighlight(p0);
                                    }
                                }).getExistingString("boundary", (Function1)new Function1<String, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$feature.setBoundary(ResponseJsonParser.access$readGeometry(ResponseJsonParser.INSTANCE, it));
                                    }
                                }).forObjects("parents", (Function1)new Function1<FluentObject, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$feature.addParent(ResponseJsonParser.access$parseGeoParent(ResponseJsonParser.INSTANCE, it));
                                    }
                                }).getExistingObject("centroid", (Function1)new Function1<FluentObject, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$feature.setCentroid((Vec<Untyped>)ResponseJsonParser.access$parseCentroid(ResponseJsonParser.INSTANCE, it));
                                    }
                                }).getExistingObject("limit", (Function1)new Function1<FluentObject, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$feature.setLimit(ResponseJsonParser.access$parseGeoRectangle(ResponseJsonParser.INSTANCE, it));
                                    }
                                }).getExistingObject("position", (Function1)new Function1<FluentObject, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        this.$feature.setPosition(ResponseJsonParser.access$parseGeoRectangle(ResponseJsonParser.INSTANCE, it));
                                    }
                                }).getExistingObject("tiles", (Function1)new Function1<FluentObject, Unit>(feature){
                                    final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                    {
                                        this.$feature = $feature;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject fragments) {
                                        Intrinsics.checkNotNullParameter((Object)fragments, (String)"fragments");
                                        fragments.forArrEntries((Function2)new Function2<String, List<?>, Unit>(this.$feature){
                                            final /* synthetic */ GeoResponseBuilder.GeocodedFeatureBuilder $feature;
                                            {
                                                this.$feature = $feature;
                                                super(2);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final void invoke(@NotNull String quadKey, @NotNull List<?> boundary) {
                                                Collection<Boundary> collection;
                                                void $this$mapTo$iv$iv;
                                                void $this$map$iv;
                                                Intrinsics.checkNotNullParameter((Object)quadKey, (String)"quadKey");
                                                Intrinsics.checkNotNullParameter(boundary, (String)"boundary");
                                                Iterable iterable = boundary;
                                                QuadKey quadKey2 = new QuadKey(quadKey);
                                                GeoResponseBuilder.GeocodedFeatureBuilder geocodedFeatureBuilder = this.$feature;
                                                boolean $i$f$map = false;
                                                void var5_7 = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                                                while (iterator.hasNext()) {
                                                    void it;
                                                    T item$iv$iv;
                                                    T t = item$iv$iv = iterator.next();
                                                    collection = destination$iv$iv;
                                                    boolean bl = false;
                                                    void v0 = it;
                                                    Intrinsics.checkNotNull((Object)v0);
                                                    collection.add(ResponseJsonParser.access$readBoundary(ResponseJsonParser.INSTANCE, (String)v0));
                                                }
                                                Collection<Boundary> collection2 = collection = (List)destination$iv$iv;
                                                QuadKey quadKey3 = quadKey2;
                                                geocodedFeatureBuilder.addFragment(new Fragment((QuadKey<LonLat>)quadKey3, (List<? extends Boundary<Untyped>>)collection2));
                                            }
                                        });
                                    }
                                });
                                this.$answer.addGeocodedFeature(feature.build());
                            }
                        });
                        this.$successResponse.addGeocodingAnswer(answer.build());
                    }
                });
            }
        });
        return successResponse.build();
    }

    private final GeoResponse ambiguous(FluentObject responseJson) {
        GeoResponseBuilder.AmbiguousResponseBuilder ambiguousResponse = new GeoResponseBuilder.AmbiguousResponseBuilder();
        responseJson.getObject("data", (Function1)new Function1<FluentObject, Unit>(ambiguousResponse){
            final /* synthetic */ GeoResponseBuilder.AmbiguousResponseBuilder $ambiguousResponse;
            {
                this.$ambiguousResponse = $ambiguousResponse;
                super(1);
            }

            public final void invoke(@NotNull FluentObject data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getOptionalEnum("level", (Function1)new Function1<FeatureLevel, Unit>(this.$ambiguousResponse){
                    final /* synthetic */ GeoResponseBuilder.AmbiguousResponseBuilder $ambiguousResponse;
                    {
                        this.$ambiguousResponse = $ambiguousResponse;
                        super(1);
                    }

                    public final void invoke(@Nullable FeatureLevel it) {
                        this.$ambiguousResponse.setLevel(it);
                    }
                }, (Enum[])FeatureLevel.values()).forObjects("features", (Function1)new Function1<FluentObject, Unit>(this.$ambiguousResponse){
                    final /* synthetic */ GeoResponseBuilder.AmbiguousResponseBuilder $ambiguousResponse;
                    {
                        this.$ambiguousResponse = $ambiguousResponse;
                        super(1);
                    }

                    public final void invoke(@NotNull FluentObject featureJson) {
                        Intrinsics.checkNotNullParameter((Object)featureJson, (String)"featureJson");
                        GeoResponseBuilder.AmbiguousFeatureBuilder feature = new GeoResponseBuilder.AmbiguousFeatureBuilder();
                        featureJson.getString("query", (Function1)new Function1<String, Unit>(feature){
                            final /* synthetic */ GeoResponseBuilder.AmbiguousFeatureBuilder $feature;
                            {
                                this.$feature = $feature;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$feature.setQuery(it);
                            }
                        }).getInt("total_namesake_count", (Function1)new Function1<Integer, Unit>(feature){
                            final /* synthetic */ GeoResponseBuilder.AmbiguousFeatureBuilder $feature;
                            {
                                this.$feature = $feature;
                                super(1);
                            }

                            public final void invoke(int it) {
                                this.$feature.setTotalNamesakeCount(it);
                            }
                        }).forObjects("namesake_examples", (Function1)new Function1<FluentObject, Unit>(feature){
                            final /* synthetic */ GeoResponseBuilder.AmbiguousFeatureBuilder $feature;
                            {
                                this.$feature = $feature;
                                super(1);
                            }

                            public final void invoke(@NotNull FluentObject namesakeJson) {
                                Intrinsics.checkNotNullParameter((Object)namesakeJson, (String)"namesakeJson");
                                GeoResponseBuilder.NamesakeBuilder namesake = new GeoResponseBuilder.NamesakeBuilder();
                                namesakeJson.getString("name", (Function1)new Function1<String, Unit>((Object)namesake){

                                    public final void invoke(@NotNull String p0) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        ((GeoResponseBuilder.NamesakeBuilder)this.receiver).setName(p0);
                                    }
                                }).forObjects("parents", (Function1)new Function1<FluentObject, Unit>(namesake){
                                    final /* synthetic */ GeoResponseBuilder.NamesakeBuilder $namesake;
                                    {
                                        this.$namesake = $namesake;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull FluentObject parentJson) {
                                        Intrinsics.checkNotNullParameter((Object)parentJson, (String)"parentJson");
                                        parentJson.getString("name", (Function1)new Function1<String, Unit>((Object)this.$namesake){

                                            public final void invoke(@NotNull String p0) {
                                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                                ((GeoResponseBuilder.NamesakeBuilder)this.receiver).addParentName(p0);
                                            }
                                        }).getEnum("level", (Function1)new Function1<FeatureLevel, Unit>((Object)this.$namesake){

                                            public final void invoke(@NotNull FeatureLevel p0) {
                                                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                                                ((GeoResponseBuilder.NamesakeBuilder)this.receiver).addParentLevel(p0);
                                            }
                                        }, (Enum[])FeatureLevel.values());
                                    }
                                });
                                this.$feature.addNamesakeExample(namesake.build());
                            }
                        });
                        this.$ambiguousResponse.addAmbiguousFeature(feature.build());
                    }
                });
            }
        });
        return ambiguousResponse.build();
    }

    private final GeoResponse error(FluentObject responseJson) {
        return new GeoResponse.ErrorGeoResponse(responseJson.getString("message"));
    }

    private final Vec<Untyped> parseCentroid(FluentObject centroid) {
        return VecKt.explicitVec((double)centroid.getDouble("lon"), (double)centroid.getDouble("lat"));
    }

    private final Boundary<Untyped> readGeometry(String geoJson) {
        return Boundaries.INSTANCE.fromGeoJson(geoJson);
    }

    private final Boundary<Untyped> readBoundary(String boundary) {
        return Boundaries.INSTANCE.fromTwkb(boundary);
    }

    private final GeoRectangle parseGeoRectangle(FluentObject data) {
        return ProtocolJsonHelper.INSTANCE.parseGeoRectangle(data.get());
    }

    private final GeoResponse.SuccessGeoResponse.GeoParent parseGeoParent(FluentObject parent) {
        return new GeoResponse.SuccessGeoResponse.GeoParent(parent.getString("parent_id"), parent.getString("parent_name"), (FeatureLevel)parent.getEnum("parent_level", (Enum[])FeatureLevel.values()));
    }

    public static final /* synthetic */ Boundary access$readGeometry(ResponseJsonParser $this, String geoJson) {
        return $this.readGeometry(geoJson);
    }

    public static final /* synthetic */ GeoResponse.SuccessGeoResponse.GeoParent access$parseGeoParent(ResponseJsonParser $this, FluentObject parent) {
        return $this.parseGeoParent(parent);
    }

    public static final /* synthetic */ Vec access$parseCentroid(ResponseJsonParser $this, FluentObject centroid) {
        return $this.parseCentroid(centroid);
    }

    public static final /* synthetic */ GeoRectangle access$parseGeoRectangle(ResponseJsonParser $this, FluentObject data) {
        return $this.parseGeoRectangle(data);
    }

    public static final /* synthetic */ Boundary access$readBoundary(ResponseJsonParser $this, String boundary) {
        return $this.readBoundary(boundary);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseStatus.values().length];
            try {
                nArray[ResponseStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseStatus.AMBIGUOUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseStatus.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

