/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.SimpleFeature;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Geometry;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Untyped;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.gis.common.twkb.Twkb;
import org.jetbrains.letsPlot.gis.tileprotocol.GeometryCollection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010R\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileGeometryParser;", "", "geometryCollection", "Lorg/jetbrains/letsPlot/gis/tileprotocol/GeometryCollection;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/GeometryCollection;)V", "geometries", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeometries", "()Ljava/util/List;", "myGeometryConsumer", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileGeometryParser$MyGeometryConsumer;", "myParser", "Lorg/jetbrains/letsPlot/gis/common/twkb/Twkb$Parser;", "resume", "", "MyGeometryConsumer", "gis"})
public final class TileGeometryParser {
    @NotNull
    private final MyGeometryConsumer myGeometryConsumer;
    @NotNull
    private final Twkb.Parser myParser;

    public TileGeometryParser(@NotNull GeometryCollection geometryCollection) {
        Intrinsics.checkNotNullParameter((Object)geometryCollection, (String)"geometryCollection");
        this.myGeometryConsumer = new MyGeometryConsumer();
        this.myParser = Twkb.INSTANCE.parser(geometryCollection.asTwkb(), (SimpleFeature.GeometryConsumer<Untyped>)((SimpleFeature.GeometryConsumer)this.myGeometryConsumer));
    }

    @NotNull
    public final List<Geometry<LonLat>> getGeometries() {
        return this.myGeometryConsumer.getTileGeometries();
    }

    public final boolean resume() {
        return this.myParser.next();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0016R*\u0010\u0004\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileGeometryParser$MyGeometryConsumer;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/SimpleFeature$GeometryConsumer;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Untyped;", "()V", "myTileGeometries", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lkotlin/collections/ArrayList;", "tileGeometries", "", "getTileGeometries", "()Ljava/util/List;", "onLineString", "", "lineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/LineString;", "onMultiLineString", "multiLineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "onMultiPoint", "multiPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPoint;", "onMultiPolygon", "multipolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "onPoint", "point", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "onPolygon", "polygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Polygon;", "gis"})
    private static final class MyGeometryConsumer
    implements SimpleFeature.GeometryConsumer<Untyped> {
        @NotNull
        private final ArrayList<Geometry<LonLat>> myTileGeometries = new ArrayList();

        @NotNull
        public final List<Geometry<LonLat>> getTileGeometries() {
            return this.myTileGeometries;
        }

        public void onPoint(@NotNull Vec<Untyped> point) {
            Intrinsics.checkNotNullParameter(point, (String)"point");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(point)));
        }

        public void onLineString(@NotNull LineString<Untyped> lineString) {
            Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(lineString)));
        }

        public void onPolygon(@NotNull Polygon<Untyped> polygon) {
            Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(polygon)));
        }

        public void onMultiPoint(@NotNull MultiPoint<Untyped> multiPoint) {
            Intrinsics.checkNotNullParameter(multiPoint, (String)"multiPoint");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(multiPoint)));
        }

        public void onMultiLineString(@NotNull MultiLineString<Untyped> multiLineString) {
            Intrinsics.checkNotNullParameter(multiLineString, (String)"multiLineString");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(multiLineString)));
        }

        public void onMultiPolygon(@NotNull MultiPolygon<Untyped> multipolygon) {
            Intrinsics.checkNotNullParameter(multipolygon, (String)"multipolygon");
            this.myTileGeometries.add((Geometry<LonLat>)Geometry.Companion.of(FunctionsKt.reinterpret(multipolygon)));
        }
    }
}

