/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.ThreadSafeAsync;
import org.jetbrains.letsPlot.commons.intern.concurrent.Lock;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupport;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.gis.tileprotocol.Request;
import org.jetbrains.letsPlot.gis.tileprotocol.TileLayer;
import org.jetbrains.letsPlot.gis.tileprotocol.binary.ResponseTileDecoder;
import org.jetbrains.letsPlot.gis.tileprotocol.json.MapStyleJsonParser;
import org.jetbrains.letsPlot.gis.tileprotocol.json.RequestFormatter;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.MapConfig;
import org.jetbrains.letsPlot.gis.tileprotocol.socket.SafeSocketHandler;
import org.jetbrains.letsPlot.gis.tileprotocol.socket.SocketHandler;
import org.jetbrains.letsPlot.gis.tileprotocol.socket.TileWebSocket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0005\"#$%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u001fH\u0002R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService;", "", "url", "", "myTheme", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$Theme;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$Theme;)V", "<set-?>", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/MapConfig;", "mapConfig", "getMapConfig", "()Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/MapConfig;", "myIncrement", "", "myMessageQueue", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$ThreadSafeMessageQueue;", "mySocket", "Lorg/jetbrains/letsPlot/gis/tileprotocol/socket/TileWebSocket;", "myStatus", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$SocketStatus;", "pendingRequests", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$RequestMap;", "getTileData", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileLayer;", "bbox", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "zoom", "sendGeometryRequest", "", "message", "sendInitMessage", "RequestMap", "SocketStatus", "Theme", "ThreadSafeMessageQueue", "TileSocketHandler", "gis"})
@SourceDebugExtension(value={"SMAP\nTileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public class TileService {
    @NotNull
    private final Theme myTheme;
    @NotNull
    private final TileWebSocket mySocket;
    @NotNull
    private final ThreadSafeMessageQueue<String> myMessageQueue;
    @NotNull
    private final RequestMap pendingRequests;
    @Nullable
    private MapConfig mapConfig;
    private int myIncrement;
    @NotNull
    private SocketStatus myStatus;

    public TileService(@NotNull String url, @NotNull Theme myTheme) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)myTheme), (String)"myTheme");
        this.myTheme = myTheme;
        this.mySocket = new TileWebSocket(url, new SafeSocketHandler(new TileSocketHandler()));
        this.myMessageQueue = new ThreadSafeMessageQueue();
        this.pendingRequests = new RequestMap();
        this.myStatus = SocketStatus.NOT_CONNECTED;
    }

    @Nullable
    public final MapConfig getMapConfig() {
        return this.mapConfig;
    }

    @NotNull
    public Async<List<TileLayer>> getTileData(@NotNull Rect<LonLat> bbox, int zoom) {
        Intrinsics.checkNotNullParameter(bbox, (String)"bbox");
        int n = this.myIncrement;
        this.myIncrement = n + 1;
        String key = String.valueOf(n);
        ThreadSafeAsync async = new ThreadSafeAsync();
        this.pendingRequests.put(key, (ThreadSafeAsync<List<TileLayer>>)async);
        try {
            Object object = new Request.GetBinaryGeometryRequest(key, zoom, bbox);
            RequestFormatter requestFormatter = RequestFormatter.INSTANCE;
            Object p0 = (Request)object;
            boolean bl = false;
            object = requestFormatter.format((Request)p0);
            requestFormatter = JsonSupport.INSTANCE;
            p0 = object;
            boolean bl2 = false;
            String p02 = requestFormatter.formatJson(p0);
            boolean bl3 = false;
            this.sendGeometryRequest(p02);
        }
        catch (Throwable err) {
            this.pendingRequests.poll(key).failure(err);
        }
        return (Async)async;
    }

    private final void sendGeometryRequest(String message) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.myStatus.ordinal()]) {
            case 1: {
                this.myMessageQueue.add(message);
                this.myStatus = SocketStatus.CONNECTING;
                this.mySocket.connect();
                break;
            }
            case 2: {
                this.mySocket.send(message);
                break;
            }
            case 3: {
                this.myMessageQueue.add(message);
                break;
            }
            case 4: {
                throw new IllegalStateException("Socket error");
            }
        }
    }

    private final void sendInitMessage() {
        String string = this.myTheme.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object object = new Request.ConfigureConnectionRequest(string);
        Object object2 = RequestFormatter.INSTANCE;
        Object p0 = (Request)object;
        boolean bl = false;
        object = ((RequestFormatter)object2).format((Request)p0);
        object2 = JsonSupport.INSTANCE;
        p0 = object;
        boolean bl2 = false;
        object = object2.formatJson(p0);
        object2 = this.mySocket;
        p0 = object;
        boolean bl3 = false;
        ((TileWebSocket)object2).send((String)p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\r\u001a\u00020\u0007J\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b0\u000fJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0005\u001a6\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b0\u0006j\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$RequestMap;", "", "()V", "lock", "Lorg/jetbrains/letsPlot/commons/intern/concurrent/Lock;", "myAsyncMap", "Ljava/util/HashMap;", "", "Lorg/jetbrains/letsPlot/commons/intern/async/ThreadSafeAsync;", "", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileLayer;", "Lkotlin/collections/HashMap;", "poll", "key", "pollAll", "", "put", "", "async", "gis"})
    @SourceDebugExtension(value={"SMAP\nTileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$RequestMap\n+ 2 Lock.kt\norg/jetbrains/letsPlot/commons/intern/concurrent/LockKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n14#2,5:170\n14#2,3:175\n18#2:179\n14#2,5:180\n1#3:178\n*S KotlinDebug\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$RequestMap\n*L\n133#1:170,5\n137#1:175,3\n137#1:179\n141#1:180,5\n*E\n"})
    public static final class RequestMap {
        @NotNull
        private final Lock lock = new Lock();
        @NotNull
        private final HashMap<String, ThreadSafeAsync<List<TileLayer>>> myAsyncMap = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void put(@NotNull String key, @NotNull ThreadSafeAsync<List<TileLayer>> async) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(async, (String)"async");
            Lock $this$execute$iv = this.lock;
            boolean $i$f$execute = false;
            try {
                $this$execute$iv.lock();
                boolean bl = false;
                ((Map)this.myAsyncMap).put(key, async);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$execute$iv.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Map<String, ThreadSafeAsync<List<TileLayer>>> pollAll() {
            Lock $this$execute$iv = this.lock;
            boolean $i$f$execute = false;
            try {
                HashMap hashMap;
                $this$execute$iv.lock();
                boolean bl = false;
                HashMap it = hashMap = new HashMap(this.myAsyncMap);
                boolean bl2 = false;
                this.myAsyncMap.clear();
                Map map = hashMap;
                return map;
            }
            finally {
                $this$execute$iv.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ThreadSafeAsync<List<TileLayer>> poll(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Lock $this$execute$iv = this.lock;
            boolean $i$f$execute = false;
            try {
                $this$execute$iv.lock();
                boolean bl = false;
                ThreadSafeAsync<List<TileLayer>> threadSafeAsync = this.myAsyncMap.remove(key);
                Intrinsics.checkNotNull(threadSafeAsync);
                ThreadSafeAsync<List<TileLayer>> threadSafeAsync2 = threadSafeAsync;
                return threadSafeAsync2;
            }
            finally {
                $this$execute$iv.unlock();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$SocketStatus;", "", "(Ljava/lang/String;I)V", "NOT_CONNECTED", "CONFIGURED", "CONNECTING", "ERROR", "gis"})
    private static final class SocketStatus
    extends Enum<SocketStatus> {
        public static final /* enum */ SocketStatus NOT_CONNECTED = new SocketStatus();
        public static final /* enum */ SocketStatus CONFIGURED = new SocketStatus();
        public static final /* enum */ SocketStatus CONNECTING = new SocketStatus();
        public static final /* enum */ SocketStatus ERROR = new SocketStatus();
        private static final /* synthetic */ SocketStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SocketStatus[] values() {
            return (SocketStatus[])$VALUES.clone();
        }

        public static SocketStatus valueOf(String value) {
            return Enum.valueOf(SocketStatus.class, value);
        }

        @NotNull
        public static EnumEntries<SocketStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = socketStatusArray = new SocketStatus[]{SocketStatus.NOT_CONNECTED, SocketStatus.CONFIGURED, SocketStatus.CONNECTING, SocketStatus.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$Theme;", "", "(Ljava/lang/String;I)V", "COLOR", "LIGHT", "DARK", "BW", "gis"})
    public static final class Theme
    extends Enum<Theme> {
        public static final /* enum */ Theme COLOR = new Theme();
        public static final /* enum */ Theme LIGHT = new Theme();
        public static final /* enum */ Theme DARK = new Theme();
        public static final /* enum */ Theme BW = new Theme();
        private static final /* synthetic */ Theme[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Theme[] values() {
            return (Theme[])$VALUES.clone();
        }

        public static Theme valueOf(String value) {
            return Enum.valueOf(Theme.class, value);
        }

        @NotNull
        public static EnumEntries<Theme> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = themeArray = new Theme[]{Theme.COLOR, Theme.LIGHT, Theme.DARK, Theme.BW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\nJ\u001a\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u0010R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$ThreadSafeMessageQueue;", "T", "", "()V", "myList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myLock", "Lorg/jetbrains/letsPlot/commons/intern/concurrent/Lock;", "add", "", "v", "(Ljava/lang/Object;)V", "clear", "forEach", "f", "Lkotlin/Function1;", "gis"})
    @SourceDebugExtension(value={"SMAP\nTileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$ThreadSafeMessageQueue\n+ 2 Lock.kt\norg/jetbrains/letsPlot/commons/intern/concurrent/LockKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n14#2,5:170\n14#2,3:175\n18#2:180\n14#2,5:181\n1855#3,2:178\n*S KotlinDebug\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$ThreadSafeMessageQueue\n*L\n151#1:170,5\n157#1:175,3\n157#1:180\n163#1:181,5\n158#1:178,2\n*E\n"})
    public static final class ThreadSafeMessageQueue<T> {
        @NotNull
        private final ArrayList<T> myList = new ArrayList();
        @NotNull
        private final Lock myLock = new Lock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(T v) {
            Lock $this$execute$iv = this.myLock;
            boolean $i$f$execute = false;
            try {
                $this$execute$iv.lock();
                boolean bl = false;
                boolean bl2 = this.myList.add(v);
            }
            finally {
                $this$execute$iv.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void forEach(@NotNull Function1<? super T, Unit> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            Lock $this$execute$iv = this.myLock;
            boolean $i$f$execute = false;
            try {
                $this$execute$iv.lock();
                boolean bl = false;
                Iterable $this$forEach$iv = this.myList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    f.invoke(element$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$execute$iv.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            Lock $this$execute$iv = this.myLock;
            boolean $i$f$execute = false;
            try {
                $this$execute$iv.lock();
                boolean bl = false;
                this.myList.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$execute$iv.unlock();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService$TileSocketHandler;", "Lorg/jetbrains/letsPlot/gis/tileprotocol/socket/SocketHandler;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService;)V", "failPending", "", "cause", "", "onBinaryMessage", "message", "", "onClose", "", "onError", "onOpen", "onTextMessage", "gis"})
    @SourceDebugExtension(value={"SMAP\nTileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$TileSocketHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1#2:170\n1855#3,2:171\n*S KotlinDebug\n*F\n+ 1 TileService.kt\norg/jetbrains/letsPlot/gis/tileprotocol/TileService$TileSocketHandler\n*L\n125#1:171,2\n*E\n"})
    public final class TileSocketHandler
    implements SocketHandler {
        @Override
        public void onOpen() {
            TileService.this.sendInitMessage();
        }

        @Override
        public void onClose(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            TileService.this.myMessageQueue.add(message);
            if (TileService.this.myStatus == SocketStatus.CONFIGURED) {
                TileService.this.myStatus = SocketStatus.CONNECTING;
                TileService.this.mySocket.connect();
            }
        }

        @Override
        public void onError(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            TileService.this.myStatus = SocketStatus.ERROR;
            this.failPending(cause);
        }

        @Override
        public void onTextMessage(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (TileService.this.getMapConfig() == null) {
                TileService.this.mapConfig = MapStyleJsonParser.INSTANCE.parse(JsonSupport.INSTANCE.parseJson(message));
            }
            TileService.this.myStatus = SocketStatus.CONFIGURED;
            ThreadSafeMessageQueue threadSafeMessageQueue = TileService.this.myMessageQueue;
            TileService tileService = TileService.this;
            ThreadSafeMessageQueue $this$onTextMessage_u24lambda_u240 = threadSafeMessageQueue;
            boolean bl = false;
            $this$onTextMessage_u24lambda_u240.forEach((Function1)new Function1<String, Unit>((Object)tileService.mySocket){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((TileWebSocket)this.receiver).send(p0);
                }
            });
            $this$onTextMessage_u24lambda_u240.clear();
        }

        @Override
        public void onBinaryMessage(@NotNull byte[] message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                ResponseTileDecoder responseTileDecoder = new ResponseTileDecoder(message);
                TileService tileService = TileService.this;
                ResponseTileDecoder responseTileDecoder2 = responseTileDecoder;
                boolean bl = false;
                String key = responseTileDecoder2.component1();
                List<TileLayer> tiles = responseTileDecoder2.component2();
                tileService.pendingRequests.poll(key).success(tiles);
            }
            catch (Throwable e) {
                this.failPending(e);
            }
        }

        private final void failPending(Throwable cause) {
            Iterable $this$forEach$iv = TileService.this.pendingRequests.pollAll().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThreadSafeAsync it = (ThreadSafeAsync)element$iv;
                boolean bl = false;
                it.failure(cause);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SocketStatus.values().length];
            try {
                nArray[SocketStatus.NOT_CONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketStatus.CONFIGURED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketStatus.CONNECTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketStatus.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

