/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol.binary;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/binary/ByteArrayStream;", "", "bytes", "", "([B)V", "count", "", "position", "available", "read", "", "len", "gis"})
public final class ByteArrayStream {
    @NotNull
    private final byte[] bytes;
    private final int count;
    private int position;

    public ByteArrayStream(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.count = this.bytes.length;
    }

    public final int available() {
        return this.count - this.position;
    }

    public final byte read() {
        if (this.position >= this.count) {
            throw new IllegalStateException("Array size exceeded.");
        }
        int n = this.position;
        this.position = n + 1;
        return this.bytes[n];
    }

    @NotNull
    public final byte[] read(int len2) {
        if (this.position >= this.count) {
            throw new IllegalStateException("Array size exceeded.");
        }
        if (len2 > this.available()) {
            throw new IllegalStateException("Expected to read " + len2 + " bytea, but read " + this.available());
        }
        if (len2 <= 0) {
            return new byte[0];
        }
        int startIndex = this.position;
        this.position += len2;
        byte[] byArray = this.bytes;
        int n = this.position;
        return ArraysKt.copyOfRange((byte[])byArray, (int)startIndex, (int)n);
    }
}

