/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.FluentObject;
import org.jetbrains.letsPlot.commons.intern.json.UtilsKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.gis.tileprotocol.json.MapStyleJsonParser;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.LayerConfig;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.MapConfig;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.Rule;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.Style;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.TilePredicate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010/\u001a\u0002002\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000102J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0004H\u0002J2\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020.2\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0<0;H\u0002J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040;2\u0006\u0010?\u001a\u00020.H\u0002J6\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002070;2\u0006\u0010A\u001a\u00020.2\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0<0;H\u0002J$\u0010B\u001a\u00020=2\u0006\u0010C\u001a\u00020.2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040;H\u0002J6\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0<0;2\u0006\u0010F\u001a\u00020.2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040;H\u0002J0\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040;2\u0006\u0010H\u001a\u00020.2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040;H\u0002J\"\u0010I\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040<0;2\u0006\u0010J\u001a\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/json/MapStyleJsonParser;", "", "()V", "BACKGROUND", "", "BORDER", "COLORS", "COLUMNS", "FILL", "FILTER", "FONT_FACE", "FONT_STYLE", "GT", "GTE", "LABEL_FIELD", "LAYERS", "LINE_CAP", "LINE_JOIN", "LT", "LTE", "MAX_ZOOM", "", "MAX_ZOOM_FIELD", "MINIMUM_PADDING", "MIN_ZOOM", "MIN_ZOOM_FIELD", "ORDER", "REPEAT_DISTANCE", "SHIELD_CORNER_RADIUS", "SHIELD_FILL_COLOR", "SHIELD_STROKE_COLOR", "SIZE", "STROKE", "STROKE_WIDTH", "STYLES", "SYMBOLIZER", "TABLE", "TEXT_TRANSFORM", "TILE_SHEETS", "TYPE", "WRAP_WIDTH", "ZOOMS", "makeCompareFunctions", "Lkotlin/Function1;", "", "condition", "Lorg/jetbrains/letsPlot/commons/intern/json/FluentObject;", "parse", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/MapConfig;", "mapStyle", "", "parseHexWithAlpha", "Lorg/jetbrains/letsPlot/commons/values/Color;", "colorString", "parseLayerConfig", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/LayerConfig;", "layerName", "layerJson", "styles", "", "", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Rule;", "readColors", "colorsJson", "readLayers", "layers", "readRule", "ruleJson", "colors", "readStyles", "stylesJson", "readTileSheets", "tiles", "readZooms", "zooms", "gis"})
public final class MapStyleJsonParser {
    @NotNull
    public static final MapStyleJsonParser INSTANCE = new MapStyleJsonParser();
    @NotNull
    private static final String MIN_ZOOM_FIELD = "minZoom";
    @NotNull
    private static final String MAX_ZOOM_FIELD = "maxZoom";
    @NotNull
    private static final String ZOOMS = "zooms";
    @NotNull
    private static final String LAYERS = "layers";
    @NotNull
    private static final String BORDER = "border";
    @NotNull
    private static final String TABLE = "table";
    @NotNull
    private static final String COLUMNS = "columns";
    @NotNull
    private static final String ORDER = "order";
    @NotNull
    private static final String COLORS = "colors";
    @NotNull
    private static final String STYLES = "styles";
    @NotNull
    private static final String TILE_SHEETS = "tiles";
    @NotNull
    private static final String BACKGROUND = "background";
    @NotNull
    private static final String FILTER = "filter";
    @NotNull
    private static final String GT = "$gt";
    @NotNull
    private static final String GTE = "$gte";
    @NotNull
    private static final String LT = "$lt";
    @NotNull
    private static final String LTE = "$lte";
    @NotNull
    private static final String SYMBOLIZER = "symbolizer";
    @NotNull
    private static final String TYPE = "type";
    @NotNull
    private static final String FILL = "fill";
    @NotNull
    private static final String STROKE = "stroke";
    @NotNull
    private static final String STROKE_WIDTH = "stroke-width";
    @NotNull
    private static final String LINE_CAP = "stroke-linecap";
    @NotNull
    private static final String LINE_JOIN = "stroke-linejoin";
    @NotNull
    private static final String LABEL_FIELD = "label";
    @NotNull
    private static final String FONT_STYLE = "fontStyle";
    @NotNull
    private static final String FONT_FACE = "fontface";
    @NotNull
    private static final String TEXT_TRANSFORM = "text-transform";
    @NotNull
    private static final String SIZE = "size";
    @NotNull
    private static final String WRAP_WIDTH = "wrap-width";
    @NotNull
    private static final String MINIMUM_PADDING = "minimum-padding";
    @NotNull
    private static final String REPEAT_DISTANCE = "repeat-distance";
    @NotNull
    private static final String SHIELD_CORNER_RADIUS = "shield-corner-radius";
    @NotNull
    private static final String SHIELD_FILL_COLOR = "shield-fill-color";
    @NotNull
    private static final String SHIELD_STROKE_COLOR = "shield-stroke-color";
    private static final int MIN_ZOOM = 1;
    private static final int MAX_ZOOM = 15;

    private MapStyleJsonParser() {
    }

    @NotNull
    public final MapConfig parse(@NotNull Map<String, Object> mapStyle) {
        Intrinsics.checkNotNullParameter(mapStyle, (String)"mapStyle");
        FluentObject mapStyleJson = new FluentObject(mapStyle);
        Map<String, Color> colors = this.readColors(mapStyleJson.getObject(COLORS));
        Map<String, List<Rule>> styles = this.readStyles(mapStyleJson.getObject(STYLES), colors);
        return new MapConfig.MapConfigBuilder().tileSheetBackgrounds(this.readTileSheets(mapStyleJson.getObject(TILE_SHEETS), colors)).colors(colors).layerNamesByZoom(this.readZooms(mapStyleJson.getObject(ZOOMS))).layers(this.readLayers(mapStyleJson.getObject(LAYERS), styles)).build();
    }

    private final Map<String, List<Rule>> readStyles(FluentObject stylesJson, Map<String, Color> colors) {
        HashMap<String, List<Rule>> styles = new HashMap<String, List<Rule>>();
        stylesJson.forArrEntries(new Function2<String, List<?>, Unit>(styles, colors){
            final /* synthetic */ HashMap<String, List<Rule>> $styles;
            final /* synthetic */ Map<String, Color> $colors;
            {
                this.$styles = $styles;
                this.$colors = $colors;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String styleName, @NotNull List<?> rules) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
                Intrinsics.checkNotNullParameter(rules, (String)"rules");
                Map map = this.$styles;
                Iterable iterable = rules;
                Map<String, Color> map2 = this.$colors;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                    collection.add(MapStyleJsonParser.access$readRule(MapStyleJsonParser.INSTANCE, new FluentObject((Map)it), map2));
                }
                iterable = (List)destination$iv$iv;
                map.put(styleName, iterable);
            }
        });
        return styles;
    }

    private final Map<Integer, List<String>> readZooms(FluentObject zooms) {
        HashMap zoomMap = new HashMap();
        for (int zoom = 1; zoom < 16; ++zoom) {
            Integer n = zoom;
            ((Map)zoomMap).put(n, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)zooms.getArray(String.valueOf(zoom)).stream(), (Function1)readZooms.1.INSTANCE)));
        }
        return zoomMap;
    }

    private final Map<String, LayerConfig> readLayers(FluentObject layers, Map<String, ? extends List<Rule>> styles) {
        HashMap<String, LayerConfig> layerConfigMap = new HashMap<String, LayerConfig>();
        layers.forObjEntries(new Function2<String, Map<?, ?>, Unit>(layerConfigMap, styles){
            final /* synthetic */ HashMap<String, LayerConfig> $layerConfigMap;
            final /* synthetic */ Map<String, List<Rule>> $styles;
            {
                this.$layerConfigMap = $layerConfigMap;
                this.$styles = $styles;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull Map<?, ?> layer) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(layer, (String)"layer");
                ((Map)this.$layerConfigMap).put(name, MapStyleJsonParser.access$parseLayerConfig(MapStyleJsonParser.INSTANCE, name, new FluentObject(layer), this.$styles));
            }
        });
        return layerConfigMap;
    }

    private final Map<String, Color> readColors(FluentObject colorsJson) {
        HashMap<String, Color> colors = new HashMap<String, Color>();
        colorsJson.forEntries((Function2)new Function2<String, Object, Unit>(colors){
            final /* synthetic */ HashMap<String, Color> $colors;
            {
                this.$colors = $colors;
                super(2);
            }

            public final void invoke(@NotNull String colorName, @Nullable Object colorString) {
                Intrinsics.checkNotNullParameter((Object)colorName, (String)"colorName");
                Map map = this.$colors;
                Intrinsics.checkNotNull((Object)colorString, (String)"null cannot be cast to non-null type kotlin.String");
                map.put(colorName, MapStyleJsonParser.access$parseHexWithAlpha(MapStyleJsonParser.INSTANCE, (String)colorString));
            }
        });
        return colors;
    }

    private final Map<String, Color> readTileSheets(FluentObject tiles, Map<String, Color> colors) {
        HashMap<String, Color> sheetBackgrounds = new HashMap<String, Color>();
        tiles.forObjEntries(new Function2<String, Map<?, ?>, Unit>(sheetBackgrounds, colors){
            final /* synthetic */ HashMap<String, Color> $sheetBackgrounds;
            final /* synthetic */ Map<String, Color> $colors;
            {
                this.$sheetBackgrounds = $sheetBackgrounds;
                this.$colors = $colors;
                super(2);
            }

            public final void invoke(@NotNull String sheetName, @NotNull Map<?, ?> tile) {
                Intrinsics.checkNotNullParameter((Object)sheetName, (String)"sheetName");
                Intrinsics.checkNotNullParameter(tile, (String)"tile");
                ((Map)this.$sheetBackgrounds).put(sheetName, MapsKt.getValue(this.$colors, (Object)UtilsKt.getString(tile, (String)"background")));
            }
        });
        return sheetBackgrounds;
    }

    private final Rule readRule(FluentObject ruleJson, Map<String, Color> colors) {
        Rule.RuleBuilder builder = new Rule.RuleBuilder();
        ruleJson.getIntOrDefault(MIN_ZOOM_FIELD, (Function1)new Function1<Integer, Unit>((Object)builder){

            public final void invoke(int p0) {
                ((Rule.RuleBuilder)this.receiver).minZoom(p0);
            }
        }, 1).getIntOrDefault(MAX_ZOOM_FIELD, (Function1)new Function1<Integer, Unit>((Object)builder){

            public final void invoke(int p0) {
                ((Rule.RuleBuilder)this.receiver).maxZoom(p0);
            }
        }, 15).getExistingObject(FILTER, (Function1)new Function1<FluentObject, Unit>(builder){
            final /* synthetic */ Rule.RuleBuilder $builder;
            {
                this.$builder = $builder;
                super(1);
            }

            public final void invoke(@NotNull FluentObject filter) {
                Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
                filter.forEntries((Function2)new Function2<String, Object, Unit>(this.$builder){
                    final /* synthetic */ Rule.RuleBuilder $builder;
                    {
                        this.$builder = $builder;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull String key, @Nullable Object value) {
                        Function1 function1;
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Function1 predicate = null;
                        Object object = value;
                        if (object instanceof List) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = (Iterable)value;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                void p0;
                                T item$iv$iv;
                                T t = item$iv$iv = iterator.next();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(UtilsKt.getAsInt((Object)p0));
                            }
                            List filterValues = (List)destination$iv$iv;
                            function1 = (Function1)new Function1<Integer, Boolean>((List<Integer>)filterValues){
                                final /* synthetic */ List<Integer> $filterValues;
                                {
                                    this.$filterValues = $filterValues;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(int it) {
                                    return this.$filterValues.contains(it);
                                }
                            };
                        } else if (object instanceof Number) {
                            int intValue = UtilsKt.getAsInt((Object)value);
                            function1 = (Function1)new Function1<Integer, Boolean>(intValue){
                                final /* synthetic */ int $intValue;
                                {
                                    this.$intValue = $intValue;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(int v) {
                                    return v == this.$intValue;
                                }
                            };
                        } else if (object instanceof Map) {
                            function1 = MapStyleJsonParser.access$makeCompareFunctions(MapStyleJsonParser.INSTANCE, new FluentObject((Map)value));
                        } else {
                            throw new IllegalStateException("Unsupported filter type.");
                        }
                        predicate = function1;
                        this.$builder.addFilterFunction((Function1<? super TilePredicate, Boolean>)((Function1)new Function1<TilePredicate, Boolean>((Function1<? super Integer, Boolean>)predicate, key){
                            final /* synthetic */ Function1<Integer, Boolean> $predicate;
                            final /* synthetic */ String $key;
                            {
                                this.$predicate = $predicate;
                                this.$key = $key;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TilePredicate feature) {
                                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                                return (Boolean)this.$predicate.invoke((Object)feature.getFieldValue(this.$key));
                            }
                        }));
                    }
                });
            }
        }).getExistingObject(SYMBOLIZER, (Function1)new Function1<FluentObject, Unit>(builder, colors){
            final /* synthetic */ Rule.RuleBuilder $builder;
            final /* synthetic */ Map<String, Color> $colors;
            {
                this.$builder = $builder;
                this.$colors = $colors;
                super(1);
            }

            public final void invoke(@NotNull FluentObject symbolizerJson) {
                Intrinsics.checkNotNullParameter((Object)symbolizerJson, (String)"symbolizerJson");
                Style style = new Style();
                symbolizerJson.getExistingString("type", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setType(it);
                    }
                }).getExistingString("fill", (Function1)new Function1<String, Unit>(style, this.$colors){
                    final /* synthetic */ Style $style;
                    final /* synthetic */ Map<String, Color> $colors;
                    {
                        this.$style = $style;
                        this.$colors = $colors;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setFill(this.$colors.get(it));
                    }
                }).getExistingString("stroke", (Function1)new Function1<String, Unit>(style, this.$colors){
                    final /* synthetic */ Style $style;
                    final /* synthetic */ Map<String, Color> $colors;
                    {
                        this.$style = $style;
                        this.$colors = $colors;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setStroke(this.$colors.get(it));
                    }
                }).getExistingDouble("stroke-width", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setStrokeWidth(it);
                    }
                }).getExistingString("stroke-linecap", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setLineCap(it);
                    }
                }).getExistingString("stroke-linejoin", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setLineJoin(it);
                    }
                }).getExistingString("label", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setLabelField(it);
                    }
                }).getExistingString("fontStyle", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setFontStyle(it);
                    }
                }).getExistingString("fontface", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setFontFamily(it);
                    }
                }).getExistingString("text-transform", (Function1)new Function1<String, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setTextTransform(it);
                    }
                }).getExistingDouble("size", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setSize(it);
                    }
                }).getExistingDouble("wrap-width", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setWrapWidth(it);
                    }
                }).getExistingDouble("minimum-padding", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setMinimumPadding(it);
                    }
                }).getExistingDouble("repeat-distance", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setRepeatDistance(it);
                    }
                }).getExistingDouble("shield-corner-radius", (Function1)new Function1<Double, Unit>(style){
                    final /* synthetic */ Style $style;
                    {
                        this.$style = $style;
                        super(1);
                    }

                    public final void invoke(double it) {
                        this.$style.setShieldCornerRadius(it);
                    }
                }).getExistingString("shield-fill-color", (Function1)new Function1<String, Unit>(style, this.$colors){
                    final /* synthetic */ Style $style;
                    final /* synthetic */ Map<String, Color> $colors;
                    {
                        this.$style = $style;
                        this.$colors = $colors;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setShieldFillColor(this.$colors.get(it));
                    }
                }).getExistingString("shield-stroke-color", (Function1)new Function1<String, Unit>(style, this.$colors){
                    final /* synthetic */ Style $style;
                    final /* synthetic */ Map<String, Color> $colors;
                    {
                        this.$style = $style;
                        this.$colors = $colors;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$style.setShieldStrokeColor(this.$colors.get(it));
                    }
                });
                this.$builder.style(style);
            }
        });
        return builder.build();
    }

    private final Function1<Integer, Boolean> makeCompareFunctions(FluentObject condition) {
        int conditionValue = 0;
        if (condition.contains(GT)) {
            conditionValue = condition.getInt(GT);
            return (Function1)new Function1<Integer, Boolean>(conditionValue){
                final /* synthetic */ int $conditionValue;
                {
                    this.$conditionValue = $conditionValue;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int v) {
                    return v > this.$conditionValue;
                }
            };
        }
        if (condition.contains(GTE)) {
            conditionValue = condition.getInt(GTE);
            return (Function1)new Function1<Integer, Boolean>(conditionValue){
                final /* synthetic */ int $conditionValue;
                {
                    this.$conditionValue = $conditionValue;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int v) {
                    return v >= this.$conditionValue;
                }
            };
        }
        if (condition.contains(LT)) {
            conditionValue = condition.getInt(LT);
            return (Function1)new Function1<Integer, Boolean>(conditionValue){
                final /* synthetic */ int $conditionValue;
                {
                    this.$conditionValue = $conditionValue;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int v) {
                    return v < this.$conditionValue;
                }
            };
        }
        if (condition.contains(LTE)) {
            conditionValue = condition.getInt(LTE);
            return (Function1)new Function1<Integer, Boolean>(conditionValue){
                final /* synthetic */ int $conditionValue;
                {
                    this.$conditionValue = $conditionValue;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(int v) {
                    return v <= this.$conditionValue;
                }
            };
        }
        throw new IllegalStateException("Unknown condition type");
    }

    private final LayerConfig parseLayerConfig(String layerName, FluentObject layerJson, Map<String, ? extends List<Rule>> styles) {
        LayerConfig layerConfig = new LayerConfig();
        layerConfig.setName(layerName);
        layerJson.getDouble(BORDER, (Function1)new Function1<Double, Unit>(layerConfig){
            final /* synthetic */ LayerConfig $layerConfig;
            {
                this.$layerConfig = $layerConfig;
                super(1);
            }

            public final void invoke(double it) {
                this.$layerConfig.setBorder(it);
            }
        }).getString(TABLE, (Function1)new Function1<String, Unit>(layerConfig){
            final /* synthetic */ LayerConfig $layerConfig;
            {
                this.$layerConfig = $layerConfig;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$layerConfig.setTable(it);
            }
        }).getExistingString(ORDER, (Function1)new Function1<String, Unit>(layerConfig){
            final /* synthetic */ LayerConfig $layerConfig;
            {
                this.$layerConfig = $layerConfig;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$layerConfig.setOrder(it);
            }
        }).getStrings(COLUMNS, (Function1)new Function1<List<? extends String>, Unit>(layerConfig){
            final /* synthetic */ LayerConfig $layerConfig;
            {
                this.$layerConfig = $layerConfig;
                super(1);
            }

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$layerConfig.setColumns(CollectionsKt.requireNoNulls(it));
            }
        }).getObject(TILE_SHEETS, (Function1)new Function1<FluentObject, Unit>(layerConfig, styles){
            final /* synthetic */ LayerConfig $layerConfig;
            final /* synthetic */ Map<String, List<Rule>> $styles;
            {
                this.$layerConfig = $layerConfig;
                this.$styles = $styles;
                super(1);
            }

            public final void invoke(@NotNull FluentObject tileSheetsJson) {
                Intrinsics.checkNotNullParameter((Object)tileSheetsJson, (String)"tileSheetsJson");
                HashMap<String, List<List<Rule>>> rulesByTileSheet = new HashMap<String, List<List<Rule>>>();
                tileSheetsJson.forArrEntries((Function2)new Function2<String, List<?>, Unit>(rulesByTileSheet, this.$styles){
                    final /* synthetic */ HashMap<String, List<List<Rule>>> $rulesByTileSheet;
                    final /* synthetic */ Map<String, List<Rule>> $styles;
                    {
                        this.$rulesByTileSheet = $rulesByTileSheet;
                        this.$styles = $styles;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull String tileSheets, @NotNull List<?> styleNames) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter((Object)tileSheets, (String)"tileSheets");
                        Intrinsics.checkNotNullParameter(styleNames, (String)"styleNames");
                        Map map = this.$rulesByTileSheet;
                        Iterable iterable = styleNames;
                        Map<String, List<Rule>> map2 = this.$styles;
                        boolean $i$f$map = false;
                        void var7_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.String");
                            collection.add((List)MapsKt.getValue(map2, (Object)((String)it)));
                        }
                        iterable = (List)destination$iv$iv;
                        map.put(tileSheets, iterable);
                    }
                });
                this.$layerConfig.setRulesByTileSheet((Map<String, ? extends List<? extends List<Rule>>>)rulesByTileSheet);
            }
        });
        return layerConfig;
    }

    private final Color parseHexWithAlpha(String colorString) {
        String string = colorString.substring(0, 7);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Color color = Color.Companion.parseHex(string);
        String string2 = colorString.substring(7, 9);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return color.changeAlpha(Integer.parseInt(string2, CharsKt.checkRadix((int)16)));
    }

    public static final /* synthetic */ Rule access$readRule(MapStyleJsonParser $this, FluentObject ruleJson, Map colors) {
        return $this.readRule(ruleJson, colors);
    }

    public static final /* synthetic */ LayerConfig access$parseLayerConfig(MapStyleJsonParser $this, String layerName, FluentObject layerJson, Map styles) {
        return $this.parseLayerConfig(layerName, layerJson, styles);
    }

    public static final /* synthetic */ Color access$parseHexWithAlpha(MapStyleJsonParser $this, String colorString) {
        return $this.parseHexWithAlpha(colorString);
    }

    public static final /* synthetic */ Function1 access$makeCompareFunctions(MapStyleJsonParser $this, FluentObject condition) {
        return $this.makeCompareFunctions(condition);
    }
}

