/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol.json;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.json.FluentArray;
import org.jetbrains.letsPlot.commons.intern.json.FluentObject;
import org.jetbrains.letsPlot.commons.intern.json.UtilsKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.gis.tileprotocol.Request;
import org.jetbrains.letsPlot.gis.tileprotocol.TileCoordinates;
import org.jetbrains.letsPlot.gis.tileprotocol.json.RequestTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/json/RequestJsonParser;", "", "()V", "X", "", "getX$gis", "()Ljava/lang/String;", "Y", "getY$gis", "Z", "getZ$gis", "parse", "Lorg/jetbrains/letsPlot/gis/tileprotocol/Request;", "request", "", "Lorg/jetbrains/letsPlot/commons/intern/json/Obj;", "parseBBox", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "bbox", "Lorg/jetbrains/letsPlot/commons/intern/json/FluentArray;", "parseTileCoordinates", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileCoordinates;", "jsonCoordinates", "Lorg/jetbrains/letsPlot/commons/intern/json/FluentObject;", "gis"})
@SourceDebugExtension(value={"SMAP\nRequestJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestJsonParser.kt\norg/jetbrains/letsPlot/gis/tileprotocol/json/RequestJsonParser\n+ 2 Utils.kt\norg/jetbrains/letsPlot/commons/intern/json/UtilsKt\n*L\n1#1,66:1\n38#2:67\n*S KotlinDebug\n*F\n+ 1 RequestJsonParser.kt\norg/jetbrains/letsPlot/gis/tileprotocol/json/RequestJsonParser\n*L\n32#1:67\n*E\n"})
public final class RequestJsonParser {
    @NotNull
    public static final RequestJsonParser INSTANCE = new RequestJsonParser();
    @NotNull
    private static final String X = "x";
    @NotNull
    private static final String Y = "y";
    @NotNull
    private static final String Z = "z";

    private RequestJsonParser() {
    }

    @NotNull
    public final String getX$gis() {
        return X;
    }

    @NotNull
    public final String getY$gis() {
        return Y;
    }

    @NotNull
    public final String getZ$gis() {
        return Z;
    }

    @NotNull
    public final Request parse(@NotNull Map<?, ?> request) {
        Request request2;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        FluentObject $this$parse_u24lambda_u240 = new FluentObject(request);
        boolean bl = false;
        String enumStringValue$iv = $this$parse_u24lambda_u240.getString("type");
        boolean $i$f$parseEnum = false;
        switch (WhenMappings.$EnumSwitchMapping$0[((RequestTypes)UtilsKt.parseEnum((String)enumStringValue$iv, (Enum[])RequestTypes.values())).ordinal()]) {
            case 1: {
                request2 = new Request.ConfigureConnectionRequest($this$parse_u24lambda_u240.getString("style"));
                break;
            }
            case 2: {
                request2 = new Request.GetBinaryGeometryRequest($this$parse_u24lambda_u240.getString("key"), $this$parse_u24lambda_u240.getInt("zoom"), INSTANCE.parseBBox($this$parse_u24lambda_u240.getArray("bbox")));
                break;
            }
            case 3: {
                request2 = new Request.CancelBinaryTileRequest(SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)$this$parse_u24lambda_u240.getArray("data").fluentObjectStream(), (Function1)((Function1)new Function1<FluentObject, TileCoordinates>((Object)this){

                    @NotNull
                    public final TileCoordinates invoke(@NotNull FluentObject p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return RequestJsonParser.access$parseTileCoordinates((RequestJsonParser)this.receiver, p0);
                    }
                }))));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return request2;
    }

    private final Rect<LonLat> parseBBox(FluentArray bbox) {
        return Rect.Companion.LTRB(bbox.getDouble(0), bbox.getDouble(1), bbox.getDouble(2), bbox.getDouble(3));
    }

    private final TileCoordinates parseTileCoordinates(FluentObject jsonCoordinates) {
        return new TileCoordinates(jsonCoordinates.getInt(X), jsonCoordinates.getInt(Y), jsonCoordinates.getInt(Z));
    }

    public static final /* synthetic */ TileCoordinates access$parseTileCoordinates(RequestJsonParser $this, FluentObject jsonCoordinates) {
        return $this.parseTileCoordinates(jsonCoordinates);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestTypes.values().length];
            try {
                nArray[RequestTypes.CONFIGURE_CONNECTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestTypes.GET_BINARY_TILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestTypes.CANCEL_BINARY_TILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

