/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.gis.tileprotocol.mapConfig;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.Style;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.TilePredicate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001\u0017B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0003R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Rule;", "", "minZoom", "", "maxZoom", "filters", "", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/TilePredicate;", "", "style", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "(IILjava/util/List;Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;)V", "getFilters", "()Ljava/util/List;", "getMaxZoom", "()I", "getMinZoom", "getStyle", "()Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "predicate", "feature", "zoom", "RuleBuilder", "gis"})
public final class Rule {
    private final int minZoom;
    private final int maxZoom;
    @NotNull
    private final List<Function1<TilePredicate, Boolean>> filters;
    @NotNull
    private final Style style;

    public Rule(int minZoom, int maxZoom, @NotNull List<? extends Function1<? super TilePredicate, Boolean>> filters, @NotNull Style style) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.filters = filters;
        this.style = style;
    }

    public final int getMinZoom() {
        return this.minZoom;
    }

    public final int getMaxZoom() {
        return this.maxZoom;
    }

    @NotNull
    public final List<Function1<TilePredicate, Boolean>> getFilters() {
        return this.filters;
    }

    @NotNull
    public final Style getStyle() {
        return this.style;
    }

    public final boolean predicate(@NotNull TilePredicate feature, int zoom) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        if (this.maxZoom < zoom || this.minZoom > zoom) {
            return false;
        }
        for (Function1<TilePredicate, Boolean> f : this.filters) {
            if (((Boolean)f.invoke((Object)feature)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\t\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eR6\u0010\u0003\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Rule$RuleBuilder;", "", "()V", "filters", "Ljava/util/ArrayList;", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/TilePredicate;", "", "Lkotlin/collections/ArrayList;", "maxZoom", "", "Ljava/lang/Integer;", "minZoom", "style", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "addFilterFunction", "", "filter", "build", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Rule;", "gis"})
    public static final class RuleBuilder {
        @Nullable
        private Integer minZoom;
        @Nullable
        private Integer maxZoom;
        @NotNull
        private ArrayList<Function1<TilePredicate, Boolean>> filters = new ArrayList();
        private Style style;

        public final void minZoom(int minZoom) {
            this.minZoom = minZoom;
        }

        public final void maxZoom(int maxZoom) {
            this.maxZoom = maxZoom;
        }

        public final void style(@NotNull Style style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.style = style;
        }

        public final void addFilterFunction(@NotNull Function1<? super TilePredicate, Boolean> filter) {
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            this.filters.add(filter);
        }

        @NotNull
        public final Rule build() {
            Integer n = this.minZoom;
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.maxZoom;
            Intrinsics.checkNotNull((Object)n3);
            int n4 = n3;
            List list = this.filters;
            Style style = this.style;
            if (style == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"style");
                style = null;
            }
            return new Rule(n2, n4, list, style);
        }
    }
}

