/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkMultiple;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSPLT;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkMultiple;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "nentries", "", "getNentries", "()I", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "palName", "", "getPalName", "()Ljava/lang/String;", "setPalName", "(Ljava/lang/String;)V", "palette", "", "getPalette", "()[I", "setPalette", "([I)V", "sampledepth", "getSampledepth", "setSampledepth", "(I)V", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkSPLT
extends PngChunkMultiple {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String palName;
    private int sampledepth;
    @NotNull
    private int[] palette = new int[5];
    @NotNull
    public static final String ID = "sPLT";

    public PngChunkSPLT(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Nullable
    public final String getPalName() {
        return this.palName;
    }

    public final void setPalName(@Nullable String string) {
        this.palName = string;
    }

    public final int getSampledepth() {
        return this.sampledepth;
    }

    public final void setSampledepth(int n) {
        this.sampledepth = n;
    }

    @NotNull
    public final int[] getPalette() {
        return this.palette;
    }

    public final void setPalette(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.palette = nArray;
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        OutputPngStream ba = new OutputPngStream();
        String string = this.palName;
        Intrinsics.checkNotNull((Object)string);
        ba.write(ChunkHelper.INSTANCE.toBytesLatin1(string));
        ba.write(0);
        ba.write((byte)this.sampledepth);
        int nentries = this.getNentries();
        for (int n = 0; n < nentries; ++n) {
            for (int i = 0; i < 4; ++i) {
                if (this.sampledepth == 8) {
                    PngHelperInternal.INSTANCE.writeByte(ba, (byte)this.palette[n * 5 + i]);
                    continue;
                }
                PngHelperInternal.INSTANCE.writeInt2(ba, this.palette[n * 5 + i]);
            }
            PngHelperInternal.INSTANCE.writeInt2(ba, this.palette[n * 5 + 4]);
        }
        byte[] b = ba.getByteArray();
        ChunkRaw chunk = this.createEmptyChunk(b.length, false);
        chunk.setData(b);
        return chunk;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        int t;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                t = -1;
                byte[] byArray = chunk.getData();
                Intrinsics.checkNotNull((Object)byArray);
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte[] byArray2 = chunk.getData();
                    Intrinsics.checkNotNull((Object)byArray2);
                    if (byArray2[i] != 0) continue;
                    t = i;
                    break;
                }
                if (t <= 0) break block7;
                byte[] byArray3 = chunk.getData();
                Intrinsics.checkNotNull((Object)byArray3);
                if (t <= byArray3.length - 2) break block8;
            }
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        byte[] byArray = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray);
        this.palName = ChunkHelper.INSTANCE.toStringLatin1(byArray, 0, t);
        this.sampledepth = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), t + 1);
        byte[] byArray4 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        int nentries = (byArray4.length - (t += 2)) / (this.sampledepth == 8 ? 6 : 10);
        this.palette = new int[nentries * 5];
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int f = 0;
        int ne = 0;
        for (int i = 0; i < nentries; ++i) {
            if (this.sampledepth == 8) {
                r = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), t++);
                g = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), t++);
                b = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), t++);
                a = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), t++);
            } else {
                r = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), t);
                g = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), t += 2);
                b = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), t += 2);
                a = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), t += 2);
                t += 2;
            }
            f = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), t);
            t += 2;
            this.palette[ne++] = r;
            this.palette[ne++] = g;
            this.palette[ne++] = b;
            this.palette[ne++] = a;
            this.palette[ne++] = f;
        }
    }

    private final int getNentries() {
        return this.palette.length / 5;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSPLT$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

