/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.livemap.Diagnostics;
import org.jetbrains.letsPlot.livemap.chart.fragment.CachedFragmentsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.DownloadingFragmentsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.StreamingFragmentsComponent;
import org.jetbrains.letsPlot.livemap.core.MetricsService;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsSystem;
import org.jetbrains.letsPlot.livemap.core.graphics.GraphicsService;
import org.jetbrains.letsPlot.livemap.core.graphics.Text;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroThreadComponent;
import org.jetbrains.letsPlot.livemap.core.multitasking.SchedulerSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.raster.RasterTileLoadingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileLoadingSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics;", "", "()V", "update", "", "dt", "", "toOdd", "LiveMapDiagnostics", "livemap"})
public class Diagnostics {
    public void update(long dt) {
    }

    public final long toOdd(long $this$toOdd) {
        return $this$toOdd - $this$toOdd % (long)2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 )2\u00020\u0001:\u000b)*+,-./0123BI\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics;", "isLoading", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "", "dirtyLayers", "", "", "schedulerSystem", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/SchedulerSystem;", "debugService", "Lorg/jetbrains/letsPlot/livemap/core/MetricsService;", "graphicsService", "Lorg/jetbrains/letsPlot/livemap/core/graphics/GraphicsService;", "registry", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "layerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "(Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;Ljava/util/List;Lorg/jetbrains/letsPlot/livemap/core/multitasking/SchedulerSystem;Lorg/jetbrains/letsPlot/livemap/core/MetricsService;Lorg/jetbrains/letsPlot/livemap/core/graphics/GraphicsService;Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;)V", "deltaTime", "", "diagnostics", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "Lkotlin/collections/ArrayList;", "metrics", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Text;", "slowestSystemTime", "", "getSlowestSystemTime", "()D", "slowestSystemType", "", "getSlowestSystemType", "()Ljava/lang/String;", "formatDouble", "v", "precision", "update", "", "dt", "Companion", "Diagnostic", "DirtyLayersDiagnostic", "DownloadingFragmentsDiagnostic", "DownloadingTilesDiagnostic", "FragmentsCacheDiagnostic", "FreezingSystemDiagnostic", "IsLoadingDiagnostic", "SchedulerSystemDiagnostic", "SlowestSystemDiagnostic", "StreamingFragmentsDiagnostic", "livemap"})
    @SourceDebugExtension(value={"SMAP\nDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1855#2,2:253\n*S KotlinDebug\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics\n*L\n103#1:253,2\n*E\n"})
    public static final class LiveMapDiagnostics
    extends Diagnostics {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Integer> dirtyLayers;
        @NotNull
        private final SchedulerSystem schedulerSystem;
        @NotNull
        private final MetricsService debugService;
        @NotNull
        private final GraphicsService graphicsService;
        @NotNull
        private final EcsComponentManager registry;
        @NotNull
        private final LayerManager layerManager;
        @NotNull
        private final ArrayList<Diagnostic> diagnostics;
        private long deltaTime;
        @NotNull
        private final Text metrics;
        @NotNull
        private static final String TIMER_TICK = "timer_tick";
        @NotNull
        private static final String SYSTEMS_UPDATE_TIME = "systems_update_time";
        @NotNull
        private static final String ENTITIES_COUNT = "entities_count";
        @NotNull
        private static final String SLOWEST_SYSTEM = "slow_system";
        @NotNull
        private static final String FREEZING_SYSTEM = "freezing_system";
        @NotNull
        private static final String SCHEDULER_SYSTEM = "scheduler_load";
        @NotNull
        private static final String DIRTY_LAYERS = "dirty_layers";
        @NotNull
        private static final String STREAMING_FRAGMENTS = "streaming_fragments";
        @NotNull
        private static final String DOWNLOADING_FRAGMENTS = "downloading_fragments";
        @NotNull
        private static final String DOWNLOADING_TILES = "downloading_tiles";
        @NotNull
        private static final String FRAGMENTS_CACHE = "fragments_cache";
        @NotNull
        private static final String IS_LOADING = "is_loading";

        /*
         * WARNING - void declaration
         */
        public LiveMapDiagnostics(@NotNull Property<Boolean> isLoading2, @NotNull List<Integer> dirtyLayers2, @NotNull SchedulerSystem schedulerSystem, @NotNull MetricsService debugService, @NotNull GraphicsService graphicsService, @NotNull EcsComponentManager registry, @NotNull LayerManager layerManager) {
            void $this$_init__u24lambda_u240;
            Intrinsics.checkNotNullParameter(isLoading2, (String)"isLoading");
            Intrinsics.checkNotNullParameter(dirtyLayers2, (String)"dirtyLayers");
            Intrinsics.checkNotNullParameter((Object)schedulerSystem, (String)"schedulerSystem");
            Intrinsics.checkNotNullParameter((Object)debugService, (String)"debugService");
            Intrinsics.checkNotNullParameter((Object)graphicsService, (String)"graphicsService");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)layerManager, (String)"layerManager");
            this.dirtyLayers = dirtyLayers2;
            this.schedulerSystem = schedulerSystem;
            this.debugService = debugService;
            this.graphicsService = graphicsService;
            this.registry = registry;
            this.layerManager = layerManager;
            this.diagnostics = new ArrayList();
            Object object = new Diagnostic[]{new FreezingSystemDiagnostic(), new DirtyLayersDiagnostic(), new SlowestSystemDiagnostic(), new SchedulerSystemDiagnostic(), new FragmentsCacheDiagnostic(), new StreamingFragmentsDiagnostic(), new DownloadingFragmentsDiagnostic(), new DownloadingTilesDiagnostic(), new IsLoadingDiagnostic(isLoading2)};
            this.diagnostics.addAll(CollectionsKt.listOf((Object[])object));
            object = new String[]{TIMER_TICK, SYSTEMS_UPDATE_TIME, ENTITIES_COUNT, SLOWEST_SYSTEM, FREEZING_SYSTEM, SCHEDULER_SYSTEM, DIRTY_LAYERS, STREAMING_FRAGMENTS, DOWNLOADING_FRAGMENTS, FRAGMENTS_CACHE, DOWNLOADING_TILES, IS_LOADING};
            this.debugService.setValuesOrder(CollectionsKt.listOf((Object[])object));
            Object object2 = object = new Text();
            LiveMapDiagnostics liveMapDiagnostics = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setColor(Color.Companion.getDARK_GREEN());
            $this$_init__u24lambda_u240.setFontFamily("Courier New");
            $this$_init__u24lambda_u240.setFontSize(12.0);
            $this$_init__u24lambda_u240.setOrigin(new DoubleVector(4.0, 150.0));
            liveMapDiagnostics.metrics = object;
            this.graphicsService.addToRenderer(this.metrics);
        }

        private final String getSlowestSystemType() {
            Pair<EcsSystem, Double> pair = this.debugService.slowestSystem();
            EcsSystem ecsSystem = pair != null ? (EcsSystem)pair.getFirst() : null;
            Intrinsics.checkNotNull((Object)ecsSystem);
            return Reflection.getOrCreateKotlinClass(ecsSystem.getClass()).getSimpleName();
        }

        private final double getSlowestSystemTime() {
            Pair<EcsSystem, Double> pair = this.debugService.slowestSystem();
            return pair != null ? ((Number)pair.getSecond()).doubleValue() : 0.0;
        }

        @Override
        public void update(long dt) {
            this.deltaTime = dt;
            this.debugService.setValue(TIMER_TICK, "Timer tick: " + this.toOdd(this.deltaTime));
            this.debugService.setValue(SYSTEMS_UPDATE_TIME, "Systems update: " + this.toOdd(this.debugService.getTotalUpdateTime()));
            this.debugService.setValue(ENTITIES_COUNT, "Entities count: " + this.registry.getEntitiesCount());
            Iterable $this$forEach$iv = this.diagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Diagnostic p0 = (Diagnostic)element$iv;
                boolean bl = false;
                p0.update();
            }
            if (!Intrinsics.areEqual(this.metrics.getText(), this.debugService.getValues())) {
                this.metrics.setText(this.debugService.getValues());
                this.graphicsService.repaint();
            }
        }

        private final String formatDouble(double v, int precision) {
            int intV = (int)v;
            int fracV = (int)((v - (double)intV) * 10.0 * (double)precision);
            return "" + intV + '.' + fracV;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Companion;", "", "()V", "DIRTY_LAYERS", "", "DOWNLOADING_FRAGMENTS", "DOWNLOADING_TILES", "ENTITIES_COUNT", "FRAGMENTS_CACHE", "FREEZING_SYSTEM", "IS_LOADING", "SCHEDULER_SYSTEM", "SLOWEST_SYSTEM", "STREAMING_FRAGMENTS", "SYSTEMS_UPDATE_TIME", "TIMER_TICK", "livemap"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "", "update", "", "livemap"})
        public static interface Diagnostic {
            public void update();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$DirtyLayersDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        public final class DirtyLayersDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                String dirtyLayers2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)SequencesKt.toSet((Sequence)SequencesKt.map(LiveMapDiagnostics.this.registry.getEntitiesById(LiveMapDiagnostics.this.dirtyLayers), (Function1)update.dirtyLayers.1.INSTANCE)), (Iterable)CollectionsKt.toSet((Iterable)LiveMapDiagnostics.this.layerManager.getLayers())), null, null, null, (int)0, null, (Function1)((Function1)update.dirtyLayers.2.INSTANCE), (int)31, null);
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.DIRTY_LAYERS, "Dirty layers: " + dirtyLayers2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$DownloadingFragmentsDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        @SourceDebugExtension(value={"SMAP\nDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$DownloadingFragmentsDiagnostic\n+ 2 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n144#2,2:253\n141#2:255\n147#2:259\n68#3:256\n24#3,2:257\n1#4:260\n*S KotlinDebug\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$DownloadingFragmentsDiagnostic\n*L\n192#1:253,2\n192#1:255\n192#1:259\n192#1:256\n192#1:257,2\n*E\n"})
        public final class DownloadingFragmentsDiagnostic
        implements Diagnostic {
            /*
             * Unable to fully structure code
             */
            @Override
            public void update() {
                this_$iv = LiveMapDiagnostics.access$getRegistry$p(LiveMapDiagnostics.this);
                $i$f$tryGetSingleton = false;
                if (this_$iv.containsEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DownloadingFragmentsComponent.class))) {
                    this_$iv$iv = this_$iv;
                    $i$f$getSingleton = false;
                    this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DownloadingFragmentsComponent.class));
                    $i$f$getComponent = false;
                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    $i$f$get = false;
                    v0 = (DownloadingFragmentsComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(DownloadingFragmentsComponent.class));
                    if (v0 == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(DownloadingFragmentsComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    v0 = null;
                }
                if ((var2_12 = (DownloadingFragmentsComponent)v0) == null) ** GOTO lbl-1000
                it = var2_12;
                $i$a$-let-Diagnostics$LiveMapDiagnostics$DownloadingFragmentsDiagnostic$update$counts$1 = false;
                v1 = new StringBuilder().append("D: ").append(it.getDownloading().size()).append(" Q: ");
                v2 = it.getQueue().values();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-values>(...)");
                var7_5 = v2;
                var8_7 = v1;
                var9_9 = 0;
                for (T var11_13 : var7_5) {
                    var12_14 = (Set)var11_13;
                    var13_15 = var9_9;
                    $i$a$-sumOfInt-Diagnostics$LiveMapDiagnostics$DownloadingFragmentsDiagnostic$update$counts$1$1 = false;
                    var15_17 = p0.size();
                    var9_9 = var13_15 + var15_17;
                }
                var13_15 = var9_9;
                var3_1 = var8_7.append(var13_15).toString();
                if (var3_1 != null) {
                    v3 = var3_1;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = "D: 0 Q: 0";
                }
                counts = v3;
                LiveMapDiagnostics.access$getDebugService$p(LiveMapDiagnostics.this).setValue("downloading_fragments", "Downloading fragments: " + counts);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$DownloadingTilesDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        public final class DownloadingTilesDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                int vector2 = SequencesKt.count((Sequence)SequencesKt.filter(LiveMapDiagnostics.this.registry.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(TileLoadingSystem.TileResponseComponent.class)), (Function1)update.vector.1.INSTANCE));
                int raster2 = SequencesKt.count((Sequence)SequencesKt.filter(LiveMapDiagnostics.this.registry.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(RasterTileLoadingSystem.HttpTileResponseComponent.class)), (Function1)update.raster.1.INSTANCE));
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.DOWNLOADING_TILES, "Downloading tiles: V: " + vector2 + ", R: " + raster2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$FragmentsCacheDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        @SourceDebugExtension(value={"SMAP\nDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$FragmentsCacheDiagnostic\n+ 2 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,252:1\n144#2,2:253\n141#2:255\n147#2:259\n68#3:256\n24#3,2:257\n*S KotlinDebug\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$FragmentsCacheDiagnostic\n*L\n175#1:253,2\n175#1:255\n175#1:259\n175#1:256\n175#1:257,2\n*E\n"})
        public final class FragmentsCacheDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                Object object;
                EcsComponent ecsComponent;
                EcsComponentManager this_$iv = LiveMapDiagnostics.this.registry;
                boolean $i$f$tryGetSingleton = false;
                if (this_$iv.containsEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CachedFragmentsComponent.class))) {
                    EcsComponentManager this_$iv$iv = this_$iv;
                    boolean $i$f$getSingleton = false;
                    EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CachedFragmentsComponent.class));
                    boolean $i$f$getComponent = false;
                    EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$get = false;
                    ecsComponent = (CachedFragmentsComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(CachedFragmentsComponent.class));
                    if (ecsComponent == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CachedFragmentsComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    ecsComponent = null;
                }
                int size = (object = (CachedFragmentsComponent)ecsComponent) != null && (object = ((CachedFragmentsComponent)object).keys()) != null ? object.size() : 0;
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.FRAGMENTS_CACHE, "Fragments cache: " + size);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$FreezingSystemDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "freezeTime", "", "message", "", "timeToShow", "", "timeToShowLeft", "", "update", "", "livemap"})
        public final class FreezingSystemDiagnostic
        implements Diagnostic {
            private long timeToShowLeft;
            private double freezeTime;
            @NotNull
            private String message = "";
            private final int timeToShow;

            public FreezingSystemDiagnostic() {
                this.timeToShow = 7000;
            }

            @Override
            public void update() {
                if (LiveMapDiagnostics.this.getSlowestSystemTime() > 16.0) {
                    if (LiveMapDiagnostics.this.getSlowestSystemTime() > this.freezeTime) {
                        this.timeToShowLeft = this.timeToShow;
                        this.message = "Freezed by: " + LiveMapDiagnostics.this.formatDouble(LiveMapDiagnostics.this.getSlowestSystemTime(), 1) + ' ' + LiveMapDiagnostics.this.getSlowestSystemType();
                        this.freezeTime = LiveMapDiagnostics.this.getSlowestSystemTime();
                    }
                } else if (this.timeToShowLeft > 0L) {
                    this.timeToShowLeft -= LiveMapDiagnostics.this.deltaTime;
                } else if (this.timeToShowLeft < 0L) {
                    this.message = "";
                    this.timeToShowLeft = 0L;
                    this.freezeTime = 0.0;
                }
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.FREEZING_SYSTEM, this.message);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$IsLoadingDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "isLoading", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;)V", "update", "", "livemap"})
        public final class IsLoadingDiagnostic
        implements Diagnostic {
            @NotNull
            private final Property<Boolean> isLoading;

            public IsLoadingDiagnostic(Property<Boolean> isLoading2) {
                Intrinsics.checkNotNullParameter(isLoading2, (String)"isLoading");
                this.isLoading = isLoading2;
            }

            @Override
            public void update() {
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.IS_LOADING, "Is loading: " + (Boolean)this.isLoading.get());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$SchedulerSystemDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        @SourceDebugExtension(value={"SMAP\nDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$SchedulerSystemDiagnostic\n+ 2 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n*L\n1#1,252:1\n150#2:253\n*S KotlinDebug\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$SchedulerSystemDiagnostic\n*L\n167#1:253\n*E\n"})
        public final class SchedulerSystemDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                EcsComponentManager this_$iv = LiveMapDiagnostics.this.registry;
                boolean $i$f$count = false;
                int tasksCount = this_$iv.count((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(MicroThreadComponent.class));
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.SCHEDULER_SYSTEM, "Micro threads: " + tasksCount + ", " + LiveMapDiagnostics.this.schedulerSystem.getLoading());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$SlowestSystemDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        public final class SlowestSystemDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.SLOWEST_SYSTEM, "Slowest update: " + (LiveMapDiagnostics.this.getSlowestSystemTime() > 2.0 ? LiveMapDiagnostics.this.formatDouble(LiveMapDiagnostics.this.getSlowestSystemTime(), 1) + ' ' + LiveMapDiagnostics.this.getSlowestSystemType() : "-"));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$StreamingFragmentsDiagnostic;", "Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$Diagnostic;", "(Lorg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics;)V", "update", "", "livemap"})
        @SourceDebugExtension(value={"SMAP\nDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$StreamingFragmentsDiagnostic\n+ 2 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,252:1\n144#2,2:253\n141#2:255\n147#2:259\n68#3:256\n24#3,2:257\n*S KotlinDebug\n*F\n+ 1 Diagnostics.kt\norg/jetbrains/letsPlot/livemap/Diagnostics$LiveMapDiagnostics$StreamingFragmentsDiagnostic\n*L\n184#1:253,2\n184#1:255\n184#1:259\n184#1:256\n184#1:257,2\n*E\n"})
        public final class StreamingFragmentsDiagnostic
        implements Diagnostic {
            @Override
            public void update() {
                Object object;
                EcsComponent ecsComponent;
                EcsComponentManager this_$iv = LiveMapDiagnostics.this.registry;
                boolean $i$f$tryGetSingleton = false;
                if (this_$iv.containsEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(StreamingFragmentsComponent.class))) {
                    EcsComponentManager this_$iv$iv = this_$iv;
                    boolean $i$f$getSingleton = false;
                    EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(StreamingFragmentsComponent.class));
                    boolean $i$f$getComponent = false;
                    EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$get = false;
                    ecsComponent = (StreamingFragmentsComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(StreamingFragmentsComponent.class));
                    if (ecsComponent == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(StreamingFragmentsComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    ecsComponent = null;
                }
                int size = (object = (StreamingFragmentsComponent)ecsComponent) != null && (object = ((StreamingFragmentsComponent)object).keys()) != null ? object.size() : 0;
                LiveMapDiagnostics.this.debugService.setValue(LiveMapDiagnostics.STREAMING_FRAGMENTS, "Streaming fragments: " + size);
            }
        }
    }
}

