/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.intern.observable.event.SimpleEventSource;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.ValueProperty;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.canvas.AnimationProvider;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvas.CanvasControlUtil;
import org.jetbrains.letsPlot.core.canvas.CanvasProvider;
import org.jetbrains.letsPlot.core.canvas.DeltaTime;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.CoordinateKt;
import org.jetbrains.letsPlot.livemap.Diagnostics;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.FeatureLayerBuilder;
import org.jetbrains.letsPlot.livemap.chart.ChartElementScalingSystem;
import org.jetbrains.letsPlot.livemap.chart.GrowingPathEffect;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectDetectionSystem;
import org.jetbrains.letsPlot.livemap.chart.SearchResultComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentDownloadingSystem;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentEmitSystem;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentProvider;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentUpdateSystem;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentsRemovingSystem;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionEmitSystem;
import org.jetbrains.letsPlot.livemap.config.DevParams;
import org.jetbrains.letsPlot.livemap.core.MapRuler;
import org.jetbrains.letsPlot.livemap.core.MetricsService;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationObjectSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsController;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.graphics.GraphicsService;
import org.jetbrains.letsPlot.livemap.core.graphics.Rectangle;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;
import org.jetbrains.letsPlot.livemap.core.graphics.TextMeasurer;
import org.jetbrains.letsPlot.livemap.core.input.ClickableComponent;
import org.jetbrains.letsPlot.livemap.core.input.CursorStyleSystem;
import org.jetbrains.letsPlot.livemap.core.input.EventListenerComponent;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputDetectionSystem;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputSystem;
import org.jetbrains.letsPlot.livemap.core.layers.LayerKind;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.LayersRenderingSystem;
import org.jetbrains.letsPlot.livemap.core.layers.OffscreenLayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.RenderTarget;
import org.jetbrains.letsPlot.livemap.core.layers.ScreenLayerManager;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskCooperativeExecutor;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskExecutor;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskMultiThreadedExecutorFactory;
import org.jetbrains.letsPlot.livemap.core.multitasking.SchedulerSystem;
import org.jetbrains.letsPlot.livemap.geocoding.ApplyPointSystem;
import org.jetbrains.letsPlot.livemap.geocoding.LocationCalculateSystem;
import org.jetbrains.letsPlot.livemap.geocoding.LocationCounterSystem;
import org.jetbrains.letsPlot.livemap.geocoding.MapLocationInitializationSystem;
import org.jetbrains.letsPlot.livemap.makegeometrywidget.MakeGeometryWidgetSystem;
import org.jetbrains.letsPlot.livemap.mapengine.LayerEntitiesComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.MapEntitiesRenderingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.MapRenderContext;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellLoadingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellsRemovingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerKind;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileSystemProvider;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.DebugCellLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.debug.DebugDataSystem;
import org.jetbrains.letsPlot.livemap.mapengine.camera.Camera;
import org.jetbrains.letsPlot.livemap.mapengine.camera.CameraComponent;
import org.jetbrains.letsPlot.livemap.mapengine.camera.CameraInputSystem;
import org.jetbrains.letsPlot.livemap.mapengine.camera.CameraScale;
import org.jetbrains.letsPlot.livemap.mapengine.camera.MutableCamera;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOrigin2ScreenUpdateSystem;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportGridUpdateSystem;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportPositionUpdateSystem;
import org.jetbrains.letsPlot.livemap.ui.CursorService;
import org.jetbrains.letsPlot.livemap.ui.LiveMapUiSystem;
import org.jetbrains.letsPlot.livemap.ui.ResourceManager;
import org.jetbrains.letsPlot.livemap.ui.UiEntitiesRenderingSystem;
import org.jetbrains.letsPlot.livemap.ui.UiService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001PB\u00a8\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001d\u0010\t\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e0\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0014\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0019\u0018\u00010\u0018\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u001a\u0010@\u001a\u00020<2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\r0\u000bJ\u0010\u0010B\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020\rH\u0016J\u000e\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020HJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\nJ\u0010\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020*H\u0002J\u0010\u0010M\u001a\u00020\r2\u0006\u0010L\u001a\u00020*H\u0002J\u0010\u0010N\u001a\u00020\r2\u0006\u0010L\u001a\u00020*H\u0002J\u0010\u0010O\u001a\u00020\r2\u0006\u0010L\u001a\u00020*H\u0002R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010(R%\u0010\t\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0019\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010?R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/letsPlot/livemap/LiveMap;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "myMapRuler", "Lorg/jetbrains/letsPlot/livemap/core/MapRuler;", "Lorg/jetbrains/letsPlot/livemap/World;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "viewport", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "layers", "", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/livemap/api/FeatureLayerBuilder;", "", "Lkotlin/ExtensionFunctionType;", "myBasemapTileSystemProvider", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;", "myFragmentProvider", "Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider;", "myDevParams", "Lorg/jetbrains/letsPlot/livemap/config/DevParams;", "myMapLocationConsumer", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "myMapLocationRect", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "myZoom", "", "myAttribution", "", "myShowCoordPickTools", "", "myCursorService", "Lorg/jetbrains/letsPlot/livemap/ui/CursorService;", "(Lorg/jetbrains/letsPlot/livemap/core/MapRuler;Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;Ljava/util/List;Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider;Lorg/jetbrains/letsPlot/livemap/config/DevParams;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/commons/intern/async/Async;Ljava/lang/Integer;Ljava/lang/String;ZLorg/jetbrains/letsPlot/livemap/ui/CursorService;)V", "errorEvent", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/SimpleEventSource;", "", "isLoading", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "()Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "myComponentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myContext", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "myDiagnostics", "Lorg/jetbrains/letsPlot/livemap/Diagnostics;", "myEcsController", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsController;", "myLayerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "myLayerRenderingSystem", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayersRenderingSystem;", "myRenderTarget", "Lorg/jetbrains/letsPlot/livemap/core/layers/RenderTarget;", "mySchedulerSystem", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/SchedulerSystem;", "myTextMeasurer", "Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;", "myTimerReg", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "myUiService", "Lorg/jetbrains/letsPlot/livemap/ui/UiService;", "Ljava/lang/Integer;", "addErrorHandler", "handler", "animationHandler", "dt", "", "dispose", "draw", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "hoverObjects", "Lorg/jetbrains/letsPlot/livemap/chart/HoverObject;", "init", "componentManager", "initCamera", "initLayers", "initSystems", "UpdateController", "livemap"})
@SourceDebugExtension(value={"SMAP\nLiveMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMap.kt\norg/jetbrains/letsPlot/livemap/LiveMap\n+ 2 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n144#2,2:367\n141#2:369\n147#2:373\n125#2:374\n68#3:370\n24#3,2:371\n1855#4,2:375\n*S KotlinDebug\n*F\n+ 1 LiveMap.kt\norg/jetbrains/letsPlot/livemap/LiveMap\n*L\n149#1:367,2\n149#1:369\n149#1:373\n261#1:374\n149#1:370\n149#1:371,2\n309#1:375,2\n*E\n"})
public final class LiveMap
implements Disposable {
    @NotNull
    private final MapRuler<World> myMapRuler;
    @NotNull
    private final MapProjection myMapProjection;
    @NotNull
    private final Viewport viewport;
    @NotNull
    private final List<Function1<FeatureLayerBuilder, Unit>> layers;
    @NotNull
    private final BasemapTileSystemProvider myBasemapTileSystemProvider;
    @NotNull
    private final FragmentProvider myFragmentProvider;
    @NotNull
    private final DevParams myDevParams;
    @NotNull
    private final Function1<DoubleRectangle, Unit> myMapLocationConsumer;
    @Nullable
    private final Async<Rect<World>> myMapLocationRect;
    @Nullable
    private final Integer myZoom;
    @Nullable
    private final String myAttribution;
    private final boolean myShowCoordPickTools;
    @NotNull
    private final CursorService myCursorService;
    @NotNull
    private final RenderTarget myRenderTarget;
    @NotNull
    private Registration myTimerReg;
    private EcsController myEcsController;
    private LiveMapContext myContext;
    private LayersRenderingSystem myLayerRenderingSystem;
    private LayerManager myLayerManager;
    private Diagnostics myDiagnostics;
    private SchedulerSystem mySchedulerSystem;
    private UiService myUiService;
    private TextMeasurer myTextMeasurer;
    @NotNull
    private final SimpleEventSource<Throwable> errorEvent;
    @NotNull
    private final Property<Boolean> isLoading;
    @NotNull
    private final EcsComponentManager myComponentManager;

    public LiveMap(@NotNull MapRuler<World> myMapRuler, @NotNull MapProjection myMapProjection, @NotNull Viewport viewport, @NotNull List<? extends Function1<? super FeatureLayerBuilder, Unit>> layers, @NotNull BasemapTileSystemProvider myBasemapTileSystemProvider, @NotNull FragmentProvider myFragmentProvider, @NotNull DevParams myDevParams, @NotNull Function1<? super DoubleRectangle, Unit> myMapLocationConsumer, @Nullable Async<Rect<World>> myMapLocationRect, @Nullable Integer myZoom, @Nullable String myAttribution, boolean myShowCoordPickTools, @NotNull CursorService myCursorService) {
        Intrinsics.checkNotNullParameter(myMapRuler, (String)"myMapRuler");
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        Intrinsics.checkNotNullParameter((Object)myBasemapTileSystemProvider, (String)"myBasemapTileSystemProvider");
        Intrinsics.checkNotNullParameter((Object)myFragmentProvider, (String)"myFragmentProvider");
        Intrinsics.checkNotNullParameter((Object)myDevParams, (String)"myDevParams");
        Intrinsics.checkNotNullParameter(myMapLocationConsumer, (String)"myMapLocationConsumer");
        Intrinsics.checkNotNullParameter((Object)myCursorService, (String)"myCursorService");
        this.myMapRuler = myMapRuler;
        this.myMapProjection = myMapProjection;
        this.viewport = viewport;
        this.layers = layers;
        this.myBasemapTileSystemProvider = myBasemapTileSystemProvider;
        this.myFragmentProvider = myFragmentProvider;
        this.myDevParams = myDevParams;
        this.myMapLocationConsumer = myMapLocationConsumer;
        this.myMapLocationRect = myMapLocationRect;
        this.myZoom = myZoom;
        this.myAttribution = myAttribution;
        this.myShowCoordPickTools = myShowCoordPickTools;
        this.myCursorService = myCursorService;
        this.myRenderTarget = this.myDevParams.read(DevParams.Companion.getRENDER_TARGET());
        this.myTimerReg = Registration.Companion.getEMPTY();
        this.errorEvent = new SimpleEventSource();
        this.isLoading = (Property)new ValueProperty((Object)true);
        this.myComponentManager = new EcsComponentManager();
    }

    @NotNull
    public final Property<Boolean> isLoading() {
        return this.isLoading;
    }

    @NotNull
    public final Registration addErrorHandler(@NotNull Function1<? super Throwable, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.errorEvent.addHandler((EventHandler)new EventHandler<Throwable>(handler){
            final /* synthetic */ Function1<Throwable, Unit> $handler;
            {
                this.$handler = $handler;
            }

            public void onEvent(@NotNull Throwable event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$handler.invoke((Object)event);
            }
        });
    }

    public final void draw(@NotNull CanvasControl canvasControl) {
        TextMeasurer textMeasurer;
        LiveMapContext liveMapContext;
        LayerManager layerManager;
        MutableCamera mutableCamera;
        Intrinsics.checkNotNullParameter((Object)canvasControl, (String)"canvasControl");
        MutableCamera $this$draw_u24lambda_u240 = mutableCamera = new MutableCamera(this.myComponentManager);
        boolean bl = false;
        $this$draw_u24lambda_u240.requestZoom(this.viewport.getZoom());
        $this$draw_u24lambda_u240.requestPosition(this.viewport.getPosition());
        MutableCamera camera2 = mutableCamera;
        switch (WhenMappings.$EnumSwitchMapping$0[this.myRenderTarget.ordinal()]) {
            case 1: {
                layerManager = new OffscreenLayerManager(canvasControl);
                break;
            }
            case 2: {
                layerManager = new ScreenLayerManager(canvasControl);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.myLayerManager = layerManager;
        MouseEventSource mouseEventSource = (MouseEventSource)canvasControl;
        MapRenderContext mapRenderContext = new MapRenderContext(this.viewport, (CanvasProvider)canvasControl);
        Function1 function1 = (Function1)new Function1<Throwable, Unit>(canvasControl, this){
            final /* synthetic */ CanvasControl $canvasControl;
            final /* synthetic */ LiveMap this$0;
            {
                this.$canvasControl = $canvasControl;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$canvasControl.schedule((Function0)new Function0<Unit>(this.this$0, it){
                    final /* synthetic */ LiveMap this$0;
                    final /* synthetic */ Throwable $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        LiveMap.access$getErrorEvent$p(this.this$0).fire((Object)this.$it);
                    }
                });
            }
        };
        Camera camera3 = camera2;
        LayerManager layerManager2 = this.myLayerManager;
        if (layerManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
            layerManager2 = null;
        }
        if ((liveMapContext = (this.myContext = new LiveMapContext(this.myMapProjection, mouseEventSource, mapRenderContext, (Function1<? super Throwable, Unit>)function1, camera3, layerManager2))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
            liveMapContext = null;
        }
        if ((textMeasurer = (this.myTextMeasurer = new TextMeasurer(liveMapContext.getMapRenderContext().getCanvasProvider().createCanvas(Vector.Companion.getZERO()).getContext2d()))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTextMeasurer");
            textMeasurer = null;
        }
        this.myUiService = new UiService(this.myComponentManager, textMeasurer);
        this.init(this.myComponentManager);
        UpdateController updateController2 = new UpdateController((Function1<? super Long, Boolean>)((Function1)new Function1<Long, Boolean>(this){
            final /* synthetic */ LiveMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long dt) {
                return LiveMap.access$animationHandler(this.this$0, dt);
            }
        }), this.myDevParams.read(DevParams.Companion.getUPDATE_PAUSE_MS()), this.myDevParams.read(DevParams.Companion.getUPDATE_TIME_MULTIPLIER()));
        this.myTimerReg = CanvasControlUtil.INSTANCE.setAnimationHandler(canvasControl, AnimationProvider.AnimationEventHandler.Companion.toHandler((Function1)new Function1<Long, Boolean>((Object)updateController2){

            @NotNull
            public final Boolean invoke(long p0) {
                return ((UpdateController)this.receiver).onTime(p0);
            }
        }));
    }

    @NotNull
    public final List<HoverObject> hoverObjects() {
        Object object;
        EcsComponent ecsComponent;
        EcsComponentManager this_$iv = this.myComponentManager;
        boolean $i$f$tryGetSingleton = false;
        if (this_$iv.containsEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(SearchResultComponent.class))) {
            EcsComponentManager this_$iv$iv = this_$iv;
            boolean $i$f$getSingleton = false;
            EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(SearchResultComponent.class));
            boolean $i$f$getComponent = false;
            EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
            boolean $i$f$get = false;
            ecsComponent = (SearchResultComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(SearchResultComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(SearchResultComponent.class).getSimpleName() + " is not found");
            }
        } else {
            ecsComponent = null;
        }
        if ((object = (SearchResultComponent)ecsComponent) == null || (object = ((SearchResultComponent)object).getHoverObjects()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final boolean animationHandler(long dt) {
        EcsController ecsController = this.myEcsController;
        if (ecsController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEcsController");
            ecsController = null;
        }
        ecsController.update(dt);
        Diagnostics diagnostics = this.myDiagnostics;
        if (diagnostics == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDiagnostics");
            diagnostics = null;
        }
        diagnostics.update(dt);
        LayersRenderingSystem layersRenderingSystem = this.myLayerRenderingSystem;
        if (layersRenderingSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerRenderingSystem");
            layersRenderingSystem = null;
        }
        return layersRenderingSystem.getUpdated();
    }

    private final void init(EcsComponentManager componentManager) {
        Diagnostics diagnostics;
        this.initLayers(componentManager);
        this.initSystems(componentManager);
        this.initCamera(componentManager);
        if (this.myDevParams.isSet(DevParams.Companion.getPERF_STATS())) {
            LiveMapContext liveMapContext;
            LayersRenderingSystem layersRenderingSystem = this.myLayerRenderingSystem;
            if (layersRenderingSystem == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerRenderingSystem");
                layersRenderingSystem = null;
            }
            List<Integer> list = layersRenderingSystem.getDirtyLayers();
            SchedulerSystem schedulerSystem = this.mySchedulerSystem;
            if (schedulerSystem == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mySchedulerSystem");
                schedulerSystem = null;
            }
            if ((liveMapContext = this.myContext) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
                liveMapContext = null;
            }
            MetricsService metricsService = liveMapContext.getMetricsService();
            UiService uiService = this.myUiService;
            if (uiService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myUiService");
                uiService = null;
            }
            GraphicsService graphicsService = uiService;
            LayerManager layerManager = this.myLayerManager;
            if (layerManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                layerManager = null;
            }
            diagnostics = new Diagnostics.LiveMapDiagnostics(this.isLoading, list, schedulerSystem, metricsService, graphicsService, componentManager, layerManager);
        } else {
            diagnostics = new Diagnostics();
        }
        this.myDiagnostics = diagnostics;
    }

    private final void initSystems(EcsComponentManager componentManager) {
        SchedulerSystem schedulerSystem;
        LiveMapContext liveMapContext;
        LayerManager layerManager;
        MicroTaskExecutor microTaskExecutor;
        MicroTaskExecutor microTaskExecutor2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.myDevParams.read(DevParams.Companion.getMICRO_TASK_EXECUTOR()).ordinal()]) {
            case 1: {
                LiveMapContext liveMapContext2 = this.myContext;
                if (liveMapContext2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
                    liveMapContext2 = null;
                }
                microTaskExecutor2 = new MicroTaskCooperativeExecutor(liveMapContext2, this.myDevParams.read(DevParams.Companion.getCOMPUTATION_FRAME_TIME()));
                break;
            }
            case 2: 
            case 3: {
                microTaskExecutor2 = MicroTaskMultiThreadedExecutorFactory.Companion.create();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MicroTaskExecutor microTaskExecutor3 = microTaskExecutor2;
        if (microTaskExecutor2 == null) {
            LiveMapContext liveMapContext3 = this.myContext;
            if (liveMapContext3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
                liveMapContext3 = null;
            }
            microTaskExecutor3 = microTaskExecutor = (MicroTaskExecutor)new MicroTaskCooperativeExecutor(liveMapContext3, this.myDevParams.read(DevParams.Companion.getCOMPUTATION_FRAME_TIME()));
        }
        if ((layerManager = this.myLayerManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
            layerManager = null;
        }
        this.myLayerRenderingSystem = new LayersRenderingSystem(componentManager, layerManager);
        this.mySchedulerSystem = new SchedulerSystem(microTaskExecutor, componentManager);
        LiveMapContext liveMapContext4 = this.myContext;
        if (liveMapContext4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
            liveMapContext4 = null;
        }
        EcsContext ecsContext = liveMapContext4;
        Object[] objectArray = new AbstractSystem[32];
        objectArray[0] = new MouseInputSystem(componentManager);
        LayerManager layerManager2 = this.myLayerManager;
        if (layerManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
            layerManager2 = null;
        }
        objectArray[1] = new MouseInputDetectionSystem(componentManager, layerManager2);
        objectArray[2] = new CameraInputSystem(componentManager);
        objectArray[3] = new CursorStyleSystem(componentManager, this.myCursorService);
        objectArray[4] = new MakeGeometryWidgetSystem(componentManager, this.myMapProjection, this.viewport);
        objectArray[5] = new LocationCounterSystem(componentManager, this.myMapLocationRect == null);
        objectArray[6] = new LocationCalculateSystem(this.myMapRuler, this.myMapProjection, componentManager);
        Integer n = this.myZoom;
        objectArray[7] = new MapLocationInitializationSystem(componentManager, n != null ? Double.valueOf(n.intValue()) : null, this.myMapLocationRect);
        objectArray[8] = new ApplyPointSystem(componentManager);
        objectArray[9] = new AnimationObjectSystem(componentManager);
        objectArray[10] = new AnimationSystem(componentManager);
        objectArray[11] = new ViewportPositionUpdateSystem(componentManager);
        objectArray[12] = new ViewportGridUpdateSystem(componentManager);
        UiService uiService = this.myUiService;
        if (uiService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myUiService");
            uiService = null;
        }
        if ((liveMapContext = this.myContext) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myContext");
            liveMapContext = null;
        }
        ResourceManager resourceManager = new ResourceManager(liveMapContext.getMapRenderContext().getCanvasProvider());
        LayerManager layerManager3 = this.myLayerManager;
        if (layerManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
            layerManager3 = null;
        }
        objectArray[13] = new LiveMapUiSystem(uiService, resourceManager, componentManager, this.myMapLocationConsumer, layerManager3, this.myAttribution, this.myShowCoordPickTools, this.myDevParams.isSet(DevParams.Companion.getSHOW_RESET_POSITION_ACTION()));
        objectArray[14] = new BasemapCellLoadingSystem(componentManager);
        objectArray[15] = this.myBasemapTileSystemProvider.create(componentManager);
        objectArray[16] = new BasemapCellsRemovingSystem(this.myDevParams.read(DevParams.Companion.getTILE_CACHE_LIMIT()), componentManager);
        objectArray[17] = new DebugDataSystem(componentManager);
        objectArray[18] = new FragmentUpdateSystem(componentManager);
        objectArray[19] = new FragmentDownloadingSystem(this.myDevParams.read(DevParams.Companion.getFRAGMENT_ACTIVE_DOWNLOADS_LIMIT()), this.myFragmentProvider, componentManager);
        objectArray[20] = new FragmentEmitSystem(this.myDevParams.read(DevParams.Companion.getCOMPUTATION_PROJECTION_QUANT()), componentManager);
        objectArray[21] = new RegionEmitSystem(componentManager);
        objectArray[22] = new FragmentsRemovingSystem(this.myDevParams.read(DevParams.Companion.getFRAGMENT_CACHE_LIMIT()), componentManager);
        objectArray[23] = new WorldOrigin2ScreenUpdateSystem(componentManager);
        UiService uiService2 = this.myUiService;
        if (uiService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myUiService");
            uiService2 = null;
        }
        objectArray[24] = new HoverObjectDetectionSystem(uiService2, componentManager);
        objectArray[25] = new ChartElementScalingSystem(componentManager);
        objectArray[26] = new MapEntitiesRenderingSystem(componentManager);
        objectArray[27] = new UiEntitiesRenderingSystem(componentManager);
        AbstractSystem abstractSystem = this.myLayerRenderingSystem;
        if (abstractSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerRenderingSystem");
            abstractSystem = objectArray[28] = null;
        }
        if ((schedulerSystem = this.mySchedulerSystem) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mySchedulerSystem");
            schedulerSystem = null;
        }
        objectArray[29] = schedulerSystem;
        objectArray[30] = new GrowingPathEffect.GrowingPathEffectSystem(componentManager);
        objectArray[31] = new CameraScale.CameraScaleEffectSystem(componentManager);
        this.myEcsController = new EcsController(componentManager, ecsContext, CollectionsKt.listOf((Object[])objectArray));
    }

    private final void initCamera(EcsComponentManager componentManager) {
        EventListenerComponent listeners = new EventListenerComponent();
        EcsComponentManager this_$iv = componentManager;
        boolean $i$f$getSingletonEntity = false;
        EcsEntity camera2 = EcsEntityKt.addComponents(this_$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CameraComponent.class)), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(listeners, this){
            final /* synthetic */ EventListenerComponent $listeners;
            final /* synthetic */ LiveMap this$0;
            {
                this.$listeners = $listeners;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                Rectangle rectangle = new Rectangle();
                LiveMap liveMap = this.this$0;
                Rectangle rectangle2 = rectangle;
                ComponentsList componentsList = $this$addComponents;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setOrigin(FunctionsKt.toDoubleVector(Client.Companion.getZERO_VEC()));
                $this$invoke_u24lambda_u240.setDimension(FunctionsKt.toDoubleVector(LiveMap.access$getViewport$p(liveMap).getSize()));
                RenderBox renderBox = rectangle;
                componentsList.unaryPlus(new ClickableComponent(renderBox));
                $this$addComponents.unaryPlus(this.$listeners);
            }
        }));
        listeners.addDoubleClickListener((Function1<? super InputMouseEvent, Unit>)((Function1)new Function1<InputMouseEvent, Unit>(camera2, this){
            final /* synthetic */ EcsEntity $camera;
            final /* synthetic */ LiveMap this$0;
            {
                this.$camera = $camera;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InputMouseEvent clickEvent) {
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)clickEvent, (String)"clickEvent");
                        EcsEntity this_$iv = this.$camera;
                        boolean $i$f$contains = false;
                        if (this_$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CameraScale.CameraScaleEffectComponent.class))) break block4;
                        this_$iv = this.$camera;
                        boolean $i$f$getComponent = false;
                        EcsEntity this_$iv$iv = this_$iv;
                        boolean $i$f$get = false;
                        EcsComponent ecsComponent = (CameraComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(CameraComponent.class));
                        if (ecsComponent == null) {
                            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CameraComponent.class).getSimpleName() + " is not found");
                        }
                        if (!(((CameraComponent)ecsComponent).getZoom() == (double)LiveMap.access$getViewport$p(this.this$0).getMaxZoom())) break block5;
                    }
                    return;
                }
                Vec<Client> location = CoordinateKt.toClientPoint(clickEvent.getLocation());
                Vec<World> newViewportPosition = LiveMap.access$getViewport$p(this.this$0).getMapCoord((Vec<? extends Client>)VecKt.div((Vec)VecKt.plus(location, LiveMap.access$getViewport$p(this.this$0).getCenter()), (double)2.0));
                CameraScale.INSTANCE.setAnimation(this.$camera, location, newViewportPosition, 1.0);
            }
        }));
    }

    private final void initLayers(EcsComponentManager componentManager) {
        TextMeasurer textMeasurer;
        LayerManager layerManager;
        if (this.myBasemapTileSystemProvider.isVector()) {
            EcsEntityKt.addComponents(componentManager.createEntity("vector_layer_ground"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
                final /* synthetic */ LiveMap this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new BasemapLayerComponent(BasemapLayerKind.WORLD));
                    $this$addComponents.unaryPlus(new LayerEntitiesComponent());
                    LayerManager layerManager = LiveMap.access$getMyLayerManager$p(this.this$0);
                    if (layerManager == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                        layerManager = null;
                    }
                    $this$addComponents.unaryPlus(layerManager.addLayer("ground", LayerKind.BASEMAP_TILES));
                }
            }));
        } else {
            EcsEntityKt.addComponents(componentManager.createEntity("raster_layer_ground"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
                final /* synthetic */ LiveMap this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new BasemapLayerComponent(BasemapLayerKind.RASTER));
                    $this$addComponents.unaryPlus(new LayerEntitiesComponent());
                    LayerManager layerManager = LiveMap.access$getMyLayerManager$p(this.this$0);
                    if (layerManager == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                        layerManager = null;
                    }
                    $this$addComponents.unaryPlus(layerManager.addLayer("http_ground", LayerKind.BASEMAP_TILES));
                }
            }));
        }
        if ((layerManager = this.myLayerManager) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
            layerManager = null;
        }
        if ((textMeasurer = this.myTextMeasurer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTextMeasurer");
            textMeasurer = null;
        }
        FeatureLayerBuilder featureLayerBuilder = new FeatureLayerBuilder(componentManager, layerManager, this.myMapProjection, textMeasurer);
        Iterable $this$forEach$iv = this.layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 p0 = (Function1)element$iv;
            boolean $i$f$initLayers$apply = false;
            boolean bl = false;
            FeatureLayerBuilder featureLayerBuilder2 = featureLayerBuilder;
            p0.invoke((Object)featureLayerBuilder2);
        }
        if (this.myBasemapTileSystemProvider.isVector()) {
            EcsEntityKt.addComponents(componentManager.createEntity("vector_layer_labels"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
                final /* synthetic */ LiveMap this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new BasemapLayerComponent(BasemapLayerKind.LABEL));
                    $this$addComponents.unaryPlus(new LayerEntitiesComponent());
                    LayerManager layerManager = LiveMap.access$getMyLayerManager$p(this.this$0);
                    if (layerManager == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                        layerManager = null;
                    }
                    $this$addComponents.unaryPlus(layerManager.addLayer("labels", LayerKind.BASEMAP_LABELS));
                }
            }));
        }
        if (this.myDevParams.isSet(DevParams.Companion.getDEBUG_GRID())) {
            EcsEntityKt.addComponents(componentManager.createEntity("cell_layer_debug"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
                final /* synthetic */ LiveMap this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new BasemapLayerComponent(BasemapLayerKind.DEBUG));
                    $this$addComponents.unaryPlus(new DebugCellLayerComponent());
                    $this$addComponents.unaryPlus(new LayerEntitiesComponent());
                    LayerManager layerManager = LiveMap.access$getMyLayerManager$p(this.this$0);
                    if (layerManager == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                        layerManager = null;
                    }
                    $this$addComponents.unaryPlus(layerManager.addLayer("debug", LayerKind.BASEMAP_LABELS));
                }
            }));
        }
        EcsEntityKt.addComponents(componentManager.createEntity("layer_ui"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
            final /* synthetic */ LiveMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(new UiEntitiesRenderingSystem.UiLayerComponent());
                LayerManager layerManager = LiveMap.access$getMyLayerManager$p(this.this$0);
                if (layerManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myLayerManager");
                    layerManager = null;
                }
                $this$addComponents.unaryPlus(layerManager.addLayer("ui", LayerKind.UI));
            }
        }));
    }

    public void dispose() {
        this.myTimerReg.dispose();
        EcsController ecsController = this.myEcsController;
        if (ecsController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myEcsController");
            ecsController = null;
        }
        ecsController.dispose();
    }

    public static final /* synthetic */ SimpleEventSource access$getErrorEvent$p(LiveMap $this) {
        return $this.errorEvent;
    }

    public static final /* synthetic */ boolean access$animationHandler(LiveMap $this, long dt) {
        return $this.animationHandler(dt);
    }

    public static final /* synthetic */ Viewport access$getViewport$p(LiveMap $this) {
        return $this.viewport;
    }

    public static final /* synthetic */ LayerManager access$getMyLayerManager$p(LiveMap $this) {
        return $this.myLayerManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/livemap/LiveMap$UpdateController;", "", "timePredicate", "Lkotlin/Function1;", "", "", "skipTime", "animationMultiplier", "", "(Lkotlin/jvm/functions/Function1;JD)V", "currentTime", "deltaTime", "Lorg/jetbrains/letsPlot/core/canvas/DeltaTime;", "onTime", "millisTime", "livemap"})
    private static final class UpdateController {
        @NotNull
        private final Function1<Long, Boolean> timePredicate;
        private final long skipTime;
        private final double animationMultiplier;
        @NotNull
        private final DeltaTime deltaTime;
        private long currentTime;

        public UpdateController(@NotNull Function1<? super Long, Boolean> timePredicate, long skipTime, double animationMultiplier) {
            Intrinsics.checkNotNullParameter(timePredicate, (String)"timePredicate");
            this.timePredicate = timePredicate;
            this.skipTime = skipTime;
            this.animationMultiplier = animationMultiplier;
            this.deltaTime = new DeltaTime();
        }

        public final boolean onTime(long millisTime) {
            long dt = this.deltaTime.tick(millisTime);
            this.currentTime += dt;
            if (this.currentTime > this.skipTime) {
                this.currentTime = 0L;
                return (Boolean)this.timePredicate.invoke((Object)((long)((double)dt * this.animationMultiplier)));
            }
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenderTarget.values().length];
            try {
                nArray[RenderTarget.OWN_OFFSCREEN_CANVAS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderTarget.OWN_SCREEN_CANVAS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DevParams.MicroTaskExecutor.values().length];
            try {
                nArray[DevParams.MicroTaskExecutor.UI_THREAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevParams.MicroTaskExecutor.AUTO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevParams.MicroTaskExecutor.BACKGROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

