/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Scalar;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.ScalarKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00100\fj\u0002`\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/LiveMapLocation;", "", "myViewport", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "(Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;)V", "viewLonLatRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getViewLonLatRect", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "worldToLonLat", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLatPoint;", "worldCoord", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "Companion", "livemap"})
public final class LiveMapLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Viewport myViewport;
    @NotNull
    private final MapProjection myMapProjection;

    public LiveMapLocation(@NotNull Viewport myViewport, @NotNull MapProjection myMapProjection) {
        Intrinsics.checkNotNullParameter((Object)myViewport, (String)"myViewport");
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        this.myViewport = myViewport;
        this.myMapProjection = myMapProjection;
    }

    @Nullable
    public final DoubleRectangle getViewLonLatRect() {
        Rect<World> viewRect = this.myViewport.getWindow();
        Vec<LonLat> vec = this.worldToLonLat((Vec<? extends World>)viewRect.getOrigin());
        if (vec == null) {
            return null;
        }
        Vec<LonLat> nw = vec;
        Vec<LonLat> vec2 = this.worldToLonLat((Vec<? extends World>)VecKt.plus((Vec)viewRect.getOrigin(), (Vec)viewRect.getDimension()));
        if (vec2 == null) {
            return null;
        }
        Vec<LonLat> se = vec2;
        return new DoubleRectangle(nw.getX(), se.getY(), se.getX() - nw.getX(), nw.getY() - se.getY());
    }

    private final Vec<LonLat> worldToLonLat(Vec<? extends World> worldCoord) {
        Vec coord = null;
        Vec shift = null;
        Vec worldSize = this.myMapProjection.getMapRect().getDimension();
        if (worldCoord.getX() > worldSize.getX()) {
            shift = VecKt.explicitVec((double)360.0, (double)0.0);
            coord = VecKt.transform$default(worldCoord, (Function1)((Function1)new Function1<Scalar<? extends World>, Scalar<? extends World>>((Vec<? extends World>)worldSize){
                final /* synthetic */ Vec<World> $worldSize;
                {
                    this.$worldSize = $worldSize;
                    super(1);
                }

                public final double invoke-nwvo2uo(double it) {
                    return ScalarKt.minus-plX9Htw((double)it, (double)VecKt.getScalarX(this.$worldSize));
                }
            }), null, (int)2, null);
        } else if (worldCoord.getX() < 0.0) {
            shift = VecKt.explicitVec((double)-360.0, (double)0.0);
            coord = VecKt.transform$default((Vec)worldSize, (Function1)((Function1)new Function1<Scalar<? extends World>, Scalar<? extends World>>((Vec<? extends World>)worldSize){
                final /* synthetic */ Vec<World> $worldSize;
                {
                    this.$worldSize = $worldSize;
                    super(1);
                }

                public final double invoke-nwvo2uo(double it) {
                    return ScalarKt.plus-plX9Htw((double)it, (double)VecKt.getScalarX(this.$worldSize));
                }
            }), null, (int)2, null);
        } else {
            shift = VecKt.explicitVec((double)0.0, (double)0.0);
            coord = worldCoord;
        }
        Vec vec = (Vec)this.myMapProjection.invert(coord);
        if (vec == null) {
            return null;
        }
        Vec lonLatVec = vec;
        return VecKt.plus((Vec)shift, (Vec)lonLatVec);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/LiveMapLocation$Companion;", "", "()V", "getLocationString", "", "viewRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "round", "", "digits", "", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLocationString(@NotNull DoubleRectangle viewRect) {
            Intrinsics.checkNotNullParameter((Object)viewRect, (String)"viewRect");
            DoubleVector delta = viewRect.getDimension().mul(0.05);
            return "location = [" + this.round(viewRect.getLeft() + delta.getX(), 6) + ", " + this.round(viewRect.getTop() + delta.getY(), 6) + ", " + this.round(viewRect.getRight() - delta.getX(), 6) + ", " + this.round(viewRect.getBottom() - delta.getY(), 6) + ']';
        }

        private final double round(double $this$round, int digits) {
            double a = Math.pow(10.0, digits);
            return Math.rint($this$round * a) / a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

