/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.api;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.api.BuilderKt;
import org.jetbrains.letsPlot.livemap.api.FeatureEntityFactory;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.PanningPolicy;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.geocoding.LonLatComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LayerEntitiesComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0017J \u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u0017J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;", "", "layerEntity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "panningPointsMaxCount", "", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;I)V", "myCanvasLayerComponent", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayerComponent;", "myComponentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myLayerEntitiesComponent", "Lorg/jetbrains/letsPlot/livemap/mapengine/LayerEntitiesComponent;", "myParentLayerComponent", "Lorg/jetbrains/letsPlot/livemap/core/layers/ParentLayerComponent;", "pointsTotalCount", "createFeature", "name", "", "createStaticFeature", "point", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLatPoint;", "createStaticFeatureWithLocation", "incrementLayerPointsTotalCount", "", "pointsCount", "incrementLayerPointsTotalCount$livemap", "livemap"})
@SourceDebugExtension(value={"SMAP\nBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Builder.kt\norg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n24#2,2:257\n24#2,2:259\n1#3:261\n*S KotlinDebug\n*F\n+ 1 Builder.kt\norg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory\n*L\n196#1:257,2\n197#1:259,2\n*E\n"})
public final class FeatureEntityFactory {
    private final int panningPointsMaxCount;
    private int pointsTotalCount;
    @NotNull
    private final EcsComponentManager myComponentManager;
    @NotNull
    private final ParentLayerComponent myParentLayerComponent;
    @NotNull
    private final LayerEntitiesComponent myLayerEntitiesComponent;
    @NotNull
    private final CanvasLayerComponent myCanvasLayerComponent;

    public FeatureEntityFactory(@NotNull EcsEntity layerEntity2, int panningPointsMaxCount) {
        Intrinsics.checkNotNullParameter((Object)layerEntity2, (String)"layerEntity");
        this.panningPointsMaxCount = panningPointsMaxCount;
        this.myComponentManager = layerEntity2.getComponentManager();
        this.myParentLayerComponent = new ParentLayerComponent(layerEntity2.getId$livemap());
        EcsEntity this_$iv = layerEntity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (LayerEntitiesComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class).getSimpleName() + " is not found");
        }
        this.myLayerEntitiesComponent = (LayerEntitiesComponent)ecsComponent;
        this_$iv = layerEntity2;
        $i$f$get = false;
        EcsComponent ecsComponent2 = (CanvasLayerComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
        }
        this.myCanvasLayerComponent = (CanvasLayerComponent)ecsComponent2;
    }

    public final void incrementLayerPointsTotalCount$livemap(int pointsCount) {
        this.pointsTotalCount += pointsCount;
        if (this.pointsTotalCount > this.panningPointsMaxCount) {
            this.myCanvasLayerComponent.getCanvasLayer().setPanningPolicy(PanningPolicy.COPY);
        }
    }

    @NotNull
    public final EcsEntity createFeature(@NotNull String name) {
        EcsEntity ecsEntity;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        EcsEntity it = ecsEntity = BuilderKt.mapEntity(this.myComponentManager, this.myParentLayerComponent, name);
        boolean bl = false;
        this.myLayerEntitiesComponent.add(it.getId$livemap());
        return ecsEntity;
    }

    @NotNull
    public final EcsEntity createStaticFeatureWithLocation(@NotNull String name, @NotNull Vec<? extends LonLat> point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(point, (String)"point");
        return EcsEntityKt.addComponents(this.createStaticFeature(name, point), (Function1<? super ComponentsList, Unit>)((Function1)createStaticFeatureWithLocation.1.INSTANCE));
    }

    @NotNull
    public final EcsEntity createStaticFeature(@NotNull String name, @NotNull Vec<? extends LonLat> point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(point, (String)"point");
        return this.createFeature(name).add(new LonLatComponent(point));
    }
}

