/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.api;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Geometry;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.BuilderKt;
import org.jetbrains.letsPlot.livemap.api.FeatureEntityFactory;
import org.jetbrains.letsPlot.livemap.api.LineLayerBuilderKt;
import org.jetbrains.letsPlot.livemap.api.LiveMapDsl;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.LocatorComponent;
import org.jetbrains.letsPlot.livemap.chart.path.PathLocator;
import org.jetbrains.letsPlot.livemap.chart.path.PathRenderer;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geocoding.NeedCalculateLocationComponent;
import org.jetbrains.letsPlot.livemap.geocoding.NeedLocationComponent;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.RenderableComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldDimensionComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@LiveMapDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010 \"\u0004\b8\u0010\"\u00a8\u0006<"}, d2={"Lorg/jetbrains/letsPlot/livemap/api/LineEntityBuilder;", "", "factory", "Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;", "mapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "(Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;)V", "alphaScalingEnabled", "", "getAlphaScalingEnabled", "()Z", "setAlphaScalingEnabled", "(Z)V", "index", "", "getIndex", "()Ljava/lang/Integer;", "setIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "layerIndex", "getLayerIndex", "setLayerIndex", "lineDash", "", "", "getLineDash", "()Ljava/util/List;", "setLineDash", "(Ljava/util/List;)V", "lineDashOffset", "getLineDashOffset", "()D", "setLineDashOffset", "(D)V", "point", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getPoint", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "setPoint", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "sizeScalingRange", "Lkotlin/ranges/ClosedRange;", "getSizeScalingRange", "()Lkotlin/ranges/ClosedRange;", "setSizeScalingRange", "(Lkotlin/ranges/ClosedRange;)V", "strokeColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getStrokeColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setStrokeColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "build", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "horizontal", "livemap"})
@SourceDebugExtension(value={"SMAP\nLineLayerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineLayerBuilder.kt\norg/jetbrains/letsPlot/livemap/api/LineEntityBuilder\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n70#2:137\n70#2:139\n1#3:138\n1#3:140\n*S KotlinDebug\n*F\n+ 1 LineLayerBuilder.kt\norg/jetbrains/letsPlot/livemap/api/LineEntityBuilder\n*L\n106#1:137\n107#1:139\n106#1:138\n107#1:140\n*E\n"})
public final class LineEntityBuilder {
    @NotNull
    private final FeatureEntityFactory factory;
    @NotNull
    private final MapProjection mapProjection;
    @Nullable
    private ClosedRange<Integer> sizeScalingRange;
    private boolean alphaScalingEnabled;
    @Nullable
    private Integer layerIndex;
    @Nullable
    private Integer index;
    @Nullable
    private Vec<? extends LonLat> point;
    @NotNull
    private List<Double> lineDash;
    private double lineDashOffset;
    @NotNull
    private Color strokeColor;
    private double strokeWidth;

    public LineEntityBuilder(@NotNull FeatureEntityFactory factory, @NotNull MapProjection mapProjection) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mapProjection, (String)"mapProjection");
        this.factory = factory;
        this.mapProjection = mapProjection;
        this.lineDash = CollectionsKt.emptyList();
        this.strokeColor = Color.Companion.getBLACK();
        this.strokeWidth = 1.0;
    }

    @Nullable
    public final ClosedRange<Integer> getSizeScalingRange() {
        return this.sizeScalingRange;
    }

    public final void setSizeScalingRange(@Nullable ClosedRange<Integer> closedRange) {
        this.sizeScalingRange = closedRange;
    }

    public final boolean getAlphaScalingEnabled() {
        return this.alphaScalingEnabled;
    }

    public final void setAlphaScalingEnabled(boolean bl) {
        this.alphaScalingEnabled = bl;
    }

    @Nullable
    public final Integer getLayerIndex() {
        return this.layerIndex;
    }

    public final void setLayerIndex(@Nullable Integer n) {
        this.layerIndex = n;
    }

    @Nullable
    public final Integer getIndex() {
        return this.index;
    }

    public final void setIndex(@Nullable Integer n) {
        this.index = n;
    }

    @Nullable
    public final Vec<LonLat> getPoint() {
        return this.point;
    }

    public final void setPoint(@Nullable Vec<? extends LonLat> vec) {
        this.point = vec;
    }

    @NotNull
    public final List<Double> getLineDash() {
        return this.lineDash;
    }

    public final void setLineDash(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.lineDash = list;
    }

    public final double getLineDashOffset() {
        return this.lineDashOffset;
    }

    public final void setLineDashOffset(double d) {
        this.lineDashOffset = d;
    }

    @NotNull
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.strokeColor = color;
    }

    public final double getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(double d) {
        this.strokeWidth = d;
    }

    @NotNull
    public final EcsEntity build(boolean horizontal) {
        EcsEntity ecsEntity;
        if (this.point == null) {
            throw new IllegalStateException("Can't create line entity. Coord is null.".toString());
        }
        Vec<? extends LonLat> vec = this.point;
        Intrinsics.checkNotNull(vec);
        EcsEntity this_$iv = BuilderKt.setInitializer(this.factory.createStaticFeature("map_ent_s_line", vec), (Function2<? super ComponentsList, ? super Vec<? extends World>, Unit>)((Function2)new Function2<ComponentsList, Vec<? extends World>, Unit>(horizontal, this){
            final /* synthetic */ boolean $horizontal;
            final /* synthetic */ LineEntityBuilder this$0;
            {
                this.$horizontal = $horizontal;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$setInitializer, @NotNull Vec<? extends World> worldPoint) {
                void $this$invoke_u24lambda_u242;
                void $this$invoke_u24lambda_u241;
                Object $this$invoke_u24lambda_u240;
                EcsComponent ecsComponent;
                Intrinsics.checkNotNullParameter((Object)$this$setInitializer, (String)"$this$setInitializer");
                Intrinsics.checkNotNullParameter(worldPoint, (String)"worldPoint");
                LineString line = LineLayerBuilderKt.access$createLineGeometry(worldPoint, this.$horizontal, LineEntityBuilder.access$getMapProjection$p(this.this$0).getMapRect());
                Rect bbox = LineLayerBuilderKt.access$createLineBBox(worldPoint, this.this$0.getStrokeWidth(), this.$horizontal, LineEntityBuilder.access$getMapProjection$p(this.this$0).getMapRect());
                LineEntityBuilder.access$getFactory$p(this.this$0).incrementLayerPointsTotalCount$livemap(line.size());
                if (this.this$0.getLayerIndex() != null && this.this$0.getIndex() != null) {
                    Integer n = this.this$0.getLayerIndex();
                    Intrinsics.checkNotNull((Object)n);
                    int n2 = n;
                    Integer n3 = this.this$0.getIndex();
                    Intrinsics.checkNotNull((Object)n3);
                    $this$setInitializer.unaryPlus(new IndexComponent(n2, n3));
                }
                RenderableComponent renderableComponent = ecsComponent = new RenderableComponent();
                ComponentsList componentsList = $this$setInitializer;
                boolean $i$a$-apply-LineEntityBuilder$build$1$42 = false;
                ((RenderableComponent)$this$invoke_u24lambda_u240).setRenderer(new PathRenderer());
                componentsList.unaryPlus(ecsComponent);
                ecsComponent = new ChartElementComponent();
                $this$invoke_u24lambda_u240 = this.this$0;
                EcsComponent $i$a$-apply-LineEntityBuilder$build$1$42 = ecsComponent;
                componentsList = $this$setInitializer;
                boolean bl = false;
                $this$invoke_u24lambda_u241.setSizeScalingRange(((LineEntityBuilder)$this$invoke_u24lambda_u240).getSizeScalingRange());
                $this$invoke_u24lambda_u241.setAlphaScalingEnabled(((LineEntityBuilder)$this$invoke_u24lambda_u240).getAlphaScalingEnabled());
                $this$invoke_u24lambda_u241.setStrokeColor(((LineEntityBuilder)$this$invoke_u24lambda_u240).getStrokeColor());
                $this$invoke_u24lambda_u241.setStrokeWidth(((LineEntityBuilder)$this$invoke_u24lambda_u240).getStrokeWidth());
                $this$invoke_u24lambda_u241.setLineDash(CollectionsKt.toDoubleArray((Collection)((LineEntityBuilder)$this$invoke_u24lambda_u240).getLineDash()));
                $this$invoke_u24lambda_u241.setLineDashOffset(((LineEntityBuilder)$this$invoke_u24lambda_u240).getLineDashOffset());
                componentsList.unaryPlus(ecsComponent);
                $this$setInitializer.unaryPlus(new WorldOriginComponent((Vec<? extends World>)bbox.getOrigin()));
                ecsComponent = new WorldGeometryComponent();
                $this$invoke_u24lambda_u240 = ecsComponent;
                componentsList = $this$setInitializer;
                boolean bl2 = false;
                $this$invoke_u24lambda_u242.setGeometry((Geometry<World>)Geometry.Companion.of(line));
                componentsList.unaryPlus(ecsComponent);
                $this$setInitializer.unaryPlus(new WorldDimensionComponent((Vec<? extends World>)bbox.getDimension()));
                $this$setInitializer.unaryPlus(new LocatorComponent(PathLocator.INSTANCE));
            }
        }));
        boolean $i$f$remove = false;
        EcsEntity $this$remove_u24lambda_u242$iv = ecsEntity = this_$iv;
        boolean bl = false;
        $this$remove_u24lambda_u242$iv.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(NeedLocationComponent.class));
        this_$iv = ecsEntity;
        $i$f$remove = false;
        $this$remove_u24lambda_u242$iv = ecsEntity = this_$iv;
        bl = false;
        $this$remove_u24lambda_u242$iv.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(NeedCalculateLocationComponent.class));
        return ecsEntity;
    }

    public static final /* synthetic */ MapProjection access$getMapProjection$p(LineEntityBuilder $this) {
        return $this.mapProjection;
    }

    public static final /* synthetic */ FeatureEntityFactory access$getFactory$p(LineEntityBuilder $this) {
        return $this.factory;
    }
}

