/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.api;

import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.gis.geoprotocol.GeocodingService;
import org.jetbrains.letsPlot.livemap.CoordinateKt;
import org.jetbrains.letsPlot.livemap.LiveMap;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.FeatureLayerBuilder;
import org.jetbrains.letsPlot.livemap.api.LiveMapBuilder;
import org.jetbrains.letsPlot.livemap.api.LiveMapDsl;
import org.jetbrains.letsPlot.livemap.api.MapLocation;
import org.jetbrains.letsPlot.livemap.api.Services;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentProviderKt;
import org.jetbrains.letsPlot.livemap.config.DefaultsKt;
import org.jetbrains.letsPlot.livemap.config.DevParams;
import org.jetbrains.letsPlot.livemap.core.GeoProjection;
import org.jetbrains.letsPlot.livemap.core.Projections;
import org.jetbrains.letsPlot.livemap.geocoding.MapLocationGeocoder;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileSystemProvider;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tilesets;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportHelper;
import org.jetbrains.letsPlot.livemap.ui.CursorService;

@LiveMapDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\\\u001a\u00020]R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\"\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$\u00a2\u0006\u0002\b'0#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R&\u00102\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020&0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010;\"\u0004\b@\u0010=R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u001e\"\u0004\bI\u0010 R\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001a\u0010P\u001a\u00020QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001e\u0010V\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010[\u001a\u0004\bW\u0010X\"\u0004\bY\u0010Z\u00a8\u0006^"}, d2={"Lorg/jetbrains/letsPlot/livemap/api/LiveMapBuilder;", "", "()V", "attribution", "", "getAttribution", "()Ljava/lang/String;", "setAttribution", "(Ljava/lang/String;)V", "cursorService", "Lorg/jetbrains/letsPlot/livemap/ui/CursorService;", "getCursorService", "()Lorg/jetbrains/letsPlot/livemap/ui/CursorService;", "setCursorService", "(Lorg/jetbrains/letsPlot/livemap/ui/CursorService;)V", "devParams", "Lorg/jetbrains/letsPlot/livemap/config/DevParams;", "getDevParams", "()Lorg/jetbrains/letsPlot/livemap/config/DevParams;", "setDevParams", "(Lorg/jetbrains/letsPlot/livemap/config/DevParams;)V", "geocodingService", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;", "getGeocodingService", "()Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;", "setGeocodingService", "(Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;)V", "interactive", "", "getInteractive", "()Z", "setInteractive", "(Z)V", "isLoopY", "layers", "", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/livemap/api/FeatureLayerBuilder;", "", "Lkotlin/ExtensionFunctionType;", "getLayers", "()Ljava/util/List;", "setLayers", "(Ljava/util/List;)V", "mapLocation", "Lorg/jetbrains/letsPlot/livemap/api/MapLocation;", "getMapLocation", "()Lorg/jetbrains/letsPlot/livemap/api/MapLocation;", "setMapLocation", "(Lorg/jetbrains/letsPlot/livemap/api/MapLocation;)V", "mapLocationConsumer", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getMapLocationConsumer", "()Lkotlin/jvm/functions/Function1;", "setMapLocationConsumer", "(Lkotlin/jvm/functions/Function1;)V", "maxZoom", "", "getMaxZoom", "()I", "setMaxZoom", "(I)V", "minZoom", "getMinZoom", "setMinZoom", "projection", "Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;", "getProjection", "()Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;", "setProjection", "(Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;)V", "showCoordPickTools", "getShowCoordPickTools", "setShowCoordPickTools", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "setSize", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "tileSystemProvider", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;", "getTileSystemProvider", "()Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;", "setTileSystemProvider", "(Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;)V", "zoom", "getZoom", "()Ljava/lang/Integer;", "setZoom", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "build", "Lorg/jetbrains/letsPlot/livemap/LiveMap;", "livemap"})
public final class LiveMapBuilder {
    private boolean isLoopY;
    @NotNull
    private DoubleVector size = DoubleVector.Companion.getZERO();
    @NotNull
    private GeocodingService geocodingService = Services.INSTANCE.bogusGeocodingService();
    @NotNull
    private BasemapTileSystemProvider tileSystemProvider = Tilesets.chessboard$default(Tilesets.INSTANCE, null, null, 3, null);
    @NotNull
    private List<? extends Function1<? super FeatureLayerBuilder, Unit>> layers = CollectionsKt.emptyList();
    private boolean interactive = true;
    @Nullable
    private MapLocation mapLocation;
    @NotNull
    private GeoProjection projection = Projections.INSTANCE.mercator();
    @NotNull
    private Function1<? super DoubleRectangle, Unit> mapLocationConsumer = mapLocationConsumer.1.INSTANCE;
    @Nullable
    private String attribution;
    private boolean showCoordPickTools;
    @Nullable
    private Integer zoom;
    private int minZoom = 1;
    private int maxZoom = 15;
    @NotNull
    private CursorService cursorService = new CursorService();
    @NotNull
    private DevParams devParams = new DevParams(new HashMap());

    @NotNull
    public final DoubleVector getSize() {
        return this.size;
    }

    public final void setSize(@NotNull DoubleVector doubleVector) {
        Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"<set-?>");
        this.size = doubleVector;
    }

    @NotNull
    public final GeocodingService getGeocodingService() {
        return this.geocodingService;
    }

    public final void setGeocodingService(@NotNull GeocodingService geocodingService) {
        Intrinsics.checkNotNullParameter((Object)geocodingService, (String)"<set-?>");
        this.geocodingService = geocodingService;
    }

    @NotNull
    public final BasemapTileSystemProvider getTileSystemProvider() {
        return this.tileSystemProvider;
    }

    public final void setTileSystemProvider(@NotNull BasemapTileSystemProvider basemapTileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)basemapTileSystemProvider, (String)"<set-?>");
        this.tileSystemProvider = basemapTileSystemProvider;
    }

    @NotNull
    public final List<Function1<FeatureLayerBuilder, Unit>> getLayers() {
        return this.layers;
    }

    public final void setLayers(@NotNull List<? extends Function1<? super FeatureLayerBuilder, Unit>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.layers = list;
    }

    public final boolean getInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    @Nullable
    public final MapLocation getMapLocation() {
        return this.mapLocation;
    }

    public final void setMapLocation(@Nullable MapLocation mapLocation) {
        this.mapLocation = mapLocation;
    }

    @NotNull
    public final GeoProjection getProjection() {
        return this.projection;
    }

    public final void setProjection(@NotNull GeoProjection geoProjection) {
        Intrinsics.checkNotNullParameter((Object)geoProjection, (String)"<set-?>");
        this.projection = geoProjection;
    }

    @NotNull
    public final Function1<DoubleRectangle, Unit> getMapLocationConsumer() {
        return this.mapLocationConsumer;
    }

    public final void setMapLocationConsumer(@NotNull Function1<? super DoubleRectangle, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.mapLocationConsumer = function1;
    }

    @Nullable
    public final String getAttribution() {
        return this.attribution;
    }

    public final void setAttribution(@Nullable String string) {
        this.attribution = string;
    }

    public final boolean getShowCoordPickTools() {
        return this.showCoordPickTools;
    }

    public final void setShowCoordPickTools(boolean bl) {
        this.showCoordPickTools = bl;
    }

    @Nullable
    public final Integer getZoom() {
        return this.zoom;
    }

    public final void setZoom(@Nullable Integer n) {
        this.zoom = n;
    }

    public final int getMinZoom() {
        return this.minZoom;
    }

    public final void setMinZoom(int n) {
        this.minZoom = n;
    }

    public final int getMaxZoom() {
        return this.maxZoom;
    }

    public final void setMaxZoom(int n) {
        this.maxZoom = n;
    }

    @NotNull
    public final CursorService getCursorService() {
        return this.cursorService;
    }

    public final void setCursorService(@NotNull CursorService cursorService) {
        Intrinsics.checkNotNullParameter((Object)cursorService, (String)"<set-?>");
        this.cursorService = cursorService;
    }

    @NotNull
    public final DevParams getDevParams() {
        return this.devParams;
    }

    public final void setDevParams(@NotNull DevParams devParams) {
        Intrinsics.checkNotNullParameter((Object)devParams, (String)"<set-?>");
        this.devParams = devParams;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final LiveMap build() {
        if (!(this.minZoom <= this.maxZoom)) {
            $i$a$-require-LiveMapBuilder$build$1 = false;
            $i$a$-require-LiveMapBuilder$build$1 = "minZoom should be less than or equal to maxZoom";
            throw new IllegalArgumentException($i$a$-require-LiveMapBuilder$build$1.toString());
        }
        if (this.zoom == null) ** GOTO lbl-1000
        var1_6 = new IntRange(this.minZoom, this.maxZoom);
        $i$a$-require-LiveMapBuilder$build$1 = this.zoom;
        if ($i$a$-require-LiveMapBuilder$build$1 != null && var1_6.contains($i$a$-require-LiveMapBuilder$build$1.intValue()) != false) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        if (!v0) {
            $i$a$-require-LiveMapBuilder$build$2 = false;
            $i$a$-require-LiveMapBuilder$build$2 = "Zoom must be in range [" + this.minZoom + ", " + this.maxZoom + "], but was " + this.zoom;
            throw new IllegalArgumentException($i$a$-require-LiveMapBuilder$build$2.toString());
        }
        mapProjection = DefaultsKt.createMapProjection(this.projection);
        viewportHelper = new ViewportHelper(mapProjection.getMapRect(), this.projection.getCylindrical(), this.isLoopY);
        viewport = Viewport.Companion.create(viewportHelper, CoordinateKt.toClientPoint(this.size), (Vec<? extends World>)RectKt.getCenter(mapProjection.getMapRect()), this.minZoom, this.maxZoom);
        v1 = this.zoom;
        viewport.setZoom(v1 != null ? v1 : viewport.getMinZoom() + 1);
        var4_8 = this.mapLocation;
        return new LiveMap(viewportHelper, mapProjection, viewport, this.layers, this.tileSystemProvider, FragmentProviderKt.newFragmentProvider(this.geocodingService, this.size), this.devParams, this.mapLocationConsumer, var4_8 != null ? var4_8.getBBox(new MapLocationGeocoder(this.geocodingService, viewportHelper, mapProjection)) : null, this.zoom, this.attribution, this.showCoordPickTools, this.cursorService);
    }
}

