/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.api;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Geometry;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Ring;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Transforms;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.FeatureEntityFactory;
import org.jetbrains.letsPlot.livemap.api.GeoObject;
import org.jetbrains.letsPlot.livemap.api.LiveMapDsl;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.LocatorComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionBBoxComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionFragmentsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionRenderer;
import org.jetbrains.letsPlot.livemap.chart.polygon.PolygonLocator;
import org.jetbrains.letsPlot.livemap.chart.polygon.PolygonRenderer;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.geocoding.NeedCalculateLocationComponent;
import org.jetbrains.letsPlot.livemap.geocoding.NeedLocationComponent;
import org.jetbrains.letsPlot.livemap.geocoding.RegionIdComponent;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.RenderableComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldDimensionComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@LiveMapDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010B\u001a\u0004\u0018\u00010CJ\b\u0010D\u001a\u00020CH\u0002J\b\u0010E\u001a\u00020CH\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010'\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b(\u0010#\"\u0004\b)\u0010%R \u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00106\u001a\n\u0012\u0004\u0012\u00020!\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0010\"\u0004\b>\u0010\u0012R\u001a\u0010?\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00103\"\u0004\bA\u00105\u00a8\u0006F"}, d2={"Lorg/jetbrains/letsPlot/livemap/api/PolygonEntityBuilder;", "", "myFactory", "Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "(Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;)V", "alphaScalingEnabled", "", "getAlphaScalingEnabled", "()Z", "setAlphaScalingEnabled", "(Z)V", "fillColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getFillColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setFillColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "geoObject", "Lorg/jetbrains/letsPlot/livemap/api/GeoObject;", "getGeoObject", "()Lorg/jetbrains/letsPlot/livemap/api/GeoObject;", "setGeoObject", "(Lorg/jetbrains/letsPlot/livemap/api/GeoObject;)V", "geometry", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getGeometry", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "setGeometry", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;)V", "index", "", "getIndex", "()Ljava/lang/Integer;", "setIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "layerIndex", "getLayerIndex", "setLayerIndex", "lineDash", "", "", "getLineDash", "()Ljava/util/List;", "setLineDash", "(Ljava/util/List;)V", "lineDashOffset", "getLineDashOffset", "()D", "setLineDashOffset", "(D)V", "sizeScalingRange", "Lkotlin/ranges/ClosedRange;", "getSizeScalingRange", "()Lkotlin/ranges/ClosedRange;", "setSizeScalingRange", "(Lkotlin/ranges/ClosedRange;)V", "strokeColor", "getStrokeColor", "setStrokeColor", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "build", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "createFragmentFeature", "createPolygonFeature", "livemap"})
@SourceDebugExtension(value={"SMAP\nPolygonLayerBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonLayerBuilder.kt\norg/jetbrains/letsPlot/livemap/api/PolygonEntityBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
public final class PolygonEntityBuilder {
    @NotNull
    private final FeatureEntityFactory myFactory;
    @NotNull
    private final MapProjection myMapProjection;
    @Nullable
    private ClosedRange<Integer> sizeScalingRange;
    private boolean alphaScalingEnabled;
    @Nullable
    private Integer layerIndex;
    @Nullable
    private Integer index;
    @Nullable
    private GeoObject geoObject;
    @NotNull
    private List<Double> lineDash;
    private double lineDashOffset;
    @NotNull
    private Color strokeColor;
    private double strokeWidth;
    @NotNull
    private Color fillColor;
    @Nullable
    private MultiPolygon<LonLat> geometry;

    public PolygonEntityBuilder(@NotNull FeatureEntityFactory myFactory, @NotNull MapProjection myMapProjection) {
        Intrinsics.checkNotNullParameter((Object)myFactory, (String)"myFactory");
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        this.myFactory = myFactory;
        this.myMapProjection = myMapProjection;
        this.lineDash = CollectionsKt.emptyList();
        this.strokeColor = Color.Companion.getBLACK();
        this.fillColor = Color.Companion.getGREEN();
    }

    @Nullable
    public final ClosedRange<Integer> getSizeScalingRange() {
        return this.sizeScalingRange;
    }

    public final void setSizeScalingRange(@Nullable ClosedRange<Integer> closedRange) {
        this.sizeScalingRange = closedRange;
    }

    public final boolean getAlphaScalingEnabled() {
        return this.alphaScalingEnabled;
    }

    public final void setAlphaScalingEnabled(boolean bl) {
        this.alphaScalingEnabled = bl;
    }

    @Nullable
    public final Integer getLayerIndex() {
        return this.layerIndex;
    }

    public final void setLayerIndex(@Nullable Integer n) {
        this.layerIndex = n;
    }

    @Nullable
    public final Integer getIndex() {
        return this.index;
    }

    public final void setIndex(@Nullable Integer n) {
        this.index = n;
    }

    @Nullable
    public final GeoObject getGeoObject() {
        return this.geoObject;
    }

    public final void setGeoObject(@Nullable GeoObject geoObject) {
        this.geoObject = geoObject;
    }

    @NotNull
    public final List<Double> getLineDash() {
        return this.lineDash;
    }

    public final void setLineDash(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.lineDash = list;
    }

    public final double getLineDashOffset() {
        return this.lineDashOffset;
    }

    public final void setLineDashOffset(double d) {
        this.lineDashOffset = d;
    }

    @NotNull
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.strokeColor = color;
    }

    public final double getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(double d) {
        this.strokeWidth = d;
    }

    @NotNull
    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.fillColor = color;
    }

    @Nullable
    public final MultiPolygon<LonLat> getGeometry() {
        return this.geometry;
    }

    public final void setGeometry(@Nullable MultiPolygon<LonLat> multiPolygon) {
        this.geometry = multiPolygon;
    }

    @Nullable
    public final EcsEntity build() {
        return this.geoObject != null ? this.createFragmentFeature() : (this.geometry != null ? this.createPolygonFeature() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final EcsEntity createPolygonFeature() {
        int n;
        MultiPolygon<LonLat> multiPolygon = this.geometry;
        Intrinsics.checkNotNull(multiPolygon);
        MultiPolygon worldGeometry2 = Transforms.INSTANCE.transform(multiPolygon, (Function1)new Function1<Vec<? extends LonLat>, Vec<? extends World>>((Object)this.myMapProjection){

            @Nullable
            public final Vec<World> invoke(@NotNull Vec<? extends LonLat> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return (Vec)((MapProjection)this.receiver).apply(p0);
            }
        }, null);
        Rect rect2 = worldGeometry2.getBbox();
        if (rect2 == null) {
            throw new IllegalStateException("Polygon bbox can't be null".toString());
        }
        Rect worldBbox = rect2;
        Iterable iterable = (Iterable)worldGeometry2;
        FeatureEntityFactory featureEntityFactory = this.myFactory;
        int n2 = 0;
        for (Object t : iterable) {
            void poly;
            Polygon polygon = (Polygon)t;
            n = n2;
            boolean bl = false;
            Iterable iterable2 = (Iterable)poly;
            int n3 = 0;
            for (Object t2 : iterable2) {
                void p0;
                Ring ring = (Ring)t2;
                int n4 = n3;
                boolean bl2 = false;
                int n5 = p0.size();
                n3 = n4 + n5;
            }
            int n6 = n3;
            n2 = n + n6;
        }
        n = n2;
        featureEntityFactory.incrementLayerPointsTotalCount$livemap(n);
        return EcsEntityKt.addComponents(this.myFactory.createFeature("map_ent_s_polygon"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this, (Rect<World>)worldBbox, (MultiPolygon<World>)worldGeometry2){
            final /* synthetic */ PolygonEntityBuilder this$0;
            final /* synthetic */ Rect<World> $worldBbox;
            final /* synthetic */ MultiPolygon<World> $worldGeometry;
            {
                this.this$0 = $receiver;
                this.$worldBbox = $worldBbox;
                this.$worldGeometry = $worldGeometry;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                void $this$invoke_u24lambda_u242;
                EcsComponent $this$invoke_u24lambda_u241;
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                if (this.this$0.getLayerIndex() != null && this.this$0.getIndex() != null) {
                    Integer n = this.this$0.getLayerIndex();
                    Intrinsics.checkNotNull((Object)n);
                    int n2 = n;
                    Integer n3 = this.this$0.getIndex();
                    Intrinsics.checkNotNull((Object)n3);
                    $this$addComponents.unaryPlus(new IndexComponent(n2, n3));
                }
                EcsComponent ecsComponent = new RenderableComponent();
                MultiPolygon<World> multiPolygon = ecsComponent;
                ComponentsList componentsList = $this$addComponents;
                boolean $i$a$-apply-PolygonEntityBuilder$createPolygonFeature$2$42 = false;
                $this$invoke_u24lambda_u240.setRenderer(new PolygonRenderer());
                componentsList.unaryPlus(ecsComponent);
                ecsComponent = new ChartElementComponent();
                multiPolygon = this.this$0;
                EcsComponent $i$a$-apply-PolygonEntityBuilder$createPolygonFeature$2$42 = ecsComponent;
                componentsList = $this$addComponents;
                boolean bl = false;
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setSizeScalingRange(multiPolygon.getSizeScalingRange());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setAlphaScalingEnabled(multiPolygon.getAlphaScalingEnabled());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setLineDash(CollectionsKt.toDoubleArray((Collection)multiPolygon.getLineDash()));
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setLineDashOffset(multiPolygon.getLineDashOffset());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setFillColor(multiPolygon.getFillColor());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setStrokeColor(multiPolygon.getStrokeColor());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setStrokeWidth(multiPolygon.getStrokeWidth());
                componentsList.unaryPlus(ecsComponent);
                $this$addComponents.unaryPlus(new WorldOriginComponent((Vec<? extends World>)this.$worldBbox.getOrigin()));
                ecsComponent = new WorldGeometryComponent();
                multiPolygon = this.$worldGeometry;
                $this$invoke_u24lambda_u241 = ecsComponent;
                componentsList = $this$addComponents;
                boolean bl2 = false;
                $this$invoke_u24lambda_u242.setGeometry((Geometry<World>)Geometry.Companion.of(multiPolygon));
                componentsList.unaryPlus(ecsComponent);
                $this$addComponents.unaryPlus(new WorldDimensionComponent((Vec<? extends World>)this.$worldBbox.getDimension()));
                $this$addComponents.unaryPlus(NeedLocationComponent.INSTANCE);
                $this$addComponents.unaryPlus(NeedCalculateLocationComponent.INSTANCE);
                $this$addComponents.unaryPlus(new LocatorComponent(PolygonLocator.INSTANCE));
            }
        }));
    }

    private final EcsEntity createFragmentFeature() {
        GeoObject geoObject = this.geoObject;
        Intrinsics.checkNotNull((Object)geoObject);
        GeoObject geoObject2 = geoObject;
        return EcsEntityKt.addComponents(this.myFactory.createFeature("map_ent_geo_object_polygon_" + geoObject2.getId()), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(geoObject2, this){
            final /* synthetic */ GeoObject $geoObject;
            final /* synthetic */ PolygonEntityBuilder this$0;
            {
                this.$geoObject = $geoObject;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                void $this$invoke_u24lambda_u241;
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                EcsComponent ecsComponent = new RenderableComponent();
                Object object = ecsComponent;
                ComponentsList componentsList = $this$addComponents;
                boolean $i$a$-apply-PolygonEntityBuilder$createFragmentFeature$1$32 = false;
                $this$invoke_u24lambda_u240.setRenderer(new RegionRenderer());
                componentsList.unaryPlus(ecsComponent);
                ecsComponent = new ChartElementComponent();
                object = this.this$0;
                EcsComponent $i$a$-apply-PolygonEntityBuilder$createFragmentFeature$1$32 = ecsComponent;
                componentsList = $this$addComponents;
                boolean bl = false;
                $this$invoke_u24lambda_u241.setSizeScalingRange(((PolygonEntityBuilder)object).getSizeScalingRange());
                $this$invoke_u24lambda_u241.setFillColor(((PolygonEntityBuilder)object).getFillColor());
                $this$invoke_u24lambda_u241.setStrokeColor(((PolygonEntityBuilder)object).getStrokeColor());
                $this$invoke_u24lambda_u241.setStrokeWidth(((PolygonEntityBuilder)object).getStrokeWidth());
                componentsList.unaryPlus(ecsComponent);
                $this$addComponents.unaryPlus(new RegionIdComponent(this.$geoObject.getId()));
                $this$addComponents.unaryPlus(new RegionFragmentsComponent());
                $this$addComponents.unaryPlus(new RegionBBoxComponent(this.$geoObject.getBbox()));
                $this$addComponents.unaryPlus(NeedLocationComponent.INSTANCE);
                $this$addComponents.unaryPlus(NeedCalculateLocationComponent.INSTANCE);
            }
        }));
    }
}

