/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.api;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.BuilderKt;
import org.jetbrains.letsPlot.livemap.api.FeatureEntityFactory;
import org.jetbrains.letsPlot.livemap.api.LiveMapDsl;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.TextSpecComponent;
import org.jetbrains.letsPlot.livemap.chart.text.TextRenderer;
import org.jetbrains.letsPlot.livemap.chart.text.TextSpec;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.graphics.TextMeasurer;
import org.jetbrains.letsPlot.livemap.mapengine.RenderableComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.ScreenDimensionComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@LiveMapDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u0010\u0010R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\u001a\u0010;\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000e\"\u0004\b=\u0010\u0010R\u001a\u0010>\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u000e\"\u0004\b@\u0010\u0010R\u001a\u0010A\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u000e\"\u0004\bC\u0010\u0010R\u001a\u0010D\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u000e\"\u0004\bF\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010G\u001a\b\u0012\u0004\u0012\u00020I0HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR \u0010N\u001a\b\u0012\u0004\u0012\u00020O0HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010K\"\u0004\bQ\u0010MR\u001a\u0010R\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u000e\"\u0004\bT\u0010\u0010R\"\u0010U\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010VX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010 \"\u0004\b]\u0010\"R\u001a\u0010^\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\u000e\"\u0004\b`\u0010\u0010R\u001a\u0010a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u000e\"\u0004\bc\u0010\u0010\u00a8\u0006h"}, d2={"Lorg/jetbrains/letsPlot/livemap/api/TextEntityBuilder;", "", "myFactory", "Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;", "(Lorg/jetbrains/letsPlot/livemap/api/FeatureEntityFactory;)V", "alphaScalingEnabled", "", "getAlphaScalingEnabled", "()Z", "setAlphaScalingEnabled", "(Z)V", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "drawBorder", "getDrawBorder", "setDrawBorder", "enableNudgeScaling", "getEnableNudgeScaling", "setEnableNudgeScaling", "family", "", "getFamily", "()Ljava/lang/String;", "setFamily", "(Ljava/lang/String;)V", "fillColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getFillColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setFillColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "fontStyle", "Lorg/jetbrains/letsPlot/core/canvas/FontStyle;", "getFontStyle", "()Lorg/jetbrains/letsPlot/core/canvas/FontStyle;", "setFontStyle", "(Lorg/jetbrains/letsPlot/core/canvas/FontStyle;)V", "fontWeight", "Lorg/jetbrains/letsPlot/core/canvas/FontWeight;", "getFontWeight", "()Lorg/jetbrains/letsPlot/core/canvas/FontWeight;", "setFontWeight", "(Lorg/jetbrains/letsPlot/core/canvas/FontWeight;)V", "hjust", "getHjust", "setHjust", "index", "", "getIndex", "()I", "setIndex", "(I)V", "label", "getLabel", "setLabel", "labelPadding", "getLabelPadding", "setLabelPadding", "labelRadius", "getLabelRadius", "setLabelRadius", "labelSize", "getLabelSize", "setLabelSize", "lineheight", "getLineheight", "setLineheight", "nudgeClient", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "getNudgeClient", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "setNudgeClient", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "point", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getPoint", "setPoint", "size", "getSize", "setSize", "sizeScalingRange", "Lkotlin/ranges/ClosedRange;", "getSizeScalingRange", "()Lkotlin/ranges/ClosedRange;", "setSizeScalingRange", "(Lkotlin/ranges/ClosedRange;)V", "strokeColor", "getStrokeColor", "setStrokeColor", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "vjust", "getVjust", "setVjust", "build", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "textMeasurer", "Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;", "livemap"})
public final class TextEntityBuilder {
    @NotNull
    private final FeatureEntityFactory myFactory;
    private int index;
    @NotNull
    private Vec<? extends LonLat> point;
    @Nullable
    private ClosedRange<Integer> sizeScalingRange;
    private boolean alphaScalingEnabled;
    @NotNull
    private Color fillColor;
    @NotNull
    private Color strokeColor;
    private double strokeWidth;
    private boolean drawBorder;
    private double labelPadding;
    private double labelRadius;
    private double labelSize;
    @NotNull
    private String label;
    @NotNull
    private FontStyle fontStyle;
    @NotNull
    private FontWeight fontWeight;
    private double size;
    @NotNull
    private String family;
    private double hjust;
    private double vjust;
    private double angle;
    private double lineheight;
    @NotNull
    private Vec<? extends Client> nudgeClient;
    private boolean enableNudgeScaling;

    public TextEntityBuilder(@NotNull FeatureEntityFactory myFactory) {
        Intrinsics.checkNotNullParameter((Object)myFactory, (String)"myFactory");
        this.myFactory = myFactory;
        this.point = LonLat.Companion.getZERO_VEC();
        this.fillColor = Color.Companion.getTRANSPARENT();
        this.strokeColor = Color.Companion.getBLACK();
        this.labelPadding = 0.25;
        this.labelRadius = 0.15;
        this.labelSize = 1.0;
        this.label = "";
        this.fontStyle = FontStyle.NORMAL;
        this.fontWeight = FontWeight.NORMAL;
        this.size = 10.0;
        this.family = "Arial";
        this.lineheight = 1.0;
        this.nudgeClient = new Vec(0.0, 0.0);
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @NotNull
    public final Vec<LonLat> getPoint() {
        return this.point;
    }

    public final void setPoint(@NotNull Vec<? extends LonLat> vec) {
        Intrinsics.checkNotNullParameter(vec, (String)"<set-?>");
        this.point = vec;
    }

    @Nullable
    public final ClosedRange<Integer> getSizeScalingRange() {
        return this.sizeScalingRange;
    }

    public final void setSizeScalingRange(@Nullable ClosedRange<Integer> closedRange) {
        this.sizeScalingRange = closedRange;
    }

    public final boolean getAlphaScalingEnabled() {
        return this.alphaScalingEnabled;
    }

    public final void setAlphaScalingEnabled(boolean bl) {
        this.alphaScalingEnabled = bl;
    }

    @NotNull
    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.fillColor = color;
    }

    @NotNull
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.strokeColor = color;
    }

    public final double getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(double d) {
        this.strokeWidth = d;
    }

    public final boolean getDrawBorder() {
        return this.drawBorder;
    }

    public final void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public final double getLabelPadding() {
        return this.labelPadding;
    }

    public final void setLabelPadding(double d) {
        this.labelPadding = d;
    }

    public final double getLabelRadius() {
        return this.labelRadius;
    }

    public final void setLabelRadius(double d) {
        this.labelRadius = d;
    }

    public final double getLabelSize() {
        return this.labelSize;
    }

    public final void setLabelSize(double d) {
        this.labelSize = d;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.label = string;
    }

    @NotNull
    public final FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public final void setFontStyle(@NotNull FontStyle fontStyle) {
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"<set-?>");
        this.fontStyle = fontStyle;
    }

    @NotNull
    public final FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public final void setFontWeight(@NotNull FontWeight fontWeight) {
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"<set-?>");
        this.fontWeight = fontWeight;
    }

    public final double getSize() {
        return this.size;
    }

    public final void setSize(double d) {
        this.size = d;
    }

    @NotNull
    public final String getFamily() {
        return this.family;
    }

    public final void setFamily(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.family = string;
    }

    public final double getHjust() {
        return this.hjust;
    }

    public final void setHjust(double d) {
        this.hjust = d;
    }

    public final double getVjust() {
        return this.vjust;
    }

    public final void setVjust(double d) {
        this.vjust = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final double getLineheight() {
        return this.lineheight;
    }

    public final void setLineheight(double d) {
        this.lineheight = d;
    }

    @NotNull
    public final Vec<Client> getNudgeClient() {
        return this.nudgeClient;
    }

    public final void setNudgeClient(@NotNull Vec<? extends Client> vec) {
        Intrinsics.checkNotNullParameter(vec, (String)"<set-?>");
        this.nudgeClient = vec;
    }

    public final boolean getEnableNudgeScaling() {
        return this.enableNudgeScaling;
    }

    public final void setEnableNudgeScaling(boolean bl) {
        this.enableNudgeScaling = bl;
    }

    @NotNull
    public final EcsEntity build(@NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        TextSpec textSpec = new TextSpec(this.label, this.fontStyle, this.fontWeight, (int)this.size, this.family, this.angle, this.hjust, this.vjust, textMeasurer, this.drawBorder, this.labelPadding, this.labelRadius, this.labelSize, this.lineheight);
        return BuilderKt.setInitializer(this.myFactory.createStaticFeatureWithLocation("map_ent_s_text", this.point), (Function2<? super ComponentsList, ? super Vec<? extends World>, Unit>)((Function2)new Function2<ComponentsList, Vec<? extends World>, Unit>(this, textSpec){
            final /* synthetic */ TextEntityBuilder this$0;
            final /* synthetic */ TextSpec $textSpec;
            {
                this.this$0 = $receiver;
                this.$textSpec = $textSpec;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$setInitializer, @NotNull Vec<? extends World> worldPoint) {
                void $this$invoke_u24lambda_u243;
                EcsComponent $this$invoke_u24lambda_u242;
                EcsComponent $this$invoke_u24lambda_u241;
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$setInitializer, (String)"$this$setInitializer");
                Intrinsics.checkNotNullParameter(worldPoint, (String)"worldPoint");
                EcsComponent ecsComponent = new RenderableComponent();
                Object object = ecsComponent;
                ComponentsList componentsList = $this$setInitializer;
                boolean $i$a$-apply-TextEntityBuilder$build$1$52 = false;
                $this$invoke_u24lambda_u240.setRenderer(new TextRenderer());
                componentsList.unaryPlus(ecsComponent);
                ecsComponent = new ChartElementComponent();
                object = this.this$0;
                EcsComponent $i$a$-apply-TextEntityBuilder$build$1$52 = ecsComponent;
                componentsList = $this$setInitializer;
                boolean bl = false;
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setSizeScalingRange(((TextEntityBuilder)object).getSizeScalingRange());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setAlphaScalingEnabled(((TextEntityBuilder)object).getAlphaScalingEnabled());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setFillColor(((TextEntityBuilder)object).getFillColor());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setStrokeColor(((TextEntityBuilder)object).getStrokeColor());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setStrokeWidth(((TextEntityBuilder)object).getStrokeWidth());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setLineheight(((TextEntityBuilder)object).getLineheight());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setNudgeClient(((TextEntityBuilder)object).getNudgeClient());
                ((ChartElementComponent)$this$invoke_u24lambda_u241).setEnableNudgeScaling(((TextEntityBuilder)object).getEnableNudgeScaling());
                componentsList.unaryPlus(ecsComponent);
                ecsComponent = new TextSpecComponent();
                object = this.$textSpec;
                $this$invoke_u24lambda_u241 = ecsComponent;
                componentsList = $this$setInitializer;
                boolean bl2 = false;
                ((TextSpecComponent)$this$invoke_u24lambda_u242).setTextSpec((TextSpec)object);
                componentsList.unaryPlus(ecsComponent);
                $this$setInitializer.unaryPlus(new WorldOriginComponent(worldPoint));
                ecsComponent = new ScreenDimensionComponent();
                object = this.$textSpec;
                $this$invoke_u24lambda_u242 = ecsComponent;
                componentsList = $this$setInitializer;
                boolean bl3 = false;
                $this$invoke_u24lambda_u243.setDimension(((TextSpec)object).getDimension());
                componentsList.unaryPlus(ecsComponent);
            }
        }));
    }
}

