/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.PointComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.placement.ScreenDimensionComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/ChartElementScalingSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "alphaScalingStartingLevel", "", "updateImpl", "", "context", "dt", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nChartElementScalingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartElementScalingSystem.kt\norg/jetbrains/letsPlot/livemap/chart/ChartElementScalingSystem\n+ 2 Extensions.kt\norg/jetbrains/letsPlot/livemap/core/ecs/ExtensionsKt\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n17#2:65\n29#2,2:66\n32#2:96\n18#2:97\n24#3,2:68\n28#3,2:70\n24#3,8:72\n33#3,2:80\n24#3,12:82\n36#3:95\n1#4:94\n*S KotlinDebug\n*F\n+ 1 ChartElementScalingSystem.kt\norg/jetbrains/letsPlot/livemap/chart/ChartElementScalingSystem\n*L\n30#1:65\n30#1:66,2\n30#1:96\n30#1:97\n30#1:68,2\n54#1:70,2\n54#1:72,8\n55#1:80,2\n55#1:82,12\n55#1:95\n55#1:94\n*E\n"})
public final class ChartElementScalingSystem
extends AbstractSystem<LiveMapContext> {
    private final int alphaScalingStartingLevel;

    public ChartElementScalingSystem(@NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
        this.alphaScalingStartingLevel = 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getInitialZoom() == null) {
            return;
        }
        if (context.getCamera().isZoomLevelChanged()) {
            AbstractSystem $this$onEachEntity$iv = this;
            boolean $i$f$onEachEntity = false;
            EcsComponentManager $this$onEachEntity$iv$iv = $this$onEachEntity$iv.getComponentManager();
            boolean $i$f$onEachEntity2 = false;
            Iterator iterator = $this$onEachEntity$iv$iv.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ChartElementComponent.class)).iterator();
            while (iterator.hasNext()) {
                PointComponent it;
                EcsComponent ecsComponent;
                EcsComponent ecsComponent2;
                void chartElementComponent;
                EcsEntity entity$iv$iv;
                EcsEntity this_$iv$iv$iv = entity$iv$iv = (EcsEntity)iterator.next();
                boolean $i$f$get = false;
                EcsComponent ecsComponent3 = (ChartElementComponent)this_$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
                if (ecsComponent3 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
                }
                ChartElementComponent chartElementComponent2 = (ChartElementComponent)ecsComponent3;
                EcsEntity entity2 = entity$iv$iv;
                boolean bl = false;
                void $this$updateImpl_u24lambda_u243_u24lambda_u242 = chartElementComponent;
                boolean bl2 = false;
                if ($this$updateImpl_u24lambda_u243_u24lambda_u242.getSizeScalingRange() != null) {
                    double d;
                    ClosedRange<Integer> it2;
                    boolean bl3 = false;
                    int n = MathKt.roundToInt((double)context.getCamera().getZoom());
                    Integer n2 = context.getInitialZoom();
                    Intrinsics.checkNotNull((Object)n2);
                    int zoomDelta = n - n2;
                    int scalingLevel = RangesKt.coerceIn((int)zoomDelta, it2);
                    int alphaScalingLevel = scalingLevel - this.alphaScalingStartingLevel + 1;
                    $this$updateImpl_u24lambda_u243_u24lambda_u242.setScalingAlphaValue($this$updateImpl_u24lambda_u243_u24lambda_u242.getAlphaScalingEnabled() && alphaScalingLevel > 0 ? Integer.valueOf(MathKt.roundToInt((double)(Math.max(0.1, 1.0 - 0.2 * (double)alphaScalingLevel) * (double)255))) : null);
                    if (scalingLevel == 0) {
                        d = 1.0;
                    } else if (scalingLevel > 0) {
                        d = Math.pow(2.0, scalingLevel);
                    } else if (scalingLevel < 0) {
                        d = 1.0 / Math.pow(2.0, Math.abs(scalingLevel));
                    } else {
                        throw new IllegalStateException("Unknown".toString());
                    }
                    $this$updateImpl_u24lambda_u243_u24lambda_u242.setScalingSizeFactor(d);
                }
                EcsEntity this_$iv = entity2;
                boolean $i$f$tryGet = false;
                if (this_$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(PointComponent.class))) {
                    EcsEntity this_$iv$iv = this_$iv;
                    boolean $i$f$get2 = false;
                    ecsComponent2 = (PointComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(PointComponent.class));
                    if (ecsComponent2 == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(PointComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    ecsComponent2 = null;
                }
                if ((PointComponent)ecsComponent2 == null) continue;
                boolean bl4 = false;
                EcsEntity this_$iv2 = entity2;
                boolean $i$f$provide = false;
                if (this_$iv2.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ScreenDimensionComponent.class))) {
                    EcsEntity this_$iv$iv = this_$iv2;
                    boolean $i$f$get3 = false;
                    ecsComponent = (ScreenDimensionComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(ScreenDimensionComponent.class));
                    if (ecsComponent == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ScreenDimensionComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    boolean bl5 = false;
                    ScreenDimensionComponent screenDimensionComponent = new ScreenDimensionComponent();
                    EcsComponent it$iv = screenDimensionComponent;
                    boolean bl6 = false;
                    this_$iv2.add(it$iv);
                    ecsComponent = screenDimensionComponent;
                }
                ((ScreenDimensionComponent)ecsComponent).setDimension((Vec<? extends Client>)VecKt.times((Vec)VecKt.newVec-plX9Htw((double)it.getSize-b9qgYVc(), (double)it.getSize-b9qgYVc()), (double)$this$updateImpl_u24lambda_u243_u24lambda_u242.getScalingSizeFactor()));
            }
        }
    }
}

